/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.layout.UserFormLayoutInfo;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.Login;
import org.apache.syncope.client.enduser.pages.SelfResult;
import org.apache.syncope.client.enduser.panels.UserFormPanel;
import org.apache.syncope.client.enduser.panels.any.Details;
import org.apache.syncope.client.enduser.panels.any.SelfUserDetails;
import org.apache.syncope.client.enduser.rest.UserSelfRestClient;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.SecurityQuestionService;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class UserSelfFormPanel
extends UserFormPanel {
    private static final long serialVersionUID = 6763365006334514387L;
    private final UserSelfRestClient userSelfRestClient = new UserSelfRestClient();
    private TextField<String> securityQuestion;
    private String usernameText;

    public UserSelfFormPanel(String id, UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageReference) {
        super(id, previousUserTO, userTO, anyTypeClasses, formLayoutInfo, pageReference);
    }

    @Override
    protected Details<UserTO> addOptionalDetailsPanel(AnyWrapper<UserTO> modelObject) {
        return new SelfUserDetails("contentPanel", (UserWrapper)UserWrapper.class.cast(modelObject), false, false, ((UserFormLayoutInfo)((Object)UserFormLayoutInfo.class.cast((Object)this.formLayoutInfo))).isPasswordManagement(), this.pageReference);
    }

    @Override
    protected void onFormSubmit(AjaxRequestTarget target) {
        boolean checked = true;
        if (SyncopeEnduserApplication.get().isCaptchaEnabled()) {
            checked = this.captcha.check();
        }
        if (!checked) {
            SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("captcha_error")));
            ((BasePage)this.pageReference.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        } else {
            PageParameters parameters = new PageParameters();
            try {
                AnyWrapper updatetedWarapper = (AnyWrapper)this.form.getModelObject();
                UserTO userTO = (UserTO)updatetedWarapper.getInnerObject();
                ProvisioningResult<UserTO> result = this.userSelfRestClient.create(userTO, true);
                LOG.debug("User {} has been created", (Object)((UserTO)result.getEntity()).getUsername());
                parameters.add("status", (Object)"operation_succeeded");
                parameters.add("notificationTitle", (Object)this.getString("self.profile.change.success"));
                parameters.add("notificationMessage", (Object)this.getString("self.profile.change.success.msg"));
            }
            catch (SyncopeClientException sce) {
                parameters.add("status", (Object)"error");
                parameters.add("notificationTitle", (Object)this.getString("self.profile.change.error"));
                parameters.add("notificationMessage", (Object)this.getString("self.profile.change.error.msg"));
                SyncopeEnduserSession.get().onException((Exception)((Object)sce));
                ((BasePage)this.pageReference.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
            parameters.add("landingPage", Login.class);
            this.setResponsePage(SelfResult.class, parameters);
        }
    }

    protected void loadSecurityQuestion(PageReference pageRef, AjaxRequestTarget target) {
        try {
            SecurityQuestionTO securityQuestionTO = SyncopeEnduserSession.get().getService(SecurityQuestionService.class).readByUser(this.usernameText);
            this.securityQuestion.setModel((IModel)Model.of((Serializable)((Object)securityQuestionTO.getContent())));
            target.add(new Component[]{this.securityQuestion});
        }
        catch (Exception e) {
            LOG.error("Unable to get security question for [{}]", (Object)this.usernameText, (Object)e);
            SyncopeEnduserSession.get().onException(e);
            ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }
}

