/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.layout.UserFormLayoutInfo;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.Dashboard;
import org.apache.syncope.client.enduser.pages.SelfResult;
import org.apache.syncope.client.enduser.panels.AnyFormPanel;
import org.apache.syncope.client.enduser.panels.any.Details;
import org.apache.syncope.client.enduser.panels.any.UserDetails;
import org.apache.syncope.client.enduser.rest.UserSelfRestClient;
import org.apache.syncope.client.ui.commons.layout.UserForm;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class UserFormPanel
extends AnyFormPanel<UserTO>
implements UserForm {
    private static final long serialVersionUID = 6763365006334514387L;
    private final UserSelfRestClient userSelfRestClient = new UserSelfRestClient();

    public UserFormPanel(String id, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageReference) {
        super(id, new UserWrapper(null), anyTypeClasses, formLayoutInfo, pageReference);
        AnyWrapper modelObj = (AnyWrapper)this.newModelObject();
        this.buildLayout((AnyWrapper<UserTO>)modelObj);
    }

    public UserFormPanel(String id, UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageReference) {
        super(id, new UserWrapper(previousUserTO, userTO), anyTypeClasses, formLayoutInfo, pageReference);
        AnyWrapper modelObj = (AnyWrapper)this.newModelObject();
        this.setFormModel(modelObj);
        this.buildLayout((AnyWrapper<UserTO>)modelObj);
    }

    @Override
    protected void buildLayout(AnyWrapper<UserTO> wrapper) {
        super.buildLayout(wrapper);
    }

    @Override
    protected Details<UserTO> addOptionalDetailsPanel(AnyWrapper<UserTO> modelObject) {
        return new UserDetails("contentPanel", (UserWrapper)UserWrapper.class.cast(modelObject), false, false, this.pageReference);
    }

    @Override
    protected void onFormSubmit(AjaxRequestTarget target) {
        boolean checked = true;
        if (SyncopeEnduserApplication.get().isCaptchaEnabled()) {
            checked = this.captcha.check();
        }
        if (!checked) {
            SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("captcha_error")));
            ((BasePage)this.pageReference.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        } else {
            PageParameters parameters = new PageParameters();
            try {
                AnyWrapper updatetedWarapper = (AnyWrapper)this.form.getModelObject();
                UserTO userTO = (UserTO)updatetedWarapper.getInnerObject();
                this.fixPlainAndVirAttrs((AnyTO)userTO, ((AnyWrapper)this.getOriginalItem()).getInnerObject());
                UserPatch patch = AnyOperations.diff((UserTO)userTO, (UserTO)((UserTO)((AnyWrapper)this.getOriginalItem()).getInnerObject()), (boolean)false);
                if (patch.isEmpty()) {
                    ProvisioningResult result = new ProvisioningResult();
                    result.setEntity((EntityTO)userTO);
                } else {
                    ProvisioningResult<UserTO> result = this.userSelfRestClient.update(((UserTO)((AnyWrapper)this.getOriginalItem()).getInnerObject()).getETagValue(), patch);
                    LOG.debug("User {} has been modified", (Object)((UserTO)result.getEntity()).getUsername());
                }
                parameters.add("status", (Object)"operation_succeeded");
                parameters.add("notificationTitle", (Object)this.getString("self.profile.change.success"));
                parameters.add("notificationMessage", (Object)this.getString("self.profile.change.success.msg"));
            }
            catch (SyncopeClientException sce) {
                parameters.add("status", (Object)"error");
                parameters.add("notificationTitle", (Object)this.getString("self.profile.change.error"));
                parameters.add("notificationMessage", (Object)this.getString("self.profile.change.error.msg"));
                SyncopeEnduserSession.get().onException((Exception)((Object)sce));
                ((BasePage)this.pageReference.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
            parameters.add("landingPage", (Object)SyncopeEnduserApplication.get().getPageClass("profile", Dashboard.class).getName());
            this.setResponsePage(SelfResult.class, parameters);
        }
    }
}

