/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.password.strength.PasswordStrengthBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.password.strength.PasswordStrengthConfig;
import java.io.Serializable;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.Login;
import org.apache.syncope.client.enduser.pages.SelfResult;
import org.apache.syncope.client.ui.commons.panels.CardPanel;
import org.apache.syncope.client.ui.commons.wizards.any.PasswordPanel;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class SelfConfirmPasswordReset
extends BasePage {
    private static final long serialVersionUID = -2166782304542750726L;
    private static final String CONFIRM_PASSWORD_RESET = "confirmPasswordReset";

    public SelfConfirmPasswordReset(final PageParameters parameters) {
        super(parameters, CONFIRM_PASSWORD_RESET);
        this.setDomain(parameters);
        this.disableSidebar();
        if (parameters == null || parameters.get("token").isEmpty()) {
            LOG.error("No token parameter found in the request url");
            parameters.add("errorMessage", (Object)this.getString("self.confirm.pwd.reset.error.empty"));
            this.setResponsePage(this.getApplication().getHomePage(), parameters);
        }
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        this.contentWrapper.add(new Component[]{content});
        StatelessForm form = new StatelessForm("selfConfirmPwdResetForm");
        form.setOutputMarkupId(true);
        content.add(new Component[]{form});
        final UserTO fakeUserTO = new UserTO();
        PasswordPanel passwordPanel = new PasswordPanel("contentPanel", new UserWrapper(fakeUserTO), false, Boolean.valueOf(false), new PasswordStrengthBehavior(new PasswordStrengthConfig().withDebug(false).withShowVerdictsInsideProgressBar(true).withShowProgressBar(true)));
        passwordPanel.setOutputMarkupId(true);
        form.add(new Component[]{new CardPanel.Builder().setName("selfConfirmPasswordResetPanel").setComponent((Component)passwordPanel).isVisible(true).build("selfConfirmPasswordResetPanelCard")});
        AjaxButton submit = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = 509325877101838812L;

            protected void onSubmit(AjaxRequestTarget target) {
                PageParameters params = new PageParameters();
                try {
                    SyncopeEnduserSession.get().getService(UserSelfService.class).confirmPasswordReset(parameters.get("token").toString(), fakeUserTO.getPassword());
                    params.add("status", (Object)"operation_succeeded");
                    params.add("notificationTitle", (Object)this.getString("self.confirm.pwd.reset.success"));
                    params.add("notificationMessage", (Object)this.getString("self.confirm.pwd.reset.success.msg"));
                    SyncopeEnduserSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    parameters.add("landingPage", (Object)Login.class.getName());
                    this.setResponsePage(SelfResult.class, params);
                }
                catch (SyncopeClientException sce) {
                    LOG.error("Unable to complete the 'Password Reset Confirmation' process", (Throwable)sce);
                    params.add("status", (Object)"operation_error");
                    params.add("notificationTitle", (Object)this.getString("self.confirm.pwd.reset.error"));
                    params.add("notificationMessage", (Object)this.getString("self.confirm.pwd.reset.error.msg"));
                    SyncopeEnduserSession.get().onException((Exception)((Object)sce));
                    ((BasePage)SelfConfirmPasswordReset.this.getPageReference().getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                SelfConfirmPasswordReset.this.notificationPanel.refresh((IPartialPageRequestHandler)target);
            }
        };
        form.setDefaultButton((IFormSubmittingComponent)submit);
        form.add(new Component[]{submit});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 3669569969172391336L;

            public void onSubmit() {
                this.setResponsePage(this.getApplication().getHomePage());
            }
        };
        cancel.setOutputMarkupId(true);
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
    }
}

