/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.markup.html.form;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.FileInputConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.FileinputJsReference;
import de.agilecoders.wicket.jquery.JQuery;
import de.agilecoders.wicket.jquery.function.IFunction;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.commons.PreviewUtils;
import org.apache.syncope.client.enduser.markup.html.form.BinaryFieldDownload;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.ui.commons.HttpResourceStream;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.AbstractBinaryPreviewer;
import org.apache.syncope.client.ui.commons.rest.ResponseHolder;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.lang.Bytes;

public class BinaryFieldPanel
extends FieldPanel<String> {
    private static final long serialVersionUID = 6264462604183088931L;
    private static final PreviewUtils PREVIEW_UTILS = PreviewUtils.getInstance();
    private final String mimeType;
    private final WebMarkupContainer container;
    private final AjaxLink<Void> downloadLink;
    private final Form<?> uploadForm;
    private final Fragment emptyFragment;
    private final BootstrapFileInputField fileUpload;
    private final BinaryFieldDownload fileDownload;
    private final AbstractBinaryPreviewer previewer;
    private final IndicatingAjaxLink<Void> resetLink;
    private final Bytes maxUploadSize;
    private final IModel<String> model;
    private final String fileKey;

    public BinaryFieldPanel(String id, String name, IModel<String> model, String mimeType, String fileKey) {
        super(id, name, model);
        this.model = model;
        this.fileKey = fileKey;
        this.mimeType = mimeType;
        this.previewer = PREVIEW_UTILS.getPreviewer(mimeType);
        this.maxUploadSize = SyncopeEnduserApplication.get().getMaxUploadFileSizeMB() == null ? null : Bytes.megabytes((long)SyncopeEnduserApplication.get().getMaxUploadFileSizeMB().intValue());
        this.uploadForm = new StatelessForm("uploadForm");
        this.uploadForm.setMultiPart(true);
        this.add(new Component[]{this.uploadForm});
        this.container = new WebMarkupContainer("previewContainer"){
            private static final long serialVersionUID = 2628490926588791229L;

            public void renderHead(IHeaderResponse response) {
                if (BinaryFieldPanel.this.previewer == null) {
                    FileinputJsReference.INSTANCE.renderHead(response);
                    JQuery fileinputJS = JQuery.$((Component)BinaryFieldPanel.this.fileUpload).chain(new IFunction(){
                        private static final long serialVersionUID = -2285418135375523652L;

                        public String build() {
                            return "fileinput({'showRemove':false, 'showUpload':false, 'previewFileType':'any'})";
                        }
                    });
                    response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)fileinputJS.get()));
                }
            }
        };
        this.container.setOutputMarkupId(true);
        this.emptyFragment = new Fragment("panelPreview", "emptyFragment", (MarkupContainer)this.container);
        this.emptyFragment.setOutputMarkupId(true);
        this.container.add(new Component[]{this.emptyFragment});
        this.uploadForm.add(new Component[]{this.container});
        this.field = new TextField("textField", model);
        this.add(new Component[]{this.field.setLabel((IModel)new ResourceModel(name, name)).setOutputMarkupId(true)});
        this.uploadForm.add(new Component[]{new Label("preview", (Serializable)((Object)(StringUtils.isBlank((CharSequence)mimeType) ? "" : "(" + mimeType + ")")))});
        this.fileDownload = new BinaryFieldDownload(name, fileKey, mimeType, true){
            private static final long serialVersionUID = 7203445884857810583L;

            @Override
            protected HttpResourceStream getResourceStream() {
                return new HttpResourceStream(new ResponseHolder(BinaryFieldPanel.this.buildResponse()));
            }
        };
        this.add(new Behavior[]{this.fileDownload});
        this.downloadLink = new AjaxLink<Void>("downloadLink"){
            private static final long serialVersionUID = -4331619903296515985L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    BinaryFieldPanel.this.fileDownload.initiate(target);
                }
                catch (Exception e) {
                    SyncopeEnduserSession.get().onException(e);
                }
            }
        };
        this.downloadLink.setOutputMarkupId(true);
        this.uploadForm.add(new Component[]{this.downloadLink});
        FileInputConfig config = new FileInputConfig();
        config.showUpload(false);
        config.showRemove(false);
        config.showPreview(false);
        this.fileUpload = new BootstrapFileInputField("fileUpload", (IModel)new ListModel(new ArrayList()), config);
        this.fileUpload.setOutputMarkupId(true);
        this.fileUpload.add(new Behavior[]{new AjaxFormSubmitBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onSubmit(AjaxRequestTarget target) {
                FileUpload uploadedFile = BinaryFieldPanel.this.fileUpload.getFileUpload();
                if (uploadedFile != null) {
                    if (BinaryFieldPanel.this.maxUploadSize != null && uploadedFile.getSize() > BinaryFieldPanel.this.maxUploadSize.bytes()) {
                        SyncopeEnduserSession.get().error((Serializable)((Object)BinaryFieldPanel.this.getString("tooLargeFile").replace("${maxUploadSizeB}", String.valueOf(BinaryFieldPanel.this.maxUploadSize.bytes())).replace("${maxUploadSizeMB}", String.valueOf(BinaryFieldPanel.this.maxUploadSize.bytes() / 1000000L))));
                        ((BasePage)BinaryFieldPanel.this.getPageReference().getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    } else {
                        byte[] uploadedBytes = uploadedFile.getBytes();
                        String uploaded = Base64.getEncoder().encodeToString(uploadedBytes);
                        BinaryFieldPanel.this.field.setModelObject((Object)uploaded);
                        target.add(new Component[]{BinaryFieldPanel.this.field});
                        if (BinaryFieldPanel.this.previewer == null) {
                            BinaryFieldPanel.this.container.addOrReplace(new Component[]{BinaryFieldPanel.this.emptyFragment});
                        } else {
                            Component panelPreview = BinaryFieldPanel.this.previewer.preview(uploadedBytes);
                            BinaryFieldPanel.this.changePreviewer(panelPreview);
                            BinaryFieldPanel.this.fileUpload.setModelObject(null);
                            BinaryFieldPanel.this.uploadForm.addOrReplace(new Component[]{BinaryFieldPanel.this.fileUpload});
                        }
                        BinaryFieldPanel.this.setVisibleFileButtons(StringUtils.isNotBlank((CharSequence)uploaded));
                        BinaryFieldPanel.this.downloadLink.setEnabled(StringUtils.isNotBlank((CharSequence)uploaded));
                        target.add(new Component[]{BinaryFieldPanel.this.uploadForm});
                    }
                }
            }
        }});
        this.uploadForm.add(new Component[]{this.fileUpload});
        this.resetLink = new IndicatingAjaxLink<Void>("resetLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                BinaryFieldPanel.this.field.setModelObject(null);
                target.add(new Component[]{BinaryFieldPanel.this.field});
                BinaryFieldPanel.this.downloadLink.setEnabled(false);
                BinaryFieldPanel.this.container.addOrReplace(new Component[]{BinaryFieldPanel.this.emptyFragment});
                BinaryFieldPanel.this.setVisibleFileButtons(false);
                target.add(new Component[]{BinaryFieldPanel.this.uploadForm});
            }

            public String getAjaxIndicatorMarkupId() {
                return "veil";
            }
        };
        this.uploadForm.add(new Component[]{this.resetLink});
    }

    private Response buildResponse() {
        return Response.ok((Object)new ByteArrayInputStream(Base64.getMimeDecoder().decode((String)((Object)this.getModelObject())))).type(StringUtils.isBlank((CharSequence)this.mimeType) ? "application/octet-stream" : this.mimeType).header("Location", (Object)"").build();
    }

    private void changePreviewer(Component panelPreview) {
        Fragment fragment = new Fragment("panelPreview", "previewFragment", (MarkupContainer)this.container);
        fragment.add(new Component[]{panelPreview});
        this.container.addOrReplace(new Component[]{fragment});
        this.uploadForm.addOrReplace(new Component[]{this.container});
    }

    private void setVisibleFileButtons(boolean visible) {
        this.resetLink.setVisible(visible);
        this.downloadLink.setVisible(visible);
    }

    public BinaryFieldPanel clone() {
        LOG.debug("Custom clone for binary field panel...");
        return new BinaryFieldPanel(this.getId(), this.name, this.model, this.mimeType, this.fileKey);
    }

    public FieldPanel<String> setNewModel(IModel<String> model) {
        Object panelPreview;
        this.field.setModel(model);
        String modelObj = (String)model.getObject();
        if (StringUtils.isNotBlank((CharSequence)modelObj) && (panelPreview = this.previewer == null ? PREVIEW_UTILS.getDefaultPreviewer(this.mimeType) : this.previewer.preview(modelObj)) != null) {
            this.changePreviewer((Component)panelPreview);
        }
        this.downloadLink.setEnabled(StringUtils.isNotBlank((CharSequence)modelObj));
        this.setVisibleFileButtons(StringUtils.isNotBlank((CharSequence)modelObj));
        return this;
    }

    public FieldPanel<String> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.fileUpload.setEnabled(!readOnly);
        return this;
    }
}

