/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.rest;

import java.util.Collections;
import java.util.List;
import org.apache.syncope.client.enduser.rest.BaseRestClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.rest.api.service.SyncopeService;

public class SyncopeRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -2211371717449597247L;

    public static List<String> listAnyTypeClasses() {
        List types = Collections.emptyList();
        try {
            types = SyncopeRestClient.getService(SyncopeService.class).platform().getAnyTypeClasses();
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading all any type classes", (Throwable)e);
        }
        return types;
    }

    public static List<String> searchUserTypeExtensions(String groupName) {
        List types = Collections.emptyList();
        try {
            TypeExtensionTO typeExtensionTO = SyncopeRestClient.getService(SyncopeService.class).readUserTypeExtension(groupName);
            types = typeExtensionTO == null ? types : typeExtensionTO.getAuxClasses();
        }
        catch (Exception e) {
            LOG.error("While reading all any type classes for group [{}]", (Object)groupName, (Object)e);
        }
        return types;
    }
}

