/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.commons.PageParametersUtils;
import org.apache.syncope.client.enduser.commons.RESTUtils;
import org.apache.syncope.client.enduser.layout.UserFormLayoutInfo;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.SelfResult;
import org.apache.syncope.client.enduser.panels.UserFormPanel;
import org.apache.syncope.client.enduser.panels.any.Details;
import org.apache.syncope.client.enduser.panels.any.SelfUserDetails;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.rest.api.service.SecurityQuestionService;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class UserSelfFormPanel
extends UserFormPanel {
    private static final long serialVersionUID = 6763365006334514387L;
    private TextField<String> securityQuestion;
    private String usernameText;

    public UserSelfFormPanel(String id, UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageReference) {
        super(id, previousUserTO, userTO, anyTypeClasses, formLayoutInfo, pageReference);
    }

    @Override
    protected Details<UserTO> addOptionalDetailsPanel(AnyWrapper<UserTO> modelObject) {
        return new SelfUserDetails("contentPanel", (UserWrapper)UserWrapper.class.cast(modelObject), false, false, ((UserFormLayoutInfo)((Object)UserFormLayoutInfo.class.cast((Object)this.formLayoutInfo))).isPasswordManagement(), this.pageReference);
    }

    @Override
    protected void onFormSubmit(AjaxRequestTarget target) {
        if (SyncopeEnduserApplication.get().isCaptchaEnabled() && !this.captcha.check()) {
            SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("captcha_error")));
            ((BasePage)this.pageReference.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        } else {
            try {
                this.setResponsePage(SelfResult.class, PageParametersUtils.managePageParams((Component)this, "profile.change", RESTUtils.create((UserTO)((AnyWrapper)this.form.getModelObject()).getInnerObject()).getPropagationStatuses().stream().filter(ps -> ExecStatus.SUCCESS != ps.getStatus()).collect(Collectors.toList())));
            }
            catch (SyncopeClientException e) {
                LOG.error("While creating user {}", (Object)((UserTO)((AnyWrapper)this.form.getModelObject()).getInnerObject()).getUsername(), (Object)e);
                SyncopeEnduserSession.get().onException((Exception)((Object)e));
                ((BasePage)this.pageReference.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }
    }

    protected void loadSecurityQuestion(PageReference pageRef, AjaxRequestTarget target) {
        try {
            SecurityQuestionTO securityQuestionTO = SyncopeEnduserSession.get().getService(SecurityQuestionService.class).readByUser(this.usernameText);
            this.securityQuestion.setModel((IModel)Model.of((Serializable)((Object)securityQuestionTO.getContent())));
            target.add(new Component[]{this.securityQuestion});
        }
        catch (Exception e) {
            LOG.error("Unable to get security question for [{}]", (Object)this.usernameText, (Object)e);
            SyncopeEnduserSession.get().onException(e);
            ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }
}

