/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.markup.html.form;

import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.init.MIMETypesLoader;
import org.apache.syncope.client.ui.commons.HttpResourceStream;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.time.Duration;

public abstract class BinaryFieldDownload
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 7203445884857810583L;
    private static final MIMETypesLoader MIME_TYPES_LOADER = (MIMETypesLoader)SyncopeEnduserApplication.get().getServletContext().getAttribute("MIMETYPES_LOADER");
    private final String name;
    private String fileKey;
    private String mimeType;
    private final boolean addAntiCache;

    public BinaryFieldDownload(String name, boolean addAntiCache) {
        this.name = name;
        this.addAntiCache = addAntiCache;
    }

    public BinaryFieldDownload(String name, String fileKey, String mimeType, boolean addAntiCache) {
        this(name, addAntiCache);
        this.fileKey = fileKey;
        this.mimeType = mimeType;
    }

    public void initiate(AjaxRequestTarget target) {
        String url = this.getCallbackUrl().toString();
        if (this.addAntiCache) {
            url = url + (url.contains("?") ? "&" : "?");
            url = url + "antiCache=" + System.currentTimeMillis();
        }
        target.appendJavaScript((CharSequence)("setTimeout(\"window.location.href='" + url + "'\", 100);"));
    }

    public void onRequest() {
        HttpResourceStream stream = this.getResourceStream();
        ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler((IResourceStream)stream);
        String key = StringUtils.isNotBlank((CharSequence)this.fileKey) ? this.fileKey + "_" : "";
        String ext = "";
        if (StringUtils.isNotBlank((CharSequence)this.mimeType)) {
            String extByMimeType = MIME_TYPES_LOADER.getFileExt(this.mimeType);
            ext = StringUtils.isBlank((CharSequence)extByMimeType) ? ".bin" : "." + extByMimeType;
        }
        String fileName = key + (stream.getFilename() == null ? this.name : stream.getFilename()) + ext;
        handler.setFileName(fileName);
        handler.setContentDisposition(ContentDisposition.ATTACHMENT);
        handler.setCacheDuration(Duration.NONE);
        this.getComponent().getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)handler);
    }

    protected abstract HttpResourceStream getResourceStream();
}

