/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.SingleThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserRequestCycleListener;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.enduser.layout.UserFormLayoutInfo;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.Dashboard;
import org.apache.syncope.client.enduser.pages.Login;
import org.apache.syncope.client.enduser.pages.MustChangePassword;
import org.apache.syncope.client.enduser.pages.SelfConfirmPasswordReset;
import org.apache.syncope.client.enduser.panels.Sidebar;
import org.apache.syncope.client.enduser.themes.AdminLTE;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.client.ui.commons.annotations.Resource;
import org.apache.syncope.common.lib.PropertyUtils;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.DomainService;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.servlet.AbstractRequestWrapperFactory;
import org.apache.wicket.protocol.http.servlet.XForwardedRequestWrapperFactory;
import org.apache.wicket.protocol.ws.WebSocketAwareCsrfPreventionRequestCycleListener;
import org.apache.wicket.protocol.ws.api.WebSocketResponse;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryResourceReference;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeEnduserApplication
extends AuthenticatedWebApplication {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeEnduserApplication.class);
    private static final String ENDUSER_PROPERTIES = "enduser.properties";
    private static final String CUSTOM_FORM_LAYOUT_FILE = "customFormLayout.json";
    public static final List<Locale> SUPPORTED_LOCALES = Collections.unmodifiableList(Arrays.asList(Locale.ENGLISH, Locale.CANADA_FRENCH, Locale.ITALIAN, Locale.JAPANESE, new Locale("pt", "BR"), new Locale("ru")));
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String anonymousUser;
    private String anonymousKey;
    private String scheme;
    private String host;
    private String port;
    private String rootPath;
    private String useGZIPCompression;
    private Integer maxUploadFileSizeMB;
    private Integer maxWaitTime;
    private boolean captchaEnabled;
    private List<String> domains;
    private String adminUser;
    private Class<? extends Sidebar> sidebar;
    private Map<String, Class<? extends BasePage>> pageClasses;
    private UserFormLayoutInfo customFormLayout;

    public static SyncopeEnduserApplication get() {
        return (SyncopeEnduserApplication)WebApplication.get();
    }

    protected void populatePageClasses(Properties props) {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String className = (String)propNames.nextElement();
            if (!className.startsWith("page.")) continue;
            try {
                Class clazz = ClassUtils.getClass((String)props.getProperty(className));
                if (BasePage.class.isAssignableFrom(clazz)) {
                    this.pageClasses.put(StringUtils.substringAfter((String)className, (String)"page."), clazz);
                    continue;
                }
                LOG.warn("{} does not extend {}, ignoring...", (Object)clazz.getName(), (Object)BasePage.class.getName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("While looking for class identified by property '{}'", (Object)className, (Object)e);
            }
        }
    }

    protected void setSecurityHeaders(Properties props, WebResponse response) {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            if (!name.startsWith("security.headers.")) continue;
            response.setHeader(StringUtils.substringAfter((String)name, (String)"security.headers."), props.getProperty(name));
        }
    }

    protected void init() {
        super.init();
        final Properties props = (Properties)PropertyUtils.read(((Object)((Object)this)).getClass(), (String)ENDUSER_PROPERTIES, (String)"enduser.directory").getLeft();
        this.anonymousUser = props.getProperty("anonymousUser");
        Args.notNull((Object)this.anonymousUser, (String)"<anonymousUser>");
        this.anonymousKey = props.getProperty("anonymousKey");
        Args.notNull((Object)this.anonymousKey, (String)"<anonymousKey>");
        this.adminUser = props.getProperty("adminUser", "admin");
        Args.notNull((Object)this.adminUser, (String)"<adminUser>");
        this.scheme = props.getProperty("scheme");
        Args.notNull((Object)this.scheme, (String)"<scheme>");
        this.host = props.getProperty("host");
        Args.notNull((Object)this.host, (String)"<host>");
        this.port = props.getProperty("port");
        Args.notNull((Object)this.port, (String)"<port>");
        this.rootPath = props.getProperty("rootPath");
        Args.notNull((Object)this.rootPath, (String)"<rootPath>");
        this.useGZIPCompression = props.getProperty("useGZIPCompression");
        Args.notNull((Object)this.useGZIPCompression, (String)"<useGZIPCompression>");
        this.maxUploadFileSizeMB = props.getProperty("maxUploadFileSizeMB") == null ? null : Integer.valueOf(props.getProperty("maxUploadFileSizeMB"));
        this.maxWaitTime = Integer.valueOf(props.getProperty("maxWaitTimeOnApplyChanges", "30"));
        this.captchaEnabled = Boolean.parseBoolean(props.getProperty("captcha"));
        Args.notNull((Object)this.captchaEnabled, (String)"<captcha>");
        this.pageClasses = new HashMap<String, Class<? extends BasePage>>();
        this.populatePageClasses(props);
        this.pageClasses = Collections.unmodifiableMap(this.pageClasses);
        this.buildSidebarClass(props);
        BootstrapSettings settings = new BootstrapSettings();
        settings.setThemeProvider((ThemeProvider)new SingleThemeProvider((ITheme)new AdminLTE()));
        Bootstrap.install((Application)this, (IBootstrapSettings)settings);
        this.getResourceSettings().setUseMinifiedResources(true);
        this.getResourceSettings().setUseDefaultOnMissingResource(true);
        this.getResourceSettings().setThrowExceptionOnMissingResource(false);
        this.getJavaScriptLibrarySettings().setJQueryReference((ResourceReference)JQueryResourceReference.getV2());
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new MetaDataRoleAuthorizationStrategy((IRoleCheckingStrategy)this));
        this.getMarkupSettings().setStripWicketTags(true);
        this.getMarkupSettings().setCompressWhitespace(true);
        if (BooleanUtils.toBoolean((String)props.getProperty("x-forward"))) {
            XForwardedRequestWrapperFactory.Config config = new XForwardedRequestWrapperFactory.Config();
            config.setProtocolHeader(props.getProperty("x-forward.protocol.header", "X-Forwarded-Proto"));
            config.setHttpServerPort(Integer.valueOf(props.getProperty("x-forward.http.port", "80")).intValue());
            config.setHttpsServerPort(Integer.valueOf(props.getProperty("x-forward.https.port", "443")).intValue());
            XForwardedRequestWrapperFactory factory = new XForwardedRequestWrapperFactory();
            factory.setConfig(config);
            this.getFilterFactoryManager().add((AbstractRequestWrapperFactory)factory);
        }
        if (BooleanUtils.toBoolean((String)props.getProperty("csrf"))) {
            this.getRequestCycleListeners().add((Object)new WebSocketAwareCsrfPreventionRequestCycleListener());
        }
        this.getRequestCycleListeners().add((Object)new SyncopeEnduserRequestCycleListener());
        this.getRequestCycleListeners().add((Object)new IRequestCycleListener(){

            public void onEndRequest(RequestCycle cycle) {
                if (cycle.getResponse() instanceof WebResponse && !(cycle.getResponse() instanceof WebSocketResponse)) {
                    SyncopeEnduserApplication.this.setSecurityHeaders(props, (WebResponse)cycle.getResponse());
                }
            }
        });
        this.mountPage("/login", this.getSignInPageClass());
        this.mountPage("/confirmpasswordreset", SelfConfirmPasswordReset.class);
        ClassPathScanImplementationLookup lookup = (ClassPathScanImplementationLookup)this.getServletContext().getAttribute("CLASSPATH_LOOKUP");
        for (Class clazz : lookup.getResources()) {
            Resource annotation = clazz.getAnnotation(Resource.class);
            try {
                final AbstractResource instance = (AbstractResource)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.mountResource(annotation.path(), new ResourceReference(annotation.key()){
                    private static final long serialVersionUID = -128426276529456602L;

                    public IResource getResource() {
                        return instance;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Could not instantiate {}", (Object)clazz.getName(), (Object)e);
            }
        }
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/customFormLayout.json");){
            File customFormLayoutFile;
            boolean existsEnduserDir;
            this.customFormLayout = (UserFormLayoutInfo)((Object)MAPPER.readValue(inputStream, (TypeReference)new TypeReference<UserFormLayoutInfo>(){}));
            File enduserDir = new File(props.getProperty("enduser.directory"));
            boolean bl = existsEnduserDir = enduserDir.exists() && enduserDir.canRead() && enduserDir.isDirectory();
            if (existsEnduserDir && (customFormLayoutFile = FileUtils.getFile((File)enduserDir, (String[])new String[]{CUSTOM_FORM_LAYOUT_FILE})).exists() && customFormLayoutFile.canRead() && customFormLayoutFile.isFile()) {
                this.customFormLayout = (UserFormLayoutInfo)((Object)MAPPER.readValue((InputStream)FileUtils.openInputStream((File)customFormLayoutFile), (TypeReference)new TypeReference<UserFormLayoutInfo>(){}));
            }
            FileAlterationObserver observer = existsEnduserDir ? new FileAlterationObserver(enduserDir, pathname -> StringUtils.contains((CharSequence)pathname.getPath(), (CharSequence)CUSTOM_FORM_LAYOUT_FILE)) : new FileAlterationObserver(((Object)((Object)this)).getClass().getResource("/customFormLayout.json").getFile(), pathname -> StringUtils.contains((CharSequence)pathname.getPath(), (CharSequence)CUSTOM_FORM_LAYOUT_FILE));
            FileAlterationMonitor customFormLayoutMonitor = new FileAlterationMonitor(5000L);
            FileAlterationListenerAdaptor listener = new FileAlterationListenerAdaptor(){

                public void onFileChange(File file) {
                    try {
                        LOG.trace("{} has changed. Reloading form attributes customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_FORM_LAYOUT_FILE);
                        SyncopeEnduserApplication.this.customFormLayout = (UserFormLayoutInfo)((Object)MAPPER.readValue((InputStream)FileUtils.openInputStream((File)file), (TypeReference)new TypeReference<UserFormLayoutInfo>(){}));
                    }
                    catch (IOException e) {
                        LOG.error("{} While reading app customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_FORM_LAYOUT_FILE, (Object)e);
                    }
                }

                public void onFileCreate(File file) {
                    try {
                        LOG.trace("{} has been created. Loading form attributes customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_FORM_LAYOUT_FILE);
                        SyncopeEnduserApplication.this.customFormLayout = (UserFormLayoutInfo)((Object)MAPPER.readValue((InputStream)FileUtils.openInputStream((File)file), (TypeReference)new TypeReference<UserFormLayoutInfo>(){}));
                    }
                    catch (IOException e) {
                        LOG.error("{} While reading app customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_FORM_LAYOUT_FILE, (Object)e);
                    }
                }

                public void onFileDelete(File file) {
                    LOG.trace("{} has been deleted. Resetting form attributes customization configuration.", (Object)SyncopeEnduserApplication.CUSTOM_FORM_LAYOUT_FILE);
                    SyncopeEnduserApplication.this.customFormLayout = null;
                }
            };
            observer.addListener((FileAlterationListener)listener);
            customFormLayoutMonitor.addObserver(observer);
            customFormLayoutMonitor.start();
        }
        catch (Exception exception) {
            throw new WicketRuntimeException("Could not read customFormLayout.json", (Throwable)exception);
        }
        if (this.getDebugSettings().isAjaxDebugModeEnabled()) {
            this.getDebugSettings().setComponentPathAttributeName("syncope-path");
        }
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return SyncopeEnduserSession.class;
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return Login.class;
    }

    public Class<? extends Page> getHomePage() {
        return SyncopeEnduserSession.get().isAuthenticated() && SyncopeEnduserSession.get().getSelfTO().isMustChangePassword() ? MustChangePassword.class : (SyncopeEnduserSession.get().isAuthenticated() ? this.getPageClass("profile", Dashboard.class) : Login.class);
    }

    public Class<? extends BasePage> getPageClass(String key) {
        return this.pageClasses.get(key);
    }

    public Class<? extends BasePage> getPageClass(String key, Class<? extends BasePage> defaultValue) {
        return this.pageClasses.getOrDefault(key, defaultValue);
    }

    public String getAnonymousUser() {
        return this.anonymousUser;
    }

    public String getAnonymousKey() {
        return this.anonymousKey;
    }

    public Integer getMaxUploadFileSizeMB() {
        return this.maxUploadFileSizeMB;
    }

    public Integer getMaxWaitTimeInSeconds() {
        return this.maxWaitTime;
    }

    public boolean isCaptchaEnabled() {
        return this.captchaEnabled;
    }

    public SyncopeClientFactoryBean newClientFactory() {
        return new SyncopeClientFactoryBean().setAddress(this.scheme + "://" + this.host + ":" + this.port + StringUtils.prependIfMissing((String)this.rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0])).setUseCompression(BooleanUtils.toBoolean((String)this.useGZIPCompression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDomains() {
        Logger logger = LOG;
        synchronized (logger) {
            if (this.domains == null) {
                this.domains = ((DomainService)this.newClientFactory().create((AuthenticationHandler)new AnonymousAuthenticationHandler(this.anonymousUser, this.anonymousKey)).getService(DomainService.class)).list().stream().map(EntityTO::getKey).collect(Collectors.toList());
                this.domains.add(0, "Master");
                this.domains = ListUtils.unmodifiableList(this.domains);
            }
        }
        return this.domains;
    }

    public static void extractAttrsFromExt(String extAttrs, UserTO userTO) {
        try {
            Set attrs = (Set)MAPPER.readValue(extAttrs, (TypeReference)new TypeReference<Set<AttrTO>>(){});
            Optional<AttrTO> username = attrs.stream().filter(attr -> attr.getSchema().equals("username")).findFirst();
            if (username.isPresent()) {
                userTO.setUsername((String)username.get().getValues().get(0));
                attrs.remove(username.get());
            }
            userTO.getPlainAttrs().addAll(attrs);
        }
        catch (IOException e) {
            LOG.error("While extracting ext attributes", (Throwable)e);
        }
    }

    private void buildSidebarClass(Properties props) {
        try {
            Class clazz = ClassUtils.getClass((String)props.getProperty("sidebar", Sidebar.class.getCanonicalName()));
            if (Sidebar.class.isAssignableFrom(clazz)) {
                this.sidebar = clazz;
            } else {
                LOG.warn("{} does not extend {}, ignoring...", (Object)clazz.getName(), (Object)Sidebar.class.getName());
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("While looking for class identified by property 'sidebar'", (Throwable)e);
        }
    }

    public Class<? extends Sidebar> getSidebar() {
        return this.sidebar;
    }

    public String getAdminUser() {
        return this.adminUser;
    }

    public UserFormLayoutInfo getCustomFormLayout() {
        return this.customFormLayout;
    }

    public void setCustomFormLayout(UserFormLayoutInfo customFormAttributes) {
        this.customFormLayout = customFormAttributes;
    }
}

