/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import java.io.Serializable;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class SyncopeEnduserSession
extends AuthenticatedWebSession
implements BaseSession {
    private static final long serialVersionUID = 747562246415852166L;
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeEnduserSession.class);
    private final SyncopeClientFactoryBean clientFactory;
    private final SyncopeClient anonymousClient;
    private final PlatformInfo platformInfo;
    private final SystemInfo systemInfo;
    private final Map<Class<?>, Object> services = Collections.synchronizedMap(new HashMap());
    private final ThreadPoolTaskExecutor executor;
    private String domain;
    private SyncopeClient client;
    private UserTO selfTO;

    public static SyncopeEnduserSession get() {
        return (SyncopeEnduserSession)Session.get();
    }

    public SyncopeEnduserSession(Request request) {
        super(request);
        this.clientFactory = SyncopeEnduserApplication.get().newClientFactory();
        this.anonymousClient = this.clientFactory.create((AuthenticationHandler)new AnonymousAuthenticationHandler(SyncopeEnduserApplication.get().getAnonymousUser(), SyncopeEnduserApplication.get().getAnonymousKey()));
        this.platformInfo = this.getAnonymousService(SyncopeService.class).platform();
        this.systemInfo = this.getAnonymousService(SyncopeService.class).system();
        this.executor = new ThreadPoolTaskExecutor();
        this.executor.setWaitForTasksToCompleteOnShutdown(false);
        this.executor.initialize();
    }

    protected String message(SyncopeClientException sce) {
        return sce.getType().name() + ": " + sce.getElements().stream().collect(Collectors.joining(", "));
    }

    public void onException(Exception e) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)e);
        String message = root.getMessage();
        if (root instanceof SyncopeClientException) {
            SyncopeClientException sce = (SyncopeClientException)root;
            message = sce.isComposite() ? sce.asComposite().getExceptions().stream().map(this::message).collect(Collectors.joining("; ")) : this.message(sce);
        } else if (root instanceof AccessControlException || root instanceof ForbiddenException) {
            Error error = StringUtils.containsIgnoreCase((CharSequence)message, (CharSequence)"expired") ? Error.SESSION_EXPIRED : Error.AUTHORIZATION;
            message = this.getApplication().getResourceSettings().getLocalizer().getString(error.key(), null, null, null, null, error.fallback());
        } else if (root instanceof BadRequestException || root instanceof WebServiceException) {
            message = this.getApplication().getResourceSettings().getLocalizer().getString(Error.REST.key(), null, null, null, null, Error.REST.fallback());
        }
        message = this.getApplication().getResourceSettings().getLocalizer().getString(message, null, null, null, null, message);
        this.error((Serializable)((Object)message));
    }

    public MediaType getMediaType() {
        return this.clientFactory.getContentType().getMediaType();
    }

    public SyncopeClient getAnonymousClient() {
        return this.anonymousClient;
    }

    public void execute(Runnable command) {
        try {
            this.executor.execute(command);
        }
        catch (TaskRejectedException e) {
            LOG.error("Could not execute {}", (Object)command, (Object)e);
        }
    }

    public <T> Future<T> execute(Callable<T> command) {
        try {
            return this.executor.submit(command);
        }
        catch (TaskRejectedException e) {
            LOG.error("Could not execute {}", command, (Object)e);
            return new CompletableFuture();
        }
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return StringUtils.isBlank((CharSequence)this.domain) ? "Master" : this.domain;
    }

    public String getJWT() {
        return this.client == null ? null : this.client.getJWT();
    }

    public Roles getRoles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PlatformInfo getPlatformInfo() {
        return this.platformInfo;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public boolean authenticate(String username, String password) {
        boolean authenticated = false;
        if (SyncopeEnduserApplication.get().getAdminUser().equalsIgnoreCase(username)) {
            return authenticated;
        }
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(username, password);
            this.afterAuthentication(username);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    public boolean authenticate(String jwt) {
        boolean authenticated = false;
        try {
            this.client = this.clientFactory.setDomain(this.getDomain()).create(jwt);
            this.afterAuthentication(null);
            authenticated = true;
        }
        catch (Exception e) {
            LOG.error("Authentication failed", (Throwable)e);
        }
        return authenticated;
    }

    private void afterAuthentication(String username) {
        try {
            this.selfTO = (UserTO)this.client.self().getRight();
        }
        catch (ForbiddenException e) {
            LOG.warn("Could not read self(), probably in a {} scenario", (Object)"MUST_CHANGE_PASSWORD", (Object)e);
            this.selfTO = new UserTO();
            this.selfTO.setUsername(username);
            this.selfTO.setMustChangePassword(true);
        }
        this.bind();
    }

    public boolean isAuthenticated() {
        return this.client != null && this.client.getJWT() != null;
    }

    public void cleanup() {
        this.client = null;
        this.selfTO = null;
        this.services.clear();
    }

    public void invalidate() {
        if (this.isAuthenticated()) {
            try {
                this.client.logout();
            }
            catch (Exception e) {
                LOG.debug("Unexpected exception while logging out", (Throwable)e);
            }
            finally {
                this.client = null;
                this.selfTO = null;
            }
        }
        super.invalidate();
    }

    public UserTO getSelfTO() {
        return this.getSelfTO(false);
    }

    public UserTO getSelfTO(boolean reload) {
        if (reload) {
            this.afterAuthentication(this.selfTO.getUsername());
        }
        return this.selfTO;
    }

    private <T> T getCachedService(Class<T> serviceClass) {
        Object service;
        if (this.services.containsKey(serviceClass)) {
            service = this.services.get(serviceClass);
        } else {
            service = this.client.getService(serviceClass);
            this.services.put(serviceClass, service);
        }
        WebClient.client((Object)service).type("application/json").accept(new String[]{"application/json"});
        return (T)service;
    }

    public <T> T getService(Class<T> serviceClass) {
        Object service = this.client == null || !this.isAuthenticated() ? this.anonymousClient.getService(serviceClass) : this.client.getService(serviceClass);
        WebClient.client((Object)service).header("X-Syncope-Domain", new Object[]{this.getDomain()});
        return (T)service;
    }

    public <T> T getService(String etag, Class<T> serviceClass) {
        T serviceInstance = this.getService(serviceClass);
        WebClient.client(serviceInstance).match(new EntityTag(etag), false).type("application/json").accept(new String[]{"application/json"});
        return serviceInstance;
    }

    public <T> void resetClient(Class<T> service) {
        T serviceInstance = this.getCachedService(service);
        WebClient.client(serviceInstance).reset();
    }

    public FastDateFormat getDateFormat() {
        return FastDateFormat.getDateTimeInstance((int)3, (int)3, (Locale)this.getLocale());
    }

    public <T> T getAnonymousService(Class<T> serviceClass) {
        return (T)this.getAnonymousClient().getService(serviceClass);
    }

    public static enum Error {
        SESSION_EXPIRED("error.session.expired", "Session expired: please login again"),
        AUTHORIZATION("error.authorization", "Insufficient access rights when performing the requested operation"),
        REST("error.rest", "There was an error while contacting the Core server");

        private final String key;
        private final String fallback;

        private Error(String key, String fallback) {
            this.key = key;
            this.fallback = fallback;
        }

        public String key() {
            return this.key;
        }

        public String fallback() {
            return this.fallback;
        }
    }
}

