/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.common.util.StringUtils;
import org.apache.syncope.client.enduser.layout.CustomizationOption;
import org.apache.syncope.client.enduser.panels.any.DerAttrs;
import org.apache.syncope.client.enduser.panels.any.PlainAttrs;
import org.apache.syncope.client.enduser.panels.any.VirAttrs;
import org.apache.syncope.client.enduser.rest.SchemaRestClient;
import org.apache.syncope.client.enduser.rest.SyncopeRestClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public abstract class AbstractAttrs<S extends SchemaTO>
extends Panel {
    private static final long serialVersionUID = -5387344116983102292L;
    protected static final String FORM_SUFFIX = "form_";
    protected final Comparator<AttrTO> attrComparator = new AttrComparator();
    protected final AnyTO anyTO;
    private final Map<String, CustomizationOption> whichAttrs;
    protected final Map<String, S> schemas = new LinkedHashMap<String, S>();
    protected final Map<String, Map<String, S>> membershipSchemas = new LinkedHashMap<String, Map<String, S>>();
    protected final IModel<List<AttrTO>> attrs;
    protected final IModel<List<MembershipTO>> membershipTOs;
    private final List<String> anyTypeClasses;

    public AbstractAttrs(String id, AnyWrapper<?> modelObject, List<String> anyTypeClasses, Map<String, CustomizationOption> whichAttrs) {
        super(id);
        this.anyTypeClasses = anyTypeClasses;
        this.attrs = new ListModel(Collections.emptyList());
        this.membershipTOs = new ListModel(Collections.emptyList());
        this.setOutputMarkupId(true);
        this.anyTO = modelObject.getInnerObject();
        this.whichAttrs = whichAttrs;
        this.evaluate();
    }

    private List<AttrTO> loadAttrs() {
        ArrayList<String> classes = new ArrayList<String>(this.anyTypeClasses);
        classes.addAll(this.anyTO.getAuxClasses());
        this.setSchemas(classes);
        this.setAttrs();
        return this.getAttrsFromTO();
    }

    private List<MembershipTO> loadMembershipAttrs() {
        ArrayList<MembershipTO> memberships = new ArrayList<MembershipTO>();
        try {
            this.membershipSchemas.clear();
            for (MembershipTO membership : (List)PropertyResolver.getPropertyField((String)"memberships", (Object)this.anyTO).get(this.anyTO)) {
                this.setSchemas((Pair<String, String>)Pair.of((Object)membership.getGroupKey(), (Object)membership.getGroupName()), AbstractAttrs.getMembershipAuxClasses(membership, this.anyTO.getType()));
                this.setAttrs(membership);
                if (this instanceof PlainAttrs && !membership.getPlainAttrs().isEmpty()) {
                    memberships.add(membership);
                    continue;
                }
                if (this instanceof DerAttrs && !membership.getDerAttrs().isEmpty()) {
                    memberships.add(membership);
                    continue;
                }
                if (!(this instanceof VirAttrs) || membership.getVirAttrs().isEmpty()) continue;
                memberships.add(membership);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | WicketRuntimeException throwable) {
            // empty catch block
        }
        return memberships;
    }

    protected boolean filterSchemas() {
        return !this.whichAttrs.isEmpty();
    }

    protected boolean renderAsReadonly(String schema, String groupName) {
        String schemaName = (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)groupName) ? "" : groupName + '#') + schema;
        return this.whichAttrs.get(schemaName) == null ? false : this.whichAttrs.get(schemaName).isReadonly();
    }

    protected List<String> getDefaultValues(String schema) {
        return this.getDefaultValues(schema, null);
    }

    protected List<String> getDefaultValues(String schema, String groupName) {
        String schemaName = (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)groupName) ? "" : groupName + '#') + schema;
        return this.whichAttrs.get(schemaName) == null ? Collections.emptyList() : this.whichAttrs.get(schemaName).getDefaultValues();
    }

    protected abstract SchemaType getSchemaType();

    private void setSchemas(Pair<String, String> membership, List<String> anyTypeClasses) {
        Map<Object, Object> mscs;
        if (this.membershipSchemas.containsKey(membership.getKey())) {
            mscs = this.membershipSchemas.get(membership.getKey());
        } else {
            mscs = new LinkedHashMap();
            this.membershipSchemas.put((String)membership.getKey(), mscs);
        }
        this.setSchemas(anyTypeClasses, (String)membership.getValue(), mscs);
    }

    private void setSchemas(List<String> anyTypeClasses) {
        this.setSchemas(anyTypeClasses, null, this.schemas);
    }

    private void setSchemas(List<String> anyTypeClasses, String groupName, Map<String, S> scs) {
        List<Object> allSchemas = anyTypeClasses.isEmpty() ? new ArrayList() : SchemaRestClient.getSchemas(this.getSchemaType(), null, anyTypeClasses.toArray(new String[0]));
        scs.clear();
        if (this.filterSchemas()) {
            allSchemas.removeAll(allSchemas.stream().filter(schemaTO -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)groupName) ? !this.whichAttrs.containsKey(schemaTO.getKey()) : !this.whichAttrs.containsKey(groupName + '#' + schemaTO.getKey())).collect(Collectors.toSet()));
        }
        allSchemas.forEach(schemaTO -> scs.put(schemaTO.getKey(), schemaTO));
    }

    public boolean isPanelVisible() {
        return !((List)this.attrs.getObject()).isEmpty() || !((List)this.membershipTOs.getObject()).isEmpty();
    }

    protected abstract void setAttrs();

    protected abstract void setAttrs(MembershipTO var1);

    protected abstract List<AttrTO> getAttrsFromTO();

    protected abstract List<AttrTO> getAttrsFromTO(MembershipTO var1);

    protected static List<String> getMembershipAuxClasses(MembershipTO membershipTO, String anyType) {
        try {
            return SyncopeRestClient.searchUserTypeExtensions(membershipTO.getGroupName());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    protected void onInitialize() {
        this.evaluate();
        super.onInitialize();
    }

    public boolean evaluate() {
        this.attrs.setObject(this.loadAttrs());
        this.membershipTOs.setObject(this.loadMembershipAttrs());
        return !((List)this.attrs.getObject()).isEmpty() || !((List)this.membershipTOs.getObject()).isEmpty();
    }

    public PageReference getPageReference() {
        return null;
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof AjaxPalettePanel.UpdateActionEvent) {
            this.evaluate();
            AjaxPalettePanel.UpdateActionEvent updateEvent = (AjaxPalettePanel.UpdateActionEvent)event.getPayload();
            updateEvent.getTarget().add(new Component[]{this});
        }
    }

    public static class Schemas
    extends Panel {
        private static final long serialVersionUID = -2447602429647965090L;

        public Schemas(String id) {
            super(id);
        }
    }

    private class AttrComparator
    implements Comparator<AttrTO>,
    Serializable {
        private static final long serialVersionUID = -5105030477767941060L;

        private AttrComparator() {
        }

        @Override
        public int compare(AttrTO left, AttrTO right) {
            if (left == null || StringUtils.isEmpty((String)left.getSchema())) {
                return -1;
            }
            if (right == null || StringUtils.isEmpty((String)right.getSchema())) {
                return 1;
            }
            if (AbstractAttrs.this.filterSchemas()) {
                int rightIndex;
                int leftIndex = new ArrayList(AbstractAttrs.this.whichAttrs.keySet()).indexOf(left.getSchema());
                if (leftIndex > (rightIndex = new ArrayList(AbstractAttrs.this.whichAttrs.keySet()).indexOf(right.getSchema()))) {
                    return 1;
                }
                if (leftIndex < rightIndex) {
                    return -1;
                }
                return 0;
            }
            return left.getSchema().compareTo(right.getSchema());
        }
    }
}

