/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.enduser.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.Dashboard;
import org.apache.syncope.client.enduser.pages.EditChangePassword;
import org.apache.syncope.client.enduser.pages.EditSecurityQuestion;
import org.apache.syncope.client.enduser.pages.EditUser;
import org.apache.syncope.client.ui.commons.annotations.ExtPage;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;

public class Sidebar
extends Panel {
    private static final long serialVersionUID = 8091307811313529503L;
    private final List<WebMarkupContainer> navbarItems = new ArrayList<WebMarkupContainer>();
    protected WebMarkupContainer profileULContainer;
    protected WebMarkupContainer profileLIContainer;

    public Sidebar(String id, PageReference pageReference, List<Class<? extends BasePage>> extPageClasses) {
        super(id);
        this.buildBaseSidebar();
        RepeatingView listItems = new RepeatingView("listItems");
        this.add(new Component[]{listItems});
        extPageClasses.forEach(ext -> {
            WebMarkupContainer list = new WebMarkupContainer(listItems.newChildId());
            BookmarkablePageLink externalLink = new BookmarkablePageLink("extPageLILink", ext);
            ExtPage ann = ext.getAnnotation(ExtPage.class);
            externalLink.add(new Component[]{new Label("extPageIcon").add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)("fa " + ann.icon())))})});
            externalLink.add(new Component[]{new Label("extPageLabel", (Serializable)((Object)ann.label()))});
            list.add(new Component[]{externalLink});
            listItems.add(new Component[]{list});
        });
        Component containingLI = this.get(this.getLIContainerId(pageReference.getPage().getClass().getSimpleName().toLowerCase()));
        if (containingLI == null) {
            containingLI = this.profileULContainer.get(this.getLIContainerId(pageReference.getPage().getClass().getSimpleName().toLowerCase()));
        }
        if (containingLI != null) {
            containingLI.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1469628524240283489L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    tag.put("class", (CharSequence)"active");
                }
            }});
            if (this.profileULContainer.getId().equals(containingLI.getParent().getId())) {
                this.profileULContainer.add(new Behavior[]{new Behavior(){
                    private static final long serialVersionUID = 3109256773218160485L;

                    public void onComponentTag(Component component, ComponentTag tag) {
                        tag.put("class", (CharSequence)"treeview-menu menu-open");
                        tag.put("style", (CharSequence)"display: block;");
                    }
                }});
                this.profileLIContainer.add(new Behavior[]{new Behavior(){
                    private static final long serialVersionUID = 3109256773218160485L;

                    public void onComponentTag(Component component, ComponentTag tag) {
                        tag.put("class", (CharSequence)"treeview active");
                    }
                }});
            }
        }
    }

    protected void buildBaseSidebar() {
        WebMarkupContainer liContainer = new WebMarkupContainer(this.getLIContainerId("home"));
        this.add(new Component[]{liContainer});
        liContainer.add(new Component[]{BookmarkablePageLinkBuilder.build("home", SyncopeEnduserApplication.get().getPageClass("profile", Dashboard.class))});
        this.profileLIContainer = new WebMarkupContainer(this.getLIContainerId("profile"));
        this.add(new Component[]{this.profileLIContainer});
        this.profileULContainer = new WebMarkupContainer(this.getULContainerId("profile"));
        this.profileLIContainer.add(new Component[]{this.profileULContainer});
        this.profileLIContainer.setVisible(SyncopeEnduserApplication.get().getCustomFormLayout().getSidebarLayout().isEditUserEnabled() || SyncopeEnduserApplication.get().getCustomFormLayout().getSidebarLayout().isPasswordManagementEnabled() || SyncopeEnduserApplication.get().getCustomFormLayout().getSidebarLayout().isSecurityQuestionManagementEnabled() && SyncopeEnduserSession.get().getPlatformInfo().isPwdResetRequiringSecurityQuestions());
        this.profileULContainer.add(new Component[]{new WebMarkupContainer(this.getLIContainerId("edituser")).add(new Component[]{BookmarkablePageLinkBuilder.build("edituser", EditUser.class)}).setVisible(SyncopeEnduserApplication.get().getCustomFormLayout().getSidebarLayout().isEditUserEnabled())});
        this.profileULContainer.add(new Component[]{new WebMarkupContainer(this.getLIContainerId("editchangepassword")).add(new Component[]{BookmarkablePageLinkBuilder.build("editchangepassword", EditChangePassword.class)}).setVisible(SyncopeEnduserApplication.get().getCustomFormLayout().getSidebarLayout().isPasswordManagementEnabled())});
        this.profileULContainer.add(new Component[]{new WebMarkupContainer(this.getLIContainerId("editsecurityquestion")).add(new Component[]{BookmarkablePageLinkBuilder.build("editsecurityquestion", EditSecurityQuestion.class)}).setOutputMarkupPlaceholderTag(true).setVisible(SyncopeEnduserApplication.get().getCustomFormLayout().getSidebarLayout().isSecurityQuestionManagementEnabled() && SyncopeEnduserSession.get().getPlatformInfo().isPwdResetRequiringSecurityQuestions())});
    }

    protected String getLIContainerId(String linkId) {
        return linkId + "LI";
    }

    protected String getULContainerId(String linkId) {
        return linkId + "UL";
    }

    public void setActiveNavItem(String id) {
        this.navbarItems.stream().filter(containingLI -> containingLI.getMarkupId().equals(id)).findFirst().ifPresent(found -> found.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = -5775607340182293596L;

            public void onComponentTag(Component component, ComponentTag tag) {
                tag.put("class", (CharSequence)"active");
            }
        }}));
    }
}

