/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.select.BootstrapSelect;
import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.enduser.pages.SelfPasswordReset;
import org.apache.syncope.client.enduser.pages.SelfRegistration;
import org.apache.syncope.client.ui.commons.StyledNotificationBehavior;
import org.apache.syncope.client.ui.commons.panels.NotificationPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Login
extends WebPage {
    private static final long serialVersionUID = 5889157642852559004L;
    private static final Logger LOG = LoggerFactory.getLogger(Login.class);
    private final NotificationPanel notificationPanel;
    protected String notificationMessage;
    protected String notificationLevel;
    private final StatelessForm<Void> form;
    private final TextField<String> usernameField;
    private final TextField<String> passwordField;
    private final BookmarkablePageLink<Void> selfPwdReset;
    private final BookmarkablePageLink<Void> selfRegistration;

    public Login(PageParameters parameters) {
        super(parameters);
        this.setStatelessHint(true);
        this.notificationPanel = new NotificationPanel("feedback");
        this.add(new Component[]{this.notificationPanel});
        if (!parameters.get("notificationMessage").isNull()) {
            this.notificationMessage = parameters.get("notificationMessage").toString();
            this.notificationLevel = parameters.get("notificationLevel").isEmpty() ? "success" : parameters.get("notificationLevel").toString();
        }
        Label exceptionMessage = new Label("exceptionMessage");
        exceptionMessage.setOutputMarkupPlaceholderTag(true);
        exceptionMessage.setVisible(false);
        if (!parameters.get("errorMessage").isNull()) {
            exceptionMessage.setVisible(true);
            exceptionMessage.setDefaultModel((IModel)Model.of((Serializable)parameters.get("errorMessage")));
        }
        this.add(new Component[]{exceptionMessage});
        this.form = new StatelessForm("login");
        this.usernameField = new TextField("username", (IModel)new Model());
        this.usernameField.setMarkupId("username");
        this.form.add(new Component[]{this.usernameField});
        this.passwordField = new PasswordTextField("password", (IModel)new Model());
        this.passwordField.setMarkupId("password");
        this.form.add(new Component[]{this.passwordField});
        LocaleDropDown languageSelect = new LocaleDropDown("language");
        languageSelect.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("blur"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{Login.this.form});
            }
        }}).add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{Login.this.form});
            }
        }});
        this.form.add(new Component[]{languageSelect.setOutputMarkupId(true)});
        DomainDropDown domainSelect = new DomainDropDown("domain");
        domainSelect.setOutputMarkupPlaceholderTag(true);
        if (SyncopeEnduserApplication.get().getDomains().size() == 1) {
            domainSelect.setVisible(false);
        }
        domainSelect.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("blur"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{Login.this.form});
            }
        }}).add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{Login.this.form});
            }
        }});
        this.form.add(new Component[]{domainSelect.setOutputMarkupId(true)});
        AjaxButton submitButton = new AjaxButton("submit", (IModel)new Model((Serializable)((Object)this.getString("submit")))){
            private static final long serialVersionUID = 429178684321093953L;

            protected void onSubmit(AjaxRequestTarget target) {
                if (SyncopeEnduserApplication.get().getAnonymousUser().equals(Login.this.usernameField.getRawInput())) {
                    throw new AccessControlException("Illegal username");
                }
                IAuthenticationStrategy strategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy();
                if (AuthenticatedWebSession.get().signIn(Login.this.usernameField.getRawInput(), Login.this.passwordField.getRawInput())) {
                    this.continueToOriginalDestination();
                    this.setResponsePage(this.getApplication().getHomePage());
                } else {
                    SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("login-error")));
                    Login.this.notificationPanel.refresh((IPartialPageRequestHandler)target);
                }
                strategy.remove();
            }
        };
        submitButton.setDefaultFormProcessing(false);
        this.form.add(new Component[]{submitButton});
        this.form.setDefaultButton((IFormSubmittingComponent)submitButton);
        ClassPathScanImplementationLookup classPathScanImplementationLookup = (ClassPathScanImplementationLookup)SyncopeEnduserApplication.get().getServletContext().getAttribute("CLASSPATH_LOOKUP");
        ArrayList ssoLoginFormPanels = new ArrayList();
        classPathScanImplementationLookup.getSSOLoginFormPanels().forEach(ssoLoginFormPanel -> {
            try {
                ssoLoginFormPanels.add(ssoLoginFormPanel.getConstructor(String.class).newInstance("ssoLogin"));
            }
            catch (Exception e) {
                LOG.error("Could not initialize the provided SSO login form panel", (Throwable)e);
            }
        });
        ListView<Panel> ssoLogins = new ListView<Panel>("ssoLogins", ssoLoginFormPanels){
            private static final long serialVersionUID = -9180479401817023838L;

            protected void populateItem(ListItem<Panel> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        };
        this.form.add(new Component[]{ssoLogins});
        this.add(new Component[]{this.form});
        this.selfPwdReset = new BookmarkablePageLink("self-pwd-reset", SelfPasswordReset.class);
        this.selfPwdReset.getPageParameters().add("domain", (Object)SyncopeEnduserSession.get().getDomain());
        this.selfPwdReset.setOutputMarkupPlaceholderTag(true);
        this.selfPwdReset.setVisible(SyncopeEnduserSession.get().getPlatformInfo().isPwdResetAllowed());
        this.add(new Component[]{this.selfPwdReset.setOutputMarkupId(true)});
        this.selfRegistration = new BookmarkablePageLink("self-registration", SelfRegistration.class);
        this.selfRegistration.getPageParameters().add("domain", (Object)SyncopeEnduserSession.get().getDomain());
        this.selfRegistration.setOutputMarkupPlaceholderTag(true);
        this.selfRegistration.setVisible(SyncopeEnduserSession.get().getPlatformInfo().isSelfRegAllowed());
        this.add(new Component[]{this.selfRegistration.setOutputMarkupId(true)});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (StringUtils.isNotBlank((CharSequence)this.notificationMessage)) {
            response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)StyledNotificationBehavior.jQueryShow((CharSequence)this.notificationMessage, (String)String.format("jQuery('#%s').data('kendoNotification')", this.notificationPanel.getNotificationMarkupId()), (String)this.notificationLevel)));
        }
    }

    private static class DomainDropDown
    extends BootstrapSelect<String> {
        private static final long serialVersionUID = -7401167913360133325L;

        DomainDropDown(String id) {
            super(id, SyncopeEnduserApplication.get().getDomains());
            this.setModel((IModel)new IModel<String>(){
                private static final long serialVersionUID = -1124206668056084806L;

                public String getObject() {
                    return SyncopeEnduserSession.get().getDomain();
                }

                public void setObject(String object) {
                    SyncopeEnduserSession.get().setDomain(object);
                }

                public void detach() {
                }
            });
            this.getModel().setObject((Object)"Master");
        }
    }

    private class LocaleDropDown
    extends BootstrapSelect<Locale> {
        private static final long serialVersionUID = 2349382679992357202L;

        LocaleDropDown(String id) {
            super(id, SyncopeEnduserApplication.SUPPORTED_LOCALES);
            this.setChoiceRenderer((IChoiceRenderer)new LocaleRenderer());
            this.setModel((IModel)new IModel<Locale>(){
                private static final long serialVersionUID = -6985170095629312963L;

                public Locale getObject() {
                    return LocaleDropDown.this.getSession().getLocale();
                }

                public void setObject(Locale object) {
                    LocaleDropDown.this.getSession().setLocale(object);
                }

                public void detach() {
                }
            });
            List<Object> filtered = Collections.emptyList();
            String acceptLanguage = ((ServletWebRequest)RequestCycle.get().getRequest()).getHeader("Accept-Language");
            if (StringUtils.isNotBlank((CharSequence)acceptLanguage)) {
                try {
                    filtered = Locale.filter(Locale.LanguageRange.parse(acceptLanguage), SyncopeEnduserApplication.SUPPORTED_LOCALES);
                }
                catch (Exception e) {
                    LOG.debug("Could not parse {} HTTP header value '{}'", new Object[]{"Accept-Language", acceptLanguage, e});
                }
            }
            this.getModel().setObject((Object)(filtered.isEmpty() ? Locale.ENGLISH : (Locale)filtered.get(0)));
        }

        private class LocaleRenderer
        extends ChoiceRenderer<Locale> {
            private static final long serialVersionUID = -3657529581555164741L;

            private LocaleRenderer() {
            }

            public String getDisplayValue(Locale locale) {
                return locale.getDisplayName(LocaleDropDown.this.getLocale());
            }
        }
    }
}

