/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.rest;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.syncope.client.enduser.rest.BaseRestClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.rest.api.service.AnyTypeService;

public class AnyTypeRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -2211371717449597247L;
    public static final Comparator<String> KEY_COMPARATOR = new AnyTypeKeyComparator();

    public static AnyTypeTO read(String key) {
        AnyTypeTO type = null;
        try {
            type = AnyTypeRestClient.getService(AnyTypeService.class).read(key);
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading all any types", (Throwable)e);
        }
        return type;
    }

    public static List<AnyTypeTO> listAnyTypes() {
        List types = Collections.emptyList();
        try {
            types = AnyTypeRestClient.getService(AnyTypeService.class).list();
            types.sort(new AnyTypeComparator());
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading all any types", (Throwable)e);
        }
        return types;
    }

    public static List<String> list() {
        List types = AnyTypeRestClient.getSyncopeService().platform().getAnyTypes();
        types.sort(new AnyTypeKeyComparator());
        return types;
    }

    public static void create(AnyTypeTO anyTypeTO) {
        AnyTypeRestClient.getService(AnyTypeService.class).create(anyTypeTO);
    }

    public static void update(AnyTypeTO anyTypeTO) {
        AnyTypeRestClient.getService(AnyTypeService.class).update(anyTypeTO);
    }

    public static void delete(String key) {
        AnyTypeRestClient.getService(AnyTypeService.class).delete(key);
    }

    private static class AnyTypeKeyComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -7778622183107320760L;

        private AnyTypeKeyComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if ("REALM".equals(o1)) {
                return -1;
            }
            if ("REALM".equals(o2)) {
                return 1;
            }
            if (AnyTypeKind.USER.name().equals(o1)) {
                return -1;
            }
            if (AnyTypeKind.USER.name().equals(o2)) {
                return 1;
            }
            if (AnyTypeKind.GROUP.name().equals(o1)) {
                return -1;
            }
            if (AnyTypeKind.GROUP.name().equals(2)) {
                return 1;
            }
            return ObjectUtils.compare((Comparable)((Object)o1), (Comparable)((Object)o2));
        }
    }

    private static class AnyTypeComparator
    implements Comparator<AnyTypeTO>,
    Serializable {
        private static final long serialVersionUID = -8227715253094467138L;

        private AnyTypeComparator() {
        }

        @Override
        public int compare(AnyTypeTO o1, AnyTypeTO o2) {
            if (o1.getKind() == AnyTypeKind.USER) {
                return -1;
            }
            if (o2.getKind() == AnyTypeKind.USER) {
                return 1;
            }
            if (o1.getKind() == AnyTypeKind.GROUP) {
                return -1;
            }
            if (o2.getKind() == AnyTypeKind.GROUP) {
                return 1;
            }
            return ObjectUtils.compare((Comparable)((Object)o1.getKey()), (Comparable)((Object)o2.getKey()));
        }
    }
}

