/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels.any;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.rest.GroupRestClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.wizards.any.AbstractGroups;
import org.apache.syncope.client.ui.commons.wizards.any.AbstractGroupsModel;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class Groups
extends AbstractGroups {
    private static final long serialVersionUID = 552437609667518888L;
    private final EnduserGroupsModel groupsModel = new EnduserGroupsModel();

    public <T extends AnyTO> Groups(String id, AnyWrapper<T> modelObject, boolean templateMode) {
        super(id, modelObject);
        this.setOutputMarkupId(true);
        this.addDynamicGroupsContainer();
        this.addGroupsPanel();
        this.addDynamicRealmsContainer();
    }

    private Function<AjaxRequestTarget, Boolean> getEventFunction() {
        return (Function<AjaxRequestTarget, Boolean> & Serializable)target -> {
            this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new AjaxPalettePanel.UpdateActionEvent((UserTO)this.anyTO, target));
            return true;
        };
    }

    protected void addGroupsPanel() {
        if (this.anyTO instanceof GroupTO) {
            this.groupsContainer.add(new Component[]{new Label("groups").setVisible(false)});
            this.groupsContainer.setVisible(false);
        } else {
            AjaxPalettePanel.Builder builder = new AjaxPalettePanel.Builder().setRenderer((IChoiceRenderer)new IChoiceRenderer<MembershipTO>(){
                private static final long serialVersionUID = -3086661086073628855L;

                public Object getDisplayValue(MembershipTO object) {
                    return object.getGroupName();
                }

                public String getIdValue(MembershipTO object, int index) {
                    return object.getGroupName();
                }

                public MembershipTO getObject(String id, IModel<? extends List<? extends MembershipTO>> choices) {
                    return ((List)choices.getObject()).stream().filter(object -> id.equalsIgnoreCase(object.getGroupName())).findAny().orElse(null);
                }
            }).event(this.getEventFunction());
            this.groupsContainer.add(new Component[]{builder.setAllowOrder(true).withFilter().build("groups", (IModel)new ListModel<MembershipTO>(){
                private static final long serialVersionUID = -2583290457773357445L;

                public List<MembershipTO> getObject() {
                    return Groups.this.groupsModel.getMemberships();
                }
            }, (AjaxPalettePanel.Builder.Query)new AjaxPalettePanel.Builder.Query<MembershipTO>(){
                private static final long serialVersionUID = -7223078772249308813L;

                public List<MembershipTO> execute(String filter) {
                    return (StringUtils.isEmpty((CharSequence)filter) || "*".equals(filter) ? Groups.this.groupsModel.getObject() : GroupRestClient.searchAssignableGroups(Groups.this.anyTO.getRealm(), filter, 1, 30)).stream().map(input -> new MembershipTO.Builder().group(input.getKey(), input.getName()).build()).collect(Collectors.toList());
                }
            }).hideLabel().setOutputMarkupId(true)});
        }
    }

    protected void addDynamicRealmsContainer() {
    }

    protected void addDynamicGroupsContainer() {
    }

    public static interface SerializableFunction
    extends Function<AjaxRequestTarget, Boolean>,
    Serializable {
    }

    protected class EnduserGroupsModel
    extends AbstractGroupsModel {
        private static final long serialVersionUID = -4541954630939063927L;
        private List<GroupTO> groups;
        private List<MembershipTO> memberships;
        private String realm;

        protected EnduserGroupsModel() {
        }

        public List<GroupTO> getObject() {
            this.reload();
            return this.groups;
        }

        protected void reloadObject() {
            this.groups = GroupRestClient.searchAssignableGroups(this.realm, null, 1, 30);
        }

        public List<MembershipTO> getMemberships() {
            this.reload();
            return this.memberships;
        }

        protected void reloadMemberships() {
            this.memberships = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships();
        }

        public List<String> getDynMemberships() {
            return Collections.emptyList();
        }

        protected void reloadDynMemberships() {
        }

        protected void reload() {
            boolean reload = Groups.this.anyTO.getRealm() != null && !Groups.this.anyTO.getRealm().equalsIgnoreCase(this.realm);
            this.realm = Groups.this.anyTO.getRealm();
            if (reload) {
                this.reloadObject();
                this.reloadMemberships();
            }
        }
    }
}

