/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.util.Collection;
import org.apache.syncope.client.enduser.SyncopeEnduserApplication;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.pages.AbstractChangePassword;
import org.apache.syncope.client.enduser.pages.Dashboard;
import org.apache.syncope.client.enduser.pages.SelfResult;
import org.apache.syncope.client.enduser.rest.UserSelfRestClient;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPasswordFieldPanel;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class EditChangePassword
extends AbstractChangePassword {
    private static final long serialVersionUID = -537205681762708502L;
    private final UserSelfRestClient userSelfRestClient = new UserSelfRestClient();

    public EditChangePassword(PageParameters parameters) {
        super(parameters);
    }

    @Override
    protected void doPwdSubmit(AjaxRequestTarget target, AjaxPasswordFieldPanel passwordField) {
        PageParameters parameters = new PageParameters();
        try {
            UserTO userTO = this.getPwdLoggedUser();
            PasswordPatch passwordPatch = (PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)passwordField.getModelObject())).onSyncope(true).resources((Collection)userTO.getResources()).build();
            UserPatch userPatch = new UserPatch();
            userPatch.setKey(this.getPwdLoggedUser().getKey());
            userPatch.setPassword(passwordPatch);
            this.userSelfRestClient.update(userTO.getETagValue(), userPatch);
            parameters.add("status", (Object)"operation_succeeded");
            parameters.add("notificationTitle", (Object)this.getString("self.pwd.change.success.msg"));
            parameters.add("notificationMessage", (Object)this.getString("self.pwd.change.success"));
            parameters.add("landingPage", (Object)SyncopeEnduserApplication.get().getPageClass("profile", Dashboard.class).getName());
            this.setResponsePage(SelfResult.class, parameters);
        }
        catch (Exception e) {
            LOG.error("While changing password for {}", (Object)SyncopeEnduserSession.get().getSelfTO().getUsername(), (Object)e);
            SyncopeEnduserSession.get().onException(e);
            this.notificationPanel.refresh((IPartialPageRequestHandler)target);
        }
    }

    @Override
    protected UserTO getPwdLoggedUser() {
        return SyncopeEnduserSession.get().getSelfTO();
    }

    @Override
    protected void doPwdCancel() {
        this.setResponsePage(this.getApplication().getHomePage());
    }
}

