/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.markup.html.form.BpmnProcessesAjaxPanel;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.rest.BpmnProcessRestClient;
import org.apache.syncope.client.enduser.rest.UserRequestRestClient;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.annotations.ExtPage;
import org.apache.syncope.client.ui.commons.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.ext.client.common.ui.panels.UserRequestFormPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@ExtPage(label="User Requests", icon="fa-briefcase", listEntitlement="")
public class Flowable
extends BasePage {
    private static final long serialVersionUID = -8781434495150074529L;
    private static final String USER_REQUESTS = "page.userRequests";
    private final int rowsPerPage = 5;
    private final Model<String> bpmnProcessModel = new Model();
    private final WebMarkupContainer container = new WebMarkupContainer("content");
    private final DataView<UserRequest> urDataView;

    public Flowable(PageParameters parameters) {
        super(parameters, USER_REQUESTS);
        this.container.setOutputMarkupId(true);
        this.urDataView = new DataView<UserRequest>("userRequests", (IDataProvider)new URDataProvider(5, "bpmnProcess")){
            private static final long serialVersionUID = -5002600396458362774L;

            protected void populateItem(Item<UserRequest> item) {
                final UserRequest userRequest = (UserRequest)item.getModelObject();
                item.add(new Component[]{new Accordion("userRequestDetails", Collections.singletonList(new AbstractTab((IModel)new StringResourceModel("user.requests.accordion", (Component)Flowable.this.container, (IModel)Model.of((Serializable)userRequest))){
                    private static final long serialVersionUID = 1037272333056449378L;

                    public WebMarkupContainer getPanel(String panelId) {
                        return new UserRequestDetails(panelId, userRequest);
                    }
                }), (IModel)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        };
        this.urDataView.setItemsPerPage(5L);
        this.urDataView.setOutputMarkupId(true);
        this.container.add(new Component[]{this.urDataView});
        this.container.add(new Component[]{new AjaxPagingNavigator("navigator", this.urDataView)});
        AjaxLink<Void> startButton = new AjaxLink<Void>("start"){
            private static final long serialVersionUID = 3669569969172391336L;

            public void onClick(AjaxRequestTarget target) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)Flowable.this.bpmnProcessModel.getObject())))) {
                    try {
                        UserRequestRestClient.startRequest((String)((Object)Flowable.this.bpmnProcessModel.getObject()), null);
                    }
                    catch (Exception e) {
                        LOG.error("Unable to start bpmnProcess [{}]", (Object)Flowable.this.bpmnProcessModel.getObject(), (Object)e);
                        SyncopeEnduserSession.get().error((Serializable)((Object)String.format("Unable to start bpmnProcess [%s]", e.getMessage())));
                        Flowable.this.notificationPanel.refresh((IPartialPageRequestHandler)target);
                    }
                    target.add(new Component[]{Flowable.this.container});
                }
            }
        };
        startButton.setEnabled(false);
        this.container.add(new Component[]{startButton});
        BpmnProcessesAjaxPanel bpmnProcesses = new BpmnProcessesAjaxPanel("bpmnProcesses", "bpmnProcesses", (IModel<String>)this.bpmnProcessModel, (Behavior)new IndicatorAjaxFormComponentUpdatingBehavior("change", (AjaxLink)startButton){
            private static final long serialVersionUID = -1107858522700306810L;
            final /* synthetic */ AjaxLink val$startButton;
            {
                this.val$startButton = ajaxLink;
                super(x0);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)((Object)Flowable.this.bpmnProcessModel.getObject())))) {
                    this.val$startButton.setEnabled(true);
                } else {
                    this.val$startButton.setEnabled(false);
                }
                target.add(new Component[]{Flowable.this.container});
            }
        });
        bpmnProcesses.setChoices(BpmnProcessRestClient.getDefinitions().stream().filter(definition -> !definition.isUserWorkflow()).map(BpmnProcess::getKey).collect(Collectors.toList()));
        this.container.add(new Component[]{bpmnProcesses});
        this.contentWrapper.add(new Component[]{this.container});
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.sidebar.setActiveNavItem(((Object)((Object)this)).getClass().getSimpleName().toLowerCase());
    }

    public static class URDataProvider
    implements IDataProvider<UserRequest> {
        private static final long serialVersionUID = 1169386589403139714L;
        protected final int paginatorRows;
        protected final String sortParam;

        public URDataProvider(int paginatorRows, String sortParam) {
            this.paginatorRows = paginatorRows;
            this.sortParam = sortParam;
        }

        public Iterator<UserRequest> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return UserRequestRestClient.listRequests((page < 0 ? 0 : page) + 1, this.paginatorRows, SyncopeEnduserSession.get().getSelfTO().getUsername(), (SortParam<String>)new SortParam((Object)this.sortParam, true)).iterator();
        }

        public long size() {
            return UserRequestRestClient.countRequests();
        }

        public IModel<UserRequest> model(UserRequest ur) {
            return Model.of((Serializable)ur);
        }
    }

    public class UserRequestDetails
    extends Panel {
        private static final long serialVersionUID = -2447602429647965090L;

        public UserRequestDetails(String id, final UserRequest userRequest) {
            super(id);
            final UserRequestForm formTO = userRequest.getHasForm() ? (UserRequestForm)UserRequestRestClient.getForm(SyncopeEnduserSession.get().getSelfTO().getUsername(), userRequest.getTaskId()).orElse(null) : null;
            this.add(new Component[]{formTO == null || formTO.getProperties() == null || formTO.getProperties().isEmpty() ? new Fragment("fragContainer", "formDetails", (MarkupContainer)this).add(new Component[]{new Label("executionId", (Serializable)((Object)userRequest.getExecutionId()))}).add(new Component[]{new Label("startTime", (Serializable)userRequest.getStartTime())}) : new Fragment("fragContainer", "formProperties", (MarkupContainer)this).add(new Component[]{new Form("userRequestWrapForm").add(new Component[]{new UserRequestFormPanel("userRequestFormPanel", Flowable.this.getPageReference(), formTO, false){
                private static final long serialVersionUID = 3617895525072546591L;

                @Override
                protected void viewDetails(AjaxRequestTarget target) {
                }
            }}).add(new Component[]{new AjaxButton("submit"){
                private static final long serialVersionUID = 4284361595033427185L;

                protected void onSubmit(AjaxRequestTarget target) {
                    try {
                        UserRequestRestClient.claimForm(formTO.getTaskId());
                        ProvisioningResult<UserTO> result = UserRequestRestClient.submitForm(formTO);
                        if (result.getPropagationStatuses().stream().anyMatch(prop -> ExecStatus.FAILURE == prop.getStatus() || ExecStatus.NOT_ATTEMPTED == prop.getStatus())) {
                            SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("user_request_error")));
                            Flowable.this.notificationPanel.refresh((IPartialPageRequestHandler)target);
                        }
                        target.add(new Component[]{Flowable.this.container});
                    }
                    catch (SyncopeClientException sce) {
                        LOG.error("Unable to submit user request form for BPMN process [{}]", (Object)formTO.getBpmnProcess(), (Object)sce);
                        SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("user_request_error")));
                        Flowable.this.notificationPanel.refresh((IPartialPageRequestHandler)target);
                    }
                }
            }.setOutputMarkupId(true)})})});
            this.add(new Component[]{new AjaxLink<Void>("delete"){
                private static final long serialVersionUID = 3669569969172391336L;

                public void onClick(AjaxRequestTarget target) {
                    UserRequestRestClient.cancelRequest(userRequest.getExecutionId(), null);
                    target.add(new Component[]{Flowable.this.container});
                }
            }});
        }
    }
}

