/*
 * Decompiled with CFR 0.152.
 */
package org.onehippo.taxonomy.upgrade;

import java.io.InputStreamReader;
import java.io.Reader;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.hippoecm.repository.ext.UpdaterContext;
import org.hippoecm.repository.ext.UpdaterItemVisitor;
import org.hippoecm.repository.ext.UpdaterModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonomyUpgrader19a
implements UpdaterModule {
    private static final String SVN_ID = "$Id: TaxonomyUpgrader19a.java 1087 2011-08-17 14:42:53Z fvlankvelt $";
    static final Logger log = LoggerFactory.getLogger(TaxonomyUpgrader19a.class);

    public void register(UpdaterContext context) {
        context.registerName("taxonomy-upgrade-v19a");
        context.registerStartTag("v15a-taxonomy");
        context.registerEndTag("v19a-taxonomy");
        context.registerVisitor((ItemVisitor)new UpdaterItemVisitor.NamespaceVisitor(context, "hippotaxonomy", "-", (Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("hippotaxonomy.cnd"))));
        context.registerVisitor((ItemVisitor)new UpdaterItemVisitor.PathVisitor("/hippo:configuration/hippo:initialize"){

            protected void leaving(Node node, int level) throws RepositoryException {
                if (node.hasNode("hippotaxonomy")) {
                    node.getNode("hippotaxonomy-namespace").remove();
                }
            }
        });
        context.registerVisitor((ItemVisitor)new UpdaterItemVisitor.PathVisitor("/hippo:namespaces"){

            protected void leaving(Node node, int level) throws RepositoryException {
                if (node.hasNode("hippotaxonomy")) {
                    node.getNode("hippotaxonomy").remove();
                }
            }
        });
        context.registerVisitor((ItemVisitor)new UpdaterItemVisitor.NodeTypeVisitor("hippotaxonomy:taxonomy"){

            protected void leaving(Node node, int level) throws RepositoryException {
                try {
                    Property state;
                    log.info("Adding mixin {} to {}", (Object)"hippostd:publishableSummary", (Object)node.getPath());
                    node.addMixin("hippostd:publishableSummary");
                    String stateSummary = "new";
                    if (node.hasProperty("hippostd:state") && (state = node.getProperty("hippostd:state")).getString().equals("published")) {
                        stateSummary = "live";
                    }
                    log.info("Setting {} of {} to {}", new Object[]{"hippostd:stateSummary", node.getPath(), stateSummary});
                    node.setProperty("hippostd:stateSummary", stateSummary);
                }
                catch (RepositoryException e) {
                    log.warn("Failed to upgrade taxonomy plugin to v19b", (Throwable)e);
                }
            }
        });
    }
}

