/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.util;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import net.tirasa.hct.hstbeans.HCTTaxonomyCategoryBean;
import net.tirasa.hct.repository.HCTConnManager;
import net.tirasa.hct.util.ObjectUtils;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaxonomyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TaxonomyUtils.class);

    private TaxonomyUtils() {
    }

    public static String buildPathInTaxonomy(String taxonomyPath, String docName) {
        return taxonomyPath + "/" + "hippotaxonomy:documents" + "/" + "hippo:resultset" + "/" + docName;
    }

    public static List<HCTTaxonomyCategoryBean> getTaxonomies(HCTConnManager connManager, String[] keys) {
        ArrayList<HCTTaxonomyCategoryBean> taxonomies = new ArrayList<HCTTaxonomyCategoryBean>();
        if (keys != null) {
            for (String key : keys) {
                try {
                    taxonomies.add(TaxonomyUtils.getTaxonomy(connManager, key));
                }
                catch (Exception e) {
                    LOG.error("While getting taxonomy", (Throwable)e);
                }
            }
        }
        return taxonomies;
    }

    public static HCTTaxonomyCategoryBean getTaxonomy(HCTConnManager connManager, String key) throws RepositoryException, ObjectBeanManagerException {
        Query query = connManager.getSession().getWorkspace().getQueryManager().createQuery("SELECT * FROM [hippotaxonomy:category] AS taxonomy WHERE (ISDESCENDANTNODE(taxonomy, '/content/taxonomies') AND [hippotaxonomy:key] = '" + key + "')", "JCR-SQL2");
        NodeIterator result = query.execute().getNodes();
        if (!result.hasNext()) {
            throw new PathNotFoundException("Taxonomy category with key " + key);
        }
        return ObjectUtils.getHippoItem(connManager, result.nextNode(), HCTTaxonomyCategoryBean.class);
    }
}

