/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.jcr.Node;
import net.tirasa.hct.repository.HCTConnManager;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.standard.HippoItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectUtils.class);

    private ObjectUtils() {
    }

    public static HippoItem getHippoItem(HCTConnManager connManager, Node node) throws ObjectBeanManagerException {
        return ObjectUtils.getHippoItem(connManager, node, HippoItem.class);
    }

    public static <T extends HippoItem> T getHippoItem(HCTConnManager connManager, Node node, Class<T> clazz) throws ObjectBeanManagerException {
        HippoItem result = (HippoItem)connManager.getObjConv().getObject(node);
        if (result == null) {
            throw new IllegalArgumentException("No object found for node " + node);
        }
        return (T)result;
    }

    public static HippoItem getHippoItem(HCTConnManager connManager, String path) throws ObjectBeanManagerException {
        return ObjectUtils.getHippoItem(connManager, path, HippoItem.class);
    }

    public static <T extends HippoItem> T getHippoItem(HCTConnManager connManager, String path, Class<T> clazz) throws ObjectBeanManagerException {
        HippoItem result = null;
        try {
            result = (HippoItem)connManager.getObjMan().getObject(URLDecoder.decode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Couldnt decode {}", (Object)path, (Object)e);
        }
        if (result == null) {
            throw new IllegalArgumentException("No object found at " + path);
        }
        return (T)result;
    }

    public static HippoItem getHippoItemByUuid(HCTConnManager connManager, String uuid) throws ObjectBeanManagerException {
        return ObjectUtils.getHippoItemByUuid(connManager, uuid, HippoItem.class);
    }

    public static <T extends HippoItem> T getHippoItemByUuid(HCTConnManager connManager, String uuid, Class<T> clazz) throws ObjectBeanManagerException {
        HippoItem result = (HippoItem)connManager.getObjMan().getObjectByUuid(uuid);
        if (result == null) {
            throw new IllegalArgumentException("No object found with UUID " + uuid);
        }
        return (T)result;
    }
}

