/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.repository;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QueryFunction {
    now,
    nowMinusYears,
    nowPlusYears,
    nowMinusMonths,
    nowPlusMonths,
    nowMinusDays,
    nowPlusDays,
    nowMinusHours,
    nowPlusHours,
    nowPlusMinutes,
    nowMinusMinutes,
    nowMinusSeconds,
    nowPlusSeconds;

    private static final Logger LOG;

    public static String call(String functionCall) throws RepositoryException {
        QueryFunction function = now;
        for (QueryFunction qf : QueryFunction.values()) {
            if (!functionCall.startsWith(qf.name() + "(")) continue;
            function = qf;
        }
        Calendar calendar = Calendar.getInstance();
        int param = 0;
        if (function != now) {
            int startPos = function.name().length() + 1;
            int endPos = functionCall.lastIndexOf(41);
            try {
                param = Integer.valueOf(functionCall.substring(startPos, endPos));
            }
            catch (NumberFormatException e) {
                LOG.error("Could not parse, reverting to 0", (Throwable)e);
                param = 0;
            }
        }
        switch (function) {
            case nowMinusYears: {
                calendar.add(1, -param);
                break;
            }
            case nowPlusYears: {
                calendar.add(1, param);
                break;
            }
            case nowMinusMonths: {
                calendar.add(2, -param);
                break;
            }
            case nowPlusMonths: {
                calendar.add(2, param);
                break;
            }
            case nowMinusDays: {
                calendar.add(6, -param);
                break;
            }
            case nowPlusDays: {
                calendar.add(6, param);
                break;
            }
            case nowMinusHours: {
                calendar.add(10, -param);
                break;
            }
            case nowPlusHours: {
                calendar.add(10, param);
                break;
            }
            case nowMinusMinutes: {
                calendar.add(12, -param);
                break;
            }
            case nowPlusMinutes: {
                calendar.add(12, param);
                break;
            }
            case nowMinusSeconds: {
                calendar.add(13, -param);
                break;
            }
            case nowPlusSeconds: {
                calendar.add(13, param);
                break;
            }
        }
        return ValueFactoryImpl.getInstance().createValue(calendar).getString();
    }

    static {
        LOG = LoggerFactory.getLogger(QueryFunction.class);
    }
}

