/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import net.tirasa.hct.cocoon.sax.Constants;
import net.tirasa.hct.repository.HCTDocumentChildNode;
import net.tirasa.hct.repository.QueryFunction;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

public class HCTQueryFilter {
    private final List<String> andConds = new ArrayList<String>();
    private final List<String> orConds = new ArrayList<String>();
    private final Map<HCTDocumentChildNode, ChildQueryFilter> childConds = new HashMap<HCTDocumentChildNode, ChildQueryFilter>();

    public void addCond(Constants.State state, Constants.Element element, Attributes atts) throws RepositoryException {
        if (state != Constants.State.INSIDE_FILTER_AND && state != Constants.State.INSIDE_FILTER_OR) {
            throw new IllegalArgumentException("Only " + (Object)((Object)Constants.State.INSIDE_FILTER_AND) + " and " + (Object)((Object)Constants.State.INSIDE_FILTER_OR) + " are allowed");
        }
        if (!Constants.FILTER_ELEMENTS.contains((Object)element)) {
            throw new IllegalArgumentException((Object)((Object)element) + " not in " + Constants.FILTER_ELEMENTS);
        }
        String childName = atts.getValue(Constants.Attribute.CHILD_NAME.getName());
        String childType = atts.getValue(Constants.Attribute.CHILD_TYPE.getName());
        HCTDocumentChildNode child = null;
        if (!(StringUtils.isBlank((CharSequence)childName) || StringUtils.isBlank((CharSequence)childType) || this.childConds.containsKey(child = new HCTDocumentChildNode(childName, childType)))) {
            this.childConds.put(child, new ChildQueryFilter());
        }
        String selector = child == null ? "type" : child.getSelector();
        String condition = null;
        switch (element) {
            case EQUALTO: {
                condition = this.getEqualTo(atts, selector);
                break;
            }
            case NOT_EQUALTO: {
                condition = this.getNotEqualTo(atts, selector);
                break;
            }
            case CONTAINS: {
                condition = this.getContains(atts, selector);
                break;
            }
            case NOT_CONTAINS: {
                condition = this.getNotContains(atts, selector);
                break;
            }
            case LIKE: {
                condition = this.getLike(atts, selector);
                break;
            }
            case NOT_LIKE: {
                condition = this.getNotLike(atts, selector);
                break;
            }
            case ISNULL: {
                condition = this.getIsNull(atts, selector);
                break;
            }
            case NOT_NULL: {
                condition = this.getNotNull(atts, selector);
                break;
            }
            case GREATER_OR_EQUAL: {
                condition = this.getGreaterOrEqualThan(atts, selector);
                break;
            }
            case GREATER: {
                condition = this.getGreaterThan(atts, selector);
                break;
            }
            case LESS_OR_EQUAL: {
                condition = this.getLessOrEqualThan(atts, selector);
                break;
            }
            case LESS: {
                condition = this.getLessThan(atts, selector);
                break;
            }
        }
        if (condition == null) {
            throw new IllegalArgumentException("Could not build condition from " + (Object)((Object)element));
        }
        if (state == Constants.State.INSIDE_FILTER_AND) {
            if (child == null) {
                this.andConds.add(condition);
            } else {
                this.childConds.get(child).getAndConds().add(condition);
            }
        }
        if (state == Constants.State.INSIDE_FILTER_OR) {
            if (child == null) {
                this.orConds.add(condition);
            } else {
                this.childConds.get(child).getOrConds().add(condition);
            }
        }
    }

    private String buildComparableValue(Attributes atts) throws RepositoryException {
        String result;
        String propTypeString = atts.getValue(Constants.Attribute.TYPE.getName());
        if (StringUtils.isBlank((CharSequence)propTypeString)) {
            propTypeString = Constants.PropertyType.STRING.name();
        }
        Constants.PropertyType propType = Constants.PropertyType.valueOf(propTypeString);
        String value = atts.getValue(Constants.Attribute.VALUE.getName());
        switch (propType) {
            case BOOLEAN: 
            case DOUBLE: 
            case LONG: {
                result = "CAST('" + value + "' AS " + propType.name() + ")";
                break;
            }
            case DATE: {
                result = "CAST('" + QueryFunction.call(value) + "' AS " + propType.name() + ")";
                break;
            }
            default: {
                result = "'" + value + "'";
            }
        }
        return result;
    }

    private String getEqualTo(Attributes atts, String selector) throws RepositoryException {
        return selector + '.' + '[' + atts.getValue(Constants.Attribute.FIELD.getName()) + ']' + " = " + this.buildComparableValue(atts);
    }

    private String getNotEqualTo(Attributes atts, String selector) throws RepositoryException {
        return selector + '.' + '[' + atts.getValue(Constants.Attribute.FIELD.getName()) + ']' + " <> " + this.buildComparableValue(atts);
    }

    private String getContains(Attributes atts, String selector) {
        StringBuilder result = new StringBuilder().append("CONTAINS(").append(selector).append('.');
        String field = atts.getValue(Constants.Attribute.FIELD.getName());
        if (StringUtils.isBlank((CharSequence)field)) {
            result.append('*');
        } else {
            result.append('[').append(atts.getValue(Constants.Attribute.FIELD.getName())).append(']');
        }
        result.append(", '").append(atts.getValue(Constants.Attribute.VALUE.getName())).append("')");
        return result.toString();
    }

    private String getNotContains(Attributes atts, String selector) {
        return "NOT " + this.getContains(atts, selector);
    }

    private String getLike(Attributes atts, String selector) {
        return selector + '.' + '[' + atts.getValue(Constants.Attribute.FIELD.getName()) + ']' + " LIKE '%" + atts.getValue(Constants.Attribute.VALUE.getName()) + "%'";
    }

    private String getNotLike(Attributes atts, String selector) {
        return "NOT " + this.getLike(atts, selector);
    }

    private String getIsNull(Attributes atts, String selector) {
        return selector + '.' + '[' + atts.getValue(Constants.Attribute.FIELD.getName()) + ']' + " IS NULL";
    }

    private String getNotNull(Attributes atts, String selector) {
        return "NOT " + this.getIsNull(atts, selector);
    }

    private String getGreaterOrEqualThan(Attributes atts, String selector) throws RepositoryException {
        return selector + '.' + '[' + atts.getValue(Constants.Attribute.FIELD.getName()) + ']' + " >= " + this.buildComparableValue(atts);
    }

    private String getGreaterThan(Attributes atts, String selector) throws RepositoryException {
        return selector + '.' + '[' + atts.getValue(Constants.Attribute.FIELD.getName()) + ']' + " > " + this.buildComparableValue(atts);
    }

    private String getLessOrEqualThan(Attributes atts, String selector) throws RepositoryException {
        return selector + '.' + '[' + atts.getValue(Constants.Attribute.FIELD.getName()) + ']' + " <= " + this.buildComparableValue(atts);
    }

    private String getLessThan(Attributes atts, String selector) throws RepositoryException {
        return selector + '.' + '[' + atts.getValue(Constants.Attribute.FIELD.getName()) + ']' + " < " + this.buildComparableValue(atts);
    }

    public List<String> getAndConds() {
        return this.andConds;
    }

    public List<String> getOrConds() {
        return this.orConds;
    }

    public Map<HCTDocumentChildNode, ChildQueryFilter> getChildConds() {
        return this.childConds;
    }

    public class ChildQueryFilter {
        private final List<String> andConds = new ArrayList<String>();
        private final List<String> orConds = new ArrayList<String>();

        public List<String> getAndConds() {
            return this.andConds;
        }

        public List<String> getOrConds() {
            return this.orConds;
        }
    }
}

