/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.repository;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.RowIterator;
import net.tirasa.hct.cocoon.sax.Constants;
import net.tirasa.hct.repository.HCTDocumentChildNode;
import net.tirasa.hct.repository.HCTQueryFilter;
import net.tirasa.hct.repository.HCTQueryResult;
import net.tirasa.hct.repository.HCTTraversal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCTQuery
extends HCTTraversal {
    private static final Logger LOG = LoggerFactory.getLogger(HCTQuery.class);
    private transient String returnType;
    private long page;
    private final transient Set<String> returnFields = new HashSet<String>();
    private boolean returnTags = false;
    private boolean returnTaxonomies = false;
    private boolean returnImages = false;
    private boolean returnRelatedDocs = false;
    private boolean includeFolders = false;
    private final transient HCTQueryFilter filter = new HCTQueryFilter();
    private final transient StringBuilder orderBy = new StringBuilder();
    private transient String sqlQuery;
    private final transient Map<String, String> taxonomies = new HashMap<String, String>();
    private transient Session session;

    public boolean isIncludeFolders() {
        return this.includeFolders;
    }

    public void setIncludeFolders(boolean includeFolders) {
        this.includeFolders = includeFolders;
    }

    public long getPage() {
        return this.page;
    }

    public void setPage(long page) {
        this.page = page;
    }

    public boolean isReturnTags() {
        return this.returnTags;
    }

    public void setReturnTags(boolean returnTags) {
        this.returnTags = returnTags;
    }

    public boolean isReturnTaxonomies() {
        return this.returnTaxonomies;
    }

    public void setReturnTaxonomies(boolean returnTaxonomies) {
        this.returnTaxonomies = returnTaxonomies;
    }

    public boolean isReturnImages() {
        return this.returnImages;
    }

    public void setReturnImages(boolean returnImages) {
        this.returnImages = returnImages;
    }

    public boolean isReturnRelatedDocs() {
        return this.returnRelatedDocs;
    }

    public void setReturnRelatedDocs(boolean returnRelatedDocs) {
        this.returnRelatedDocs = returnRelatedDocs;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public Set<String> getReturnFields() {
        return this.returnFields;
    }

    public boolean addReturnField(String returnField) {
        return returnField != null && this.returnFields.add(returnField);
    }

    public boolean removeReturnField(String returnField) {
        return returnField != null && this.returnFields.remove(returnField);
    }

    public HCTQueryFilter getFilter() {
        return this.filter;
    }

    public void addOrderByAscending(String propertyName) {
        this.orderBy.append("type").append('.').append('[').append(propertyName).append(']').append(" ASC, ");
    }

    public void addOrderByDescending(String propertyName) {
        this.orderBy.append("type").append('.').append('[').append(propertyName).append(']').append(" DESC, ");
    }

    public Type getType() {
        return this.base == null ? null : (this.base.startsWith("/content/taxonomies") ? Type.TAXONOMY_DOCS : Type.FOLDER_DOCS);
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public HCTQueryResult execute(Locale locale, Constants.Availability availability) throws RepositoryException {
        long totalResultSize;
        this.buildSQLQuery(locale, availability);
        LOG.debug("Elaborated JCR/SQL2 query: {}", (Object)this.getSQLQuery());
        Query query = this.session.getWorkspace().getQueryManager().createQuery(this.getSQLQuery(), "JCR-SQL2");
        long l = totalResultSize = this.page == 0L ? 0L : query.execute().getRows().getSize();
        if (this.size > 0L) {
            query.setLimit(this.size);
            if (this.page > 0L) {
                query.setOffset((this.page - 1L) * this.size);
            }
        }
        LOG.debug("About to execute {}", (Object)query.getStatement());
        RowIterator result = query.execute().getRows();
        long totalPages = this.page == 0L ? 1L : (totalResultSize % this.size == 0L ? totalResultSize / this.size : totalResultSize / this.size + 1L);
        return new HCTQueryResult(locale, this.page, totalPages, result);
    }

    public Map<String, String> getTaxonomies() {
        return this.taxonomies;
    }

    private void findTaxonomies(Node node, int targetDepth) throws RepositoryException {
        if (targetDepth >= node.getDepth()) {
            this.taxonomies.put(node.getProperty("hippotaxonomy:key").getString(), node.getPath());
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                Node child = nodes.nextNode();
                if (!"hippotaxonomy:category".equals(child.getPrimaryNodeType().getName())) continue;
                this.findTaxonomies(child, targetDepth);
            }
        }
    }

    private void findDepthFrontier(Node node, Set<String> frontier, int targetDepth) throws RepositoryException {
        if (targetDepth == node.getDepth()) {
            frontier.add(node.getPath());
        } else {
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                Node child = nodes.nextNode();
                if (!"hippostd:folder".equals(child.getPrimaryNodeType().getName()) && !"hippotaxonomy:category".equals(child.getPrimaryNodeType().getName())) continue;
                this.findDepthFrontier(child, frontier, targetDepth);
            }
        }
    }

    private void addCondsToWhereClause(List<String> conds, StringBuilder clause, String op) {
        boolean firstItem = clause.length() == 0;
        for (String cond : conds) {
            clause.insert(0, '(');
            if (!firstItem) {
                clause.append(op).append(' ');
            } else {
                firstItem = false;
            }
            clause.append(cond).append(") ");
        }
    }

    private void addJoinsAndCondsToQuery(Map<HCTDocumentChildNode, HCTQueryFilter.ChildQueryFilter> children, StringBuilder query, StringBuilder whereClause, StringBuilder andCondClause, StringBuilder orCondClause) {
        for (Map.Entry<HCTDocumentChildNode, HCTQueryFilter.ChildQueryFilter> entry : children.entrySet()) {
            query.append("INNER JOIN [").append(entry.getKey().getType()).append("] AS ").append(entry.getKey().getSelector()).append(" ON ISCHILDNODE(").append(entry.getKey().getSelector()).append(", ").append("type").append(") ");
            whereClause.insert(0, '(');
            whereClause.append("AND NAME(").append(entry.getKey().getSelector()).append(") = '").append(entry.getKey().getName()).append("') ");
            this.addCondsToWhereClause(entry.getValue().getAndConds(), andCondClause, "AND");
            this.addCondsToWhereClause(entry.getValue().getOrConds(), orCondClause, "OR");
        }
    }

    private void buildSQLQuery(Locale locale, Constants.Availability availability) throws RepositoryException {
        LOG.debug("Query type: {}", (Object)this.getType());
        String actualBase = this.getType() == Type.TAXONOMY_DOCS ? "/content/documents" : this.base;
        LOG.debug("Search base: {}", (Object)actualBase);
        StringBuilder whereClause = new StringBuilder("ISDESCENDANTNODE(").append("type").append(", '").append(actualBase).append("') ");
        Node baseNode = this.session.getNode(actualBase);
        if (this.getType() == Type.TAXONOMY_DOCS) {
            Node taxonomyBaseNode = this.session.getNode(this.base);
            if (!"hippotaxonomy:category".equals(taxonomyBaseNode.getPrimaryNodeType().getName())) {
                throw new InvalidQueryException(this.base + " is not of type " + "hippotaxonomy:category");
            }
            this.taxonomies.clear();
            this.findTaxonomies(taxonomyBaseNode, this.depth > 0 ? taxonomyBaseNode.getDepth() + this.depth - 1 : Integer.MAX_VALUE);
            StringBuilder taxonomySubclause = new StringBuilder();
            for (String taxonomy : this.taxonomies.keySet()) {
                if (taxonomySubclause.length() > 0) {
                    taxonomySubclause.append("OR ");
                }
                taxonomySubclause.insert(0, '(');
                taxonomySubclause.append("type").append('.').append('[').append("hippotaxonomy:keys").append("] = '").append(taxonomy).append("') ");
            }
            whereClause.insert(0, '(');
            whereClause.append("AND ").append((CharSequence)taxonomySubclause).append(") ");
            LOG.debug("Searching with taxonomies: {}", this.taxonomies);
        } else if (this.depth > 0) {
            HashSet<String> depthFrontier = new HashSet<String>();
            this.findDepthFrontier(baseNode, depthFrontier, baseNode.getDepth() + this.depth);
            for (String depthFrontierPath : depthFrontier) {
                whereClause.insert(0, '(');
                whereClause.append("AND NOT ISDESCENDANTNODE(").append("type").append(",'").append(depthFrontierPath).append("')) ");
            }
        }
        whereClause.insert(0, '(');
        whereClause.append("AND ").append("type").append('.').append('[').append("hippotranslation:locale").append("] = '").append(locale).append("') ");
        whereClause.insert(0, '(');
        whereClause.append("AND ").append("type").append('.').append('[').append("hippo:availability").append("] = '").append(availability.name()).append("') ");
        StringBuilder andCondClause = new StringBuilder();
        StringBuilder orCondClause = new StringBuilder();
        this.addCondsToWhereClause(this.filter.getAndConds(), andCondClause, "AND");
        this.addCondsToWhereClause(this.filter.getOrConds(), orCondClause, "OR");
        StringBuilder query = new StringBuilder("SELECT ").append("type").append(".[").append("jcr:uuid").append("] FROM [").append(this.returnType).append("] AS ").append("type").append(' ');
        this.addJoinsAndCondsToQuery(this.filter.getChildConds(), query, whereClause, andCondClause, orCondClause);
        query.append("WHERE ").append((CharSequence)whereClause);
        if (andCondClause.length() > 0) {
            query.append("AND ").append((CharSequence)andCondClause);
        }
        if (orCondClause.length() > 0) {
            query.append("OR ").append((CharSequence)orCondClause);
        }
        if (this.orderBy.length() > 2) {
            query.append("ORDER BY ").append(this.orderBy.toString().substring(0, this.orderBy.length() - 2));
        }
        this.sqlQuery = query.toString();
    }

    public String getSQLQuery() {
        return this.sqlQuery;
    }

    public static enum Type {
        FOLDER_DOCS,
        TAXONOMY_DOCS;

    }
}

