/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.repository;

import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import net.tirasa.hct.cocoon.sax.Constants;
import net.tirasa.hct.cocoon.sax.HippoRepositoryNotFoundException;
import net.tirasa.hct.repository.AbstractHCTEntity;
import net.tirasa.hct.repository.HCTConnManager;
import net.tirasa.hct.util.ObjectUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.standard.HippoDocument;

public class HCTDocument
extends AbstractHCTEntity {
    private String path;
    private String uuid;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public HippoDocument getHippoDocument(HCTConnManager connManager, Locale locale, Constants.Availability availability) throws ObjectBeanManagerException, HippoRepositoryNotFoundException, RepositoryException {
        HippoDocument baseDoc;
        HippoDocument hippoDocument = baseDoc = this.path == null ? ObjectUtils.getHippoItemByUuid(connManager, this.uuid, HippoDocument.class) : ObjectUtils.getHippoItem(connManager, this.path, HippoDocument.class);
        if (baseDoc == null) {
            throw new HippoRepositoryNotFoundException("Could not find document " + this.path == null ? this.uuid : this.path);
        }
        if (this.path != null) {
            if (baseDoc.getAvailableTranslationsBean().hasTranslation(locale.getLanguage())) {
                baseDoc = (HippoDocument)baseDoc.getAvailableTranslationsBean().getTranslation(locale.getLanguage()).getContextualBean();
            } else {
                throw new HippoRepositoryNotFoundException("Could not find locale " + locale + " for document " + this.path);
            }
        }
        Node parent = connManager.getSession().getNodeByIdentifier(baseDoc.getCanonicalHandleUUID());
        HippoDocument doc = null;
        NodeIterator itor = parent.getNodes(baseDoc.getPath().substring(baseDoc.getPath().lastIndexOf(47) + 1));
        while (itor.hasNext()) {
            HippoDocument version = ObjectUtils.getHippoItemByUuid(connManager, itor.nextNode().getIdentifier(), HippoDocument.class);
            if (!ArrayUtils.contains((Object[])((String[])version.getProperty("hippo:availability")), (Object)availability.toString())) continue;
            doc = version;
        }
        if (doc == null) {
            throw new HippoRepositoryNotFoundException("Document not available as " + (Object)((Object)availability));
        }
        return doc;
    }
}

