/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.repository;

import java.util.Collection;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import net.tirasa.hct.cocoon.sax.Constants;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.commons.lang3.ArrayUtils;
import org.hippoecm.hst.component.support.spring.util.MetadataReaderClasspathResourceScanner;
import org.hippoecm.hst.content.beans.manager.ObjectBeanManager;
import org.hippoecm.hst.content.beans.manager.ObjectBeanManagerImpl;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.ClasspathResourceScanner;
import org.hippoecm.hst.util.ObjectConverterUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ResourceLoader;

public final class HCTConnManager {
    private final transient Repository repository;
    private final transient Session session;
    private final transient ObjectBeanManager objMan;
    private final transient ObjectConverter objConv;

    public static HCTConnManager getContentInstance() {
        return new HCTConnManager(Credentials.class.getName() + ".default");
    }

    public static HCTConnManager getBinaryInstance() {
        return new HCTConnManager(Credentials.class.getName() + ".binaries");
    }

    private HCTConnManager(String componentName) {
        if (!HstServices.isAvailable()) {
            throw new SetupException("HstServices not available");
        }
        Credentials credentials = (Credentials)HstServices.getComponentManager().getComponent(componentName);
        this.repository = (Repository)HstServices.getComponentManager().getComponent(Repository.class.getName());
        try {
            this.session = this.repository.login(credentials);
        }
        catch (RepositoryException e) {
            throw new SetupException("While log in to the Hippo repository", (Throwable)e);
        }
        MetadataReaderClasspathResourceScanner scanner = new MetadataReaderClasspathResourceScanner();
        scanner.setResourceLoader((ResourceLoader)new ClassPathXmlApplicationContext());
        try {
            String[] fallbackNodeTypes = (String[])ArrayUtils.add((Object[])ObjectConverterUtils.getDefaultFallbackNodeTypes(), (Object)"hippo:compound");
            this.objConv = ObjectConverterUtils.createObjectConverter((Collection)ObjectConverterUtils.getAnnotatedClasses((ClasspathResourceScanner)scanner, (String[])new String[]{"classpath*:net/tirasa/hct/hstbeans/**/*.class"}), (Class[])Constants.DEFAULT_BUILT_IN_MAPPING_CLASSES, (String[])fallbackNodeTypes, (boolean)false);
            this.objMan = new ObjectBeanManagerImpl(this.session, this.objConv);
        }
        catch (Exception e) {
            throw new SetupException("While creating HST ObjectManager", (Throwable)e);
        }
    }

    public ObjectConverter getObjConv() {
        return this.objConv;
    }

    public ObjectBeanManager getObjMan() {
        return this.objMan;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Session getSession() {
        return this.session;
    }

    public void logout() {
        if (this.session != null) {
            this.session.logout();
        }
    }
}

