/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.cocoon.sax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import net.tirasa.hct.cocoon.cache.AvailabilityLocaleCacheKey;
import net.tirasa.hct.cocoon.sax.Constants;
import net.tirasa.hct.cocoon.sax.HippoItemXMLDumper;
import net.tirasa.hct.cocoon.sax.InvalidHCTRequestException;
import net.tirasa.hct.hstbeans.HCTTaxonomyCategoryBean;
import net.tirasa.hct.hstbeans.HippoCompoundDocument;
import net.tirasa.hct.hstbeans.HippoDate;
import net.tirasa.hct.hstbeans.RelatedDocs;
import net.tirasa.hct.repository.HCTConnManager;
import net.tirasa.hct.repository.HCTDocument;
import net.tirasa.hct.repository.HCTQuery;
import net.tirasa.hct.repository.HCTQueryResult;
import net.tirasa.hct.repository.HCTTraversal;
import net.tirasa.hct.util.ObjectUtils;
import net.tirasa.hct.util.TaxonomyUtils;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.sax.util.XMLUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.standard.HippoAsset;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoDocument;
import org.hippoecm.hst.content.beans.standard.HippoFacetSelect;
import org.hippoecm.hst.content.beans.standard.HippoFolder;
import org.hippoecm.hst.content.beans.standard.HippoGalleryImageSet;
import org.hippoecm.hst.content.beans.standard.HippoHtml;
import org.hippoecm.hst.content.beans.standard.HippoItem;
import org.hippoecm.hst.content.beans.standard.HippoMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HippoRepositoryTransformer
extends AbstractSAXTransformer
implements CachingPipelineComponent {
    private static final Logger LOG = LoggerFactory.getLogger(HippoRepositoryTransformer.class);
    private static final String PARAM_LOCALE = "locale";
    private static final String PARAM_AVAILABILITY = "availability";
    private Locale locale;
    private Constants.Availability availability;
    private Constants.State state;
    private transient HCTDocument hctDocument;
    private transient HCTTraversal hctTraversal;
    private transient HCTQuery hctQuery;

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setup(configuration);
    }

    public void setup(Map<String, Object> parameters) {
        Locale defaultLocale;
        if (parameters == null) {
            return;
        }
        if (parameters.containsKey(PARAM_AVAILABILITY)) {
            try {
                this.availability = Constants.Availability.valueOf((String)parameters.get(PARAM_AVAILABILITY));
            }
            catch (IllegalArgumentException e) {
                this.availability = Constants.Availability.live;
                LOG.warn("Invalid availability specified, reverting to " + (Object)((Object)this.availability), (Throwable)e);
            }
        } else {
            this.availability = Constants.Availability.live;
            LOG.warn("No availability specified, reverting to " + (Object)((Object)this.availability));
        }
        if (parameters.containsKey(Settings.ROLE)) {
            Settings settings = (Settings)parameters.get(Settings.ROLE);
            String localeString = settings.getProperty("net.tirasa.hct.defaultLocale", Locale.getDefault().getLanguage());
            try {
                defaultLocale = LocaleUtils.toLocale((String)localeString);
            }
            catch (IllegalArgumentException e) {
                defaultLocale = Locale.getDefault();
                LOG.error("Could not parse provided '{}' as default Locale", (Object)localeString, (Object)e);
            }
        } else {
            defaultLocale = Locale.getDefault();
        }
        if (parameters.containsKey(PARAM_LOCALE)) {
            try {
                this.locale = LocaleUtils.toLocale((String)((String)parameters.get(PARAM_LOCALE)));
            }
            catch (IllegalArgumentException e) {
                this.locale = defaultLocale;
                LOG.error("Could not parse provided '{}' as Locale", parameters.get(PARAM_LOCALE), (Object)e);
            }
        } else {
            this.locale = defaultLocale;
            LOG.warn("No locale specified, reverting to " + this.locale);
        }
        this.state = Constants.State.OUTSIDE;
    }

    public void finish() {
        this.state = null;
        super.finish();
    }

    public CacheKey constructCacheKey() {
        return new AvailabilityLocaleCacheKey(this.availability, this.locale);
    }

    private void findAndDumpImagesAndAssets(HCTConnManager connManager, HippoDocument doc, HippoItemXMLDumper dumper) throws ObjectBeanManagerException, SAXException {
        ArrayList<HippoGalleryImageSet> images = new ArrayList<HippoGalleryImageSet>();
        ArrayList<HippoAsset> assets = new ArrayList<HippoAsset>();
        for (HippoMirror mirror : doc.getChildBeans(HippoMirror.class)) {
            HippoItem subElement;
            HippoBean bean = mirror.getReferencedBean();
            if (bean == null) continue;
            if (bean instanceof HippoGalleryImageSet && (subElement = ObjectUtils.getHippoItemByUuid(connManager, (String)((HippoFacetSelect)mirror).getProperty("hippo:docbase"))) instanceof HippoGalleryImageSet) {
                images.add((HippoGalleryImageSet)subElement);
            }
            if (!(bean instanceof HippoAsset)) continue;
            assets.add((HippoAsset)bean);
        }
        dumper.dumpImages(images, Constants.Element.IMAGE.getName(), true);
        dumper.dumpAssets(assets, Constants.Element.ASSET.getName(), true, this.hctDocument.getDateFormat(), this.locale);
    }

    private void compounds(HCTConnManager connManager, HippoDocument container, HippoItemXMLDumper dumper, XMLReader xmlReader) throws SAXException, RepositoryException, ObjectBeanManagerException, IOException {
        dumper.startHippoCompounds();
        for (HippoDocument compound : container.getChildBeans(HippoCompoundDocument.class)) {
            dumper.startHippoCompound(compound);
            for (Map.Entry<String, Object> entry : compound.getProperties().entrySet()) {
                dumper.dumpField(entry, this.hctDocument.getDateFormat(), this.locale);
            }
            for (HippoDate hippoDate : compound.getChildBeans(HippoDate.class)) {
                dumper.dumpDate(hippoDate.getName(), hippoDate.getCalendar(), this.hctDocument.getDateFormat(), this.locale);
            }
            for (HippoHtml hippoHtml : compound.getChildBeans(HippoHtml.class)) {
                dumper.dumpHtml(connManager, hippoHtml, xmlReader, this.hctDocument.getDateFormat(), this.locale);
            }
            this.findAndDumpImagesAndAssets(connManager, compound, dumper);
            this.compounds(connManager, compound, dumper, xmlReader);
            dumper.endHippoCompound(compound);
        }
        dumper.endHippoCompounds();
    }

    private void document(HCTConnManager connManager) throws ObjectBeanManagerException, SAXException, IOException, RepositoryException {
        HippoDocument doc = this.hctDocument.getHippoDocument(connManager, this.locale, this.availability);
        HippoItemXMLDumper dumper = new HippoItemXMLDumper(this.getSAXConsumer());
        dumper.startHippoItem(doc, doc.getPath());
        for (Map.Entry<String, Object> entry : doc.getProperties().entrySet()) {
            if ("hippostd:tags".equals(entry.getKey())) {
                dumper.dumpTags((String[])entry.getValue());
                continue;
            }
            if ("hippotaxonomy:keys".equals(entry.getKey())) {
                dumper.dumpTaxonomies(TaxonomyUtils.getTaxonomies(connManager, (String[])entry.getValue()), this.locale);
                continue;
            }
            dumper.dumpField(entry, this.hctDocument.getDateFormat(), this.locale);
        }
        for (HippoDate hippoDate : doc.getChildBeans(HippoDate.class)) {
            dumper.dumpDate(hippoDate.getName(), hippoDate.getCalendar(), this.hctDocument.getDateFormat(), this.locale);
        }
        Constants.StartEndDocumentFilter xmlReader = new Constants.StartEndDocumentFilter(XMLUtils.createXMLReader((ContentHandler)this.getSAXConsumer()));
        xmlReader.setContentHandler((ContentHandler)this.getSAXConsumer());
        for (HippoHtml rtf : doc.getChildBeans(HippoHtml.class)) {
            dumper.dumpHtml(connManager, rtf, xmlReader, this.hctDocument.getDateFormat(), this.locale);
        }
        this.findAndDumpImagesAndAssets(connManager, doc, dumper);
        this.compounds(connManager, doc, dumper, xmlReader);
        ArrayList<HippoDocument> arrayList = new ArrayList<HippoDocument>();
        for (RelatedDocs docs : doc.getChildBeans(RelatedDocs.class)) {
            for (String relDocUuid : docs.getRelatedDocsUuids()) {
                arrayList.add(ObjectUtils.getHippoItemByUuid(connManager, relDocUuid, HippoDocument.class));
            }
        }
        dumper.dumpRelatedDocs(arrayList, Constants.Element.DOCUMENT.getName(), true);
        dumper.endHippoItem((HippoItem)doc);
    }

    private <T extends HippoItem> void recursiveTraversal(HippoItem item, Class<T> traversalType, int depth, HippoItemXMLDumper dumper) throws SAXException, RepositoryException {
        List children;
        dumper.startHippoItem(item, item.getPath());
        if (depth > 0 && !(children = item.getChildBeans(traversalType)).isEmpty()) {
            for (HippoItem child : children) {
                this.recursiveTraversal(child, traversalType, depth - 1, dumper);
            }
        }
        dumper.endHippoItem(item);
    }

    private void traverse(HCTConnManager connManager) throws ObjectBeanManagerException, SAXException, RepositoryException {
        if (this.hctTraversal == null) {
            throw new IllegalArgumentException("HCTTraversal is null");
        }
        Class traversalType = this.hctTraversal.getBase().startsWith("/content/taxonomies") ? HCTTaxonomyCategoryBean.class : HippoFolder.class;
        HippoItem base = ObjectUtils.getHippoItem(connManager, this.hctTraversal.getBase());
        HippoItemXMLDumper dumper = new HippoItemXMLDumper(this.getSAXConsumer());
        this.recursiveTraversal(base, traversalType, this.hctTraversal.getDepth(), dumper);
    }

    private void query(HCTConnManager connManager) throws SAXException, RepositoryException, IOException, ObjectBeanManagerException {
        if (this.hctQuery == null) {
            throw new IllegalArgumentException("HCTQuery is null");
        }
        this.hctQuery.setSession(connManager.getSession());
        HCTQueryResult queryResult = this.hctQuery.execute(this.locale, this.availability);
        LOG.debug("Query is {}", (Object)this.hctQuery.getSQLQuery());
        HippoItemXMLDumper dumper = new HippoItemXMLDumper(this.getSAXConsumer());
        HippoItem base = ObjectUtils.getHippoItem(connManager, this.hctQuery.getBase());
        dumper.startQueryResult(queryResult, base);
        if (this.hctQuery.isIncludeFolders()) {
            HashMap resultByFolder = new HashMap();
            for (String string : queryResult.getUuids()) {
                HippoItem item = ObjectUtils.getHippoItemByUuid(connManager, string);
                if (this.hctQuery.getType() == HCTQuery.Type.TAXONOMY_DOCS) {
                    String[] keys = (String[])item.getProperty("hippotaxonomy:keys");
                    for (int i = 0; keys != null && i < keys.length; ++i) {
                        if (!this.hctQuery.getTaxonomies().keySet().contains(keys[i])) continue;
                        HCTTaxonomyCategoryBean taxonomy = ObjectUtils.getHippoItem(connManager, this.hctQuery.getTaxonomies().get(keys[i]), HCTTaxonomyCategoryBean.class);
                        if (!resultByFolder.containsKey((Object)taxonomy)) {
                            resultByFolder.put(taxonomy, new ArrayList());
                        }
                        ((List)resultByFolder.get((Object)taxonomy)).add(item);
                    }
                    continue;
                }
                HippoFolder folder = (HippoFolder)item.getParentBean();
                if (!resultByFolder.containsKey(folder)) {
                    resultByFolder.put((HCTTaxonomyCategoryBean)folder, new ArrayList());
                }
                ((List)resultByFolder.get(folder)).add(item);
            }
            for (Map.Entry entry : resultByFolder.entrySet()) {
                if (this.hctQuery.getType() == HCTQuery.Type.TAXONOMY_DOCS) {
                    dumper.startTaxonomy((HCTTaxonomyCategoryBean)((Object)entry.getKey()), this.locale);
                    for (HippoItem item : (List)entry.getValue()) {
                        dumper.dumpHippoItem(connManager, item, TaxonomyUtils.buildPathInTaxonomy(((HippoItem)entry.getKey()).getPath(), item.getName()), this.hctQuery, this.locale);
                    }
                    dumper.endTaxonomy();
                    continue;
                }
                dumper.startHippoItem((HippoItem)entry.getKey(), ((HippoItem)entry.getKey()).getPath());
                for (HippoItem item : (List)entry.getValue()) {
                    dumper.dumpHippoItem(connManager, item, item.getPath(), this.hctQuery, this.locale);
                }
                dumper.endHippoItem((HippoItem)entry.getKey());
            }
        } else {
            block8: for (String uuid : queryResult.getUuids()) {
                HippoItem hippoItem = ObjectUtils.getHippoItemByUuid(connManager, uuid);
                switch (this.hctQuery.getType()) {
                    case TAXONOMY_DOCS: {
                        String[] keys = (String[])hippoItem.getProperty("hippotaxonomy:keys");
                        for (int i = 0; keys != null && i < keys.length; ++i) {
                            if (!this.hctQuery.getTaxonomies().keySet().contains(keys[i])) continue;
                            dumper.dumpHippoItem(connManager, hippoItem, TaxonomyUtils.buildPathInTaxonomy(this.hctQuery.getTaxonomies().get(keys[i]), hippoItem.getName()), this.hctQuery, this.locale);
                        }
                        continue block8;
                    }
                    default: {
                        dumper.dumpHippoItem(connManager, hippoItem, hippoItem.getPath(), this.hctQuery, this.locale);
                    }
                }
            }
        }
        dumper.endQueryResult();
    }

    private String parseDateFormat(Attributes atts) {
        String dateFormat = atts.getValue(Constants.Attribute.DATE_FORMAT.getName());
        if (StringUtils.isBlank((CharSequence)dateFormat)) {
            dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
        }
        return dateFormat;
    }

    private int parseDepth(Attributes atts) {
        int depth = 0;
        if (StringUtils.isNotBlank((CharSequence)atts.getValue(Constants.Attribute.DEPTH.getName()))) {
            try {
                depth = Integer.parseInt(atts.getValue(Constants.Attribute.DEPTH.getName()));
            }
            catch (NumberFormatException e) {
                LOG.error("Invalid depth specified, reverting to default (0)", (Throwable)e);
            }
        }
        return depth;
    }

    private long parseSize(Attributes atts) {
        long size = 5L;
        if (StringUtils.isNotBlank((CharSequence)atts.getValue(Constants.Attribute.SIZE.getName()))) {
            try {
                size = Long.parseLong(atts.getValue(Constants.Attribute.SIZE.getName()));
            }
            catch (NumberFormatException e) {
                LOG.error("Invalid size specified, reverting to default (5)", (Throwable)e);
            }
        }
        return size;
    }

    private long parsePage(Attributes atts) {
        long page = 0L;
        if (StringUtils.isNotBlank((CharSequence)atts.getValue(Constants.Attribute.PAGE.getName()))) {
            try {
                page = Long.parseLong(atts.getValue(Constants.Attribute.PAGE.getName()));
            }
            catch (NumberFormatException e) {
                LOG.error("Invalid page specified, assuming not paginated result", (Throwable)e);
            }
        }
        return page;
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        Constants.Element element;
        if (!"http://www.tirasa.net/hct/1.0".equals(uri)) {
            super.startElement(uri, localName, name, atts);
            return;
        }
        try {
            element = Constants.Element.fromName(localName);
        }
        catch (IllegalArgumentException e) {
            throw new SAXException("Invalid element found", e);
        }
        if (element == Constants.Element.DOCUMENT) {
            if (this.state != Constants.State.OUTSIDE) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.hctDocument = new HCTDocument();
            this.hctDocument.setPath(atts.getValue(Constants.Attribute.PATH.getName()));
            this.hctDocument.setUuid(atts.getValue(Constants.Attribute.UUID.getName()));
            this.hctDocument.setDateFormat(this.parseDateFormat(atts));
        }
        if (element == Constants.Element.FOLDERS) {
            if (this.state != Constants.State.OUTSIDE) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.hctTraversal = new HCTTraversal();
            this.hctTraversal.setBase(atts.getValue(Constants.Attribute.BASE.getName()) == null ? "/" : atts.getValue(Constants.Attribute.BASE.getName()));
            this.hctTraversal.setDepth(this.parseDepth(atts));
            this.hctTraversal.setSize(this.parseSize(atts));
        }
        if (element == Constants.Element.QUERY) {
            if (this.state != Constants.State.OUTSIDE) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.state = Constants.State.INSIDE_QUERY;
            this.hctQuery = new HCTQuery();
            this.hctQuery.setBase(atts.getValue(Constants.Attribute.BASE.getName()) == null ? "/" : atts.getValue(Constants.Attribute.BASE.getName()));
            this.hctQuery.setReturnType(atts.getValue(Constants.Attribute.TYPE.getName()) == null ? "nt:base" : atts.getValue(Constants.Attribute.TYPE.getName()));
            this.hctQuery.setDateFormat(this.parseDateFormat(atts));
            this.hctQuery.setDepth(this.parseDepth(atts));
            this.hctQuery.setSize(this.parseSize(atts));
            this.hctQuery.setPage(this.parsePage(atts));
            this.hctQuery.setIncludeFolders("true".equalsIgnoreCase(atts.getValue(Constants.Attribute.INCLUDE_FOLDERS.getName())));
        }
        if (element == Constants.Element.FILTER) {
            if (this.state != Constants.State.INSIDE_QUERY) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.state = Constants.State.INSIDE_FILTER;
        }
        if (element == Constants.Element.AND || element == Constants.Element.OR) {
            if (this.state != Constants.State.INSIDE_FILTER) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            if (element == Constants.Element.AND) {
                this.state = Constants.State.INSIDE_FILTER_AND;
            }
            if (element == Constants.Element.OR) {
                this.state = Constants.State.INSIDE_FILTER_OR;
            }
        }
        if (Constants.FILTER_ELEMENTS.contains((Object)element)) {
            if (this.state != Constants.State.INSIDE_FILTER_AND && this.state != Constants.State.INSIDE_FILTER_OR) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            if (!Constants.Element.CONTAINS.getName().equals(localName) && StringUtils.isBlank((CharSequence)atts.getValue(Constants.Attribute.FIELD.getName()))) {
                throw new InvalidHCTRequestException(Constants.Attribute.FIELD.getName() + " must be specified for " + localName);
            }
            try {
                this.hctQuery.getFilter().addCond(this.state, element, atts);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
        if (element == Constants.Element.ORDERBY) {
            if (this.state != Constants.State.INSIDE_QUERY) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.state = Constants.State.INSIDE_ORDERBY;
        }
        if (element == Constants.Element.DESCENDING || element == Constants.Element.ASCENDING) {
            if (this.state != Constants.State.INSIDE_ORDERBY) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            if (StringUtils.isBlank((CharSequence)atts.getValue(Constants.Attribute.FIELD.getName()))) {
                throw new InvalidHCTRequestException(Constants.Attribute.FIELD.getName() + " must be specified for " + localName);
            }
            if (element == Constants.Element.DESCENDING) {
                this.hctQuery.addOrderByDescending(atts.getValue(Constants.Attribute.FIELD.getName()));
            }
            if (element == Constants.Element.ASCENDING) {
                this.hctQuery.addOrderByAscending(atts.getValue(Constants.Attribute.FIELD.getName()));
            }
        }
        if (element == Constants.Element.RETURN) {
            if (this.state != Constants.State.INSIDE_QUERY) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.state = Constants.State.INSIDE_RETURN;
        }
        if (element == Constants.Element.FIELD) {
            if (this.state != Constants.State.INSIDE_RETURN) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            if (StringUtils.isBlank((CharSequence)atts.getValue(Constants.Attribute.NAME.getName()))) {
                throw new InvalidHCTRequestException(Constants.Attribute.NAME.getName() + " must be specified for " + localName);
            }
            this.hctQuery.addReturnField(atts.getValue(Constants.Attribute.NAME.getName()));
        }
        if (element == Constants.Element.TAGS) {
            if (this.state != Constants.State.INSIDE_RETURN) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.hctQuery.setReturnTags(true);
        }
        if (element == Constants.Element.TAXONOMIES) {
            if (this.state != Constants.State.INSIDE_RETURN) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.hctQuery.setReturnTaxonomies(true);
        }
        if (element == Constants.Element.IMAGES) {
            if (this.state != Constants.State.INSIDE_RETURN) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.hctQuery.setReturnImages(true);
        }
        if (element == Constants.Element.RELATED_DOCS) {
            if (this.state != Constants.State.INSIDE_RETURN) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.hctQuery.setReturnRelatedDocs(true);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        HCTConnManager connManager;
        Constants.Element element;
        if (!"http://www.tirasa.net/hct/1.0".equals(uri)) {
            super.endElement(uri, localName, name);
            return;
        }
        try {
            element = Constants.Element.fromName(localName);
        }
        catch (IllegalArgumentException e) {
            throw new SAXException("Invalid element found", e);
        }
        if (element == Constants.Element.RETURN) {
            if (this.state != Constants.State.INSIDE_RETURN) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.state = Constants.State.INSIDE_QUERY;
            LOG.debug("Fields to be returned: {}; images: {}; relatedDocs: {}", new Object[]{this.hctQuery.getReturnFields(), this.hctQuery.isReturnImages(), this.hctQuery.isReturnRelatedDocs()});
        }
        if (element == Constants.Element.ORDERBY) {
            if (this.state != Constants.State.INSIDE_ORDERBY) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.state = Constants.State.INSIDE_QUERY;
        }
        if (element == Constants.Element.AND || element == Constants.Element.OR) {
            if (this.state != Constants.State.INSIDE_FILTER_AND && this.state != Constants.State.INSIDE_FILTER_OR) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.state = Constants.State.INSIDE_FILTER;
        }
        if (element == Constants.Element.FILTER) {
            if (this.state != Constants.State.INSIDE_FILTER) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.state = Constants.State.INSIDE_QUERY;
        }
        if (element == Constants.Element.QUERY) {
            if (this.state != Constants.State.INSIDE_QUERY) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            this.state = Constants.State.OUTSIDE;
            connManager = HCTConnManager.getContentInstance();
            try {
                this.query(connManager);
            }
            catch (Exception e) {
                throw new ProcessingException("While performing query " + this.hctQuery.getSQLQuery(), (Throwable)e);
            }
            finally {
                connManager.logout();
            }
        }
        if (element == Constants.Element.FOLDERS) {
            if (this.state != Constants.State.OUTSIDE) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            connManager = HCTConnManager.getContentInstance();
            try {
                this.traverse(connManager);
            }
            catch (Exception e) {
                throw new ProcessingException("While performing traversal " + this.hctTraversal, (Throwable)e);
            }
            finally {
                connManager.logout();
            }
        }
        if (element == Constants.Element.DOCUMENT) {
            if (this.state != Constants.State.OUTSIDE) {
                throw new InvalidHCTRequestException(localName, this.state);
            }
            connManager = HCTConnManager.getContentInstance();
            try {
                this.document(connManager);
            }
            catch (Exception e) {
                throw new ProcessingException("While fetching document", (Throwable)e);
            }
            finally {
                connManager.logout();
            }
        }
    }
}

