/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.cocoon.sax;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import net.tirasa.hct.repository.HCTConnManager;
import net.tirasa.hct.util.ObjectUtils;
import org.apache.cocoon.pipeline.ProcessingException;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.TimestampCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.sitemap.component.AbstractReader;
import org.hippoecm.hst.content.beans.standard.HippoAsset;
import org.hippoecm.hst.content.beans.standard.HippoGalleryImageBean;
import org.hippoecm.hst.content.beans.standard.HippoGalleryImageSet;
import org.hippoecm.hst.content.beans.standard.HippoItem;
import org.hippoecm.hst.content.beans.standard.HippoResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HippoRepositoryReader
extends AbstractReader
implements CachingPipelineComponent {
    private static final Logger LOG = LoggerFactory.getLogger(HippoRepositoryReader.class);
    private transient String uuid;
    private transient long lastmodified;
    private transient String contentType;

    public HippoRepositoryReader() {
    }

    public HippoRepositoryReader(URL source) {
        super(source);
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setup(configuration);
    }

    public void setup(Map<String, Object> parameters) {
        ImageType imageType;
        if (parameters == null) {
            return;
        }
        if (parameters.containsKey("source")) {
            super.setSource((URL)parameters.get("source"));
        }
        if (this.source == null) {
            throw new SetupException(((Object)((Object)this)).getClass().getSimpleName() + " has no source configured to read from.");
        }
        String nodePath = this.source.toExternalForm().substring(this.source.toExternalForm().indexOf(58) + 1);
        ImageType imageType2 = imageType = nodePath.endsWith(":" + ImageType.thumbnail.name()) ? ImageType.thumbnail : ImageType.original;
        if (nodePath.endsWith(":" + imageType.name())) {
            LOG.debug("Selected image type is {}", (Object)imageType);
            nodePath = nodePath.substring(0, nodePath.lastIndexOf(58));
        }
        HCTConnManager connManager = HCTConnManager.getBinaryInstance();
        try {
            HippoItem obj = ObjectUtils.getHippoItem(connManager, nodePath);
            if (obj instanceof HippoGalleryImageSet) {
                HippoGalleryImageBean imgBean = imageType == ImageType.thumbnail ? ((HippoGalleryImageSet)obj).getThumbnail() : ((HippoGalleryImageSet)obj).getOriginal();
                this.lastmodified = imgBean.getLastModified().getTimeInMillis();
                this.uuid = imgBean.getNode().getIdentifier();
            } else if (obj instanceof HippoAsset) {
                List resources = ((HippoAsset)obj).getChildBeans(HippoResource.class);
                if (resources != null && !resources.isEmpty()) {
                    HippoResource asset = (HippoResource)resources.get(0);
                    this.lastmodified = asset.getLastModified().getTimeInMillis();
                    this.uuid = asset.getNode().getIdentifier();
                }
            } else {
                LOG.warn("Unexpected node type: {}", (Object)obj.getClass().getName());
                this.lastmodified = -1L;
                this.uuid = null;
            }
        }
        catch (Exception e) {
            throw new ProcessingException("While reading " + nodePath, (Throwable)e);
        }
        finally {
            connManager.logout();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public CacheKey constructCacheKey() {
        if (this.source == null) {
            throw new SetupException(((Object)((Object)this)).getClass().getSimpleName() + " has no source configured to read from.");
        }
        return new TimestampCacheKey(this.source, this.lastmodified);
    }

    public void execute() {
        if (this.uuid == null) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " wasn't able to read from given URL.");
        }
        HCTConnManager connManager = HCTConnManager.getBinaryInstance();
        BufferedInputStream repositoryIS = null;
        try {
            Node node = connManager.getSession().getNodeByIdentifier(this.uuid);
            this.contentType = node.getProperty("jcr:mimeType").getString();
            repositoryIS = new BufferedInputStream(node.getProperty("jcr:data").getBinary().getStream());
            byte[] buffer = new byte[1024];
            while (repositoryIS.available() != 0) {
                int len = repositoryIS.read(buffer);
                this.outputStream.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            throw new ProcessingException("While reading node", (Throwable)e);
        }
        finally {
            if (repositoryIS != null) {
                try {
                    repositoryIS.close();
                }
                catch (IOException ioe) {
                    LOG.error("While closing InputSTream", (Throwable)ioe);
                }
            }
            connManager.logout();
        }
    }

    private static enum ImageType {
        thumbnail,
        original;

    }
}

