/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.cocoon.sax;

import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import net.tirasa.hct.cocoon.sax.Constants;
import net.tirasa.hct.hstbeans.HCTTaxonomyCategoryBean;
import net.tirasa.hct.hstbeans.HippoCompoundDocument;
import net.tirasa.hct.hstbeans.HippoDate;
import net.tirasa.hct.hstbeans.ImageLinkBean;
import net.tirasa.hct.hstbeans.RelatedDocs;
import net.tirasa.hct.repository.HCTConnManager;
import net.tirasa.hct.repository.HCTQuery;
import net.tirasa.hct.repository.HCTQueryResult;
import net.tirasa.hct.util.ObjectUtils;
import net.tirasa.hct.util.TaxonomyUtils;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.cocoon.sax.util.XMLUtils;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.commons.lang3.StringUtils;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.standard.HippoAsset;
import org.hippoecm.hst.content.beans.standard.HippoDocument;
import org.hippoecm.hst.content.beans.standard.HippoFacetSelect;
import org.hippoecm.hst.content.beans.standard.HippoFolder;
import org.hippoecm.hst.content.beans.standard.HippoGalleryImageSet;
import org.hippoecm.hst.content.beans.standard.HippoHtml;
import org.hippoecm.hst.content.beans.standard.HippoItem;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class HippoItemXMLDumper {
    private final transient SAXConsumer saxConsumer;

    public HippoItemXMLDumper(SAXConsumer saxConsumer) {
        this.saxConsumer = saxConsumer;
    }

    public void startQueryResult(HCTQueryResult result, HippoItem base) throws SAXException, RepositoryException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", Constants.Attribute.SIZE.getName(), Constants.Attribute.SIZE.getName(), "xsd:long", String.valueOf(result.getUuids().size()));
        attrs.addAttribute("", Constants.Attribute.PAGE.getName(), Constants.Attribute.PAGE.getName(), "xsd:long", String.valueOf(result.getPage()));
        attrs.addAttribute("", Constants.Attribute.TOTAL_PAGES.getName(), Constants.Attribute.TOTAL_PAGES.getName(), "xsd:long", String.valueOf(result.getTotalPages()));
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.QUERY_RESULT.getName(), "hct:" + Constants.Element.QUERY_RESULT.getName(), (Attributes)attrs);
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.BASE.getName(), "hct:" + Constants.Element.BASE.getName(), Constants.EMPTY_ATTRS);
        if (base != null) {
            if (base instanceof HCTTaxonomyCategoryBean) {
                this.startTaxonomy((HCTTaxonomyCategoryBean)base, result.getLocale());
                this.endTaxonomy();
            } else {
                this.startHippoItem(base, base.getPath());
                this.endHippoItem(base);
            }
        }
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.BASE.getName(), "hct:" + Constants.Element.BASE.getName());
    }

    public void endQueryResult() throws SAXException {
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.QUERY_RESULT.getName(), "hct:" + Constants.Element.QUERY_RESULT.getName());
    }

    public <T extends HippoItem> void startHippoItem(T item, String path) throws SAXException, RepositoryException {
        Constants.Element elem;
        Constants.Element element = elem = item instanceof HippoDocument ? Constants.Element.DOCUMENT : Constants.Element.FOLDER;
        String localeString = item instanceof HippoDocument ? ((HippoDocument)item).getLocaleString() : (item instanceof HippoFolder ? ((HippoFolder)item).getLocaleString() : "");
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", item.getName());
        attrs.addAttribute("", Constants.Attribute.TYPE.getName(), Constants.Attribute.TYPE.getName(), "xsd:string", item.getNode().getPrimaryNodeType().getName());
        attrs.addAttribute("", Constants.Attribute.PATH.getName(), Constants.Attribute.PATH.getName(), "xsd:string", path);
        attrs.addAttribute("", Constants.Attribute.LOC_NAME.getName(), Constants.Attribute.LOC_NAME.getName(), "xsd:string", item.getLocalizedName());
        attrs.addAttribute("", Constants.Attribute.LOCALE.getName(), Constants.Attribute.LOCALE.getName(), "xsd:string", localeString);
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", elem.getName(), "hct:" + elem.getName(), (Attributes)attrs);
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.TRANSLATIONS.getName(), "hct:" + Constants.Element.TRANSLATIONS.getName(), Constants.EMPTY_ATTRS);
        for (String locale : item.getAvailableTranslationsBean().getAvailableLocales()) {
            if (localeString.equals(locale)) continue;
            attrs = new AttributesImpl();
            attrs.addAttribute("", Constants.Attribute.LOCALE.getName(), Constants.Attribute.LOCALE.getName(), "xsd:string", locale);
            attrs.addAttribute("", Constants.Attribute.PATH.getName(), Constants.Attribute.PATH.getName(), "xsd:string", item.getAvailableTranslationsBean().getTranslation(locale).getContextualBean().getPath());
            attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", item.getAvailableTranslationsBean().getTranslation(locale).getContextualBean().getName());
            attrs.addAttribute("", Constants.Attribute.LOC_NAME.getName(), Constants.Attribute.LOC_NAME.getName(), "xsd:string", item.getAvailableTranslationsBean().getTranslation(locale).getContextualBean().getLocalizedName());
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.TRANSLATION.getName(), "hct:" + Constants.Element.TRANSLATION.getName(), (Attributes)attrs);
            if (item instanceof HippoDocument) {
                attrs = new AttributesImpl();
                attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", "hippo:availability");
                this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.FIELD.getName(), "hct:" + Constants.Element.FIELD.getName(), (Attributes)attrs);
                for (String value : (String[])item.getAvailableTranslationsBean().getTranslation(locale).getProperty("hippo:availability")) {
                    this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName(), Constants.EMPTY_ATTRS);
                    this.saxConsumer.characters(value.toCharArray(), 0, value.length());
                    this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName());
                }
                this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.FIELD.getName(), "hct:" + Constants.Element.FIELD.getName());
            }
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.TRANSLATION.getName(), "hct:" + Constants.Element.TRANSLATION.getName());
        }
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.TRANSLATIONS.getName(), "hct:" + Constants.Element.TRANSLATIONS.getName());
    }

    public void endHippoItem(HippoItem item) throws SAXException {
        Constants.Element elem = item instanceof HippoDocument ? Constants.Element.DOCUMENT : Constants.Element.FOLDER;
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", elem.getName(), "hct:" + elem.getName());
    }

    public void startHippoCompounds() throws SAXException, RepositoryException {
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.COMPOUNDS.getName(), "hct:" + Constants.Element.COMPOUNDS.getName(), Constants.EMPTY_ATTRS);
    }

    public void endHippoCompounds() throws SAXException {
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.COMPOUNDS.getName(), "hct:" + Constants.Element.COMPOUNDS.getName());
    }

    public void startHippoCompound(HippoDocument compound) throws SAXException, RepositoryException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", compound.getName());
        attrs.addAttribute("", Constants.Attribute.TYPE.getName(), Constants.Attribute.TYPE.getName(), "xsd:string", compound.getNode().getPrimaryNodeType().getName());
        attrs.addAttribute("", Constants.Attribute.PATH.getName(), Constants.Attribute.PATH.getName(), "xsd:string", compound.getPath());
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.COMPOUND.getName(), "hct:" + Constants.Element.COMPOUND.getName(), (Attributes)attrs);
    }

    public void endHippoCompound(HippoDocument compound) throws SAXException {
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.COMPOUND.getName(), "hct:" + Constants.Element.COMPOUND.getName());
    }

    public void dumpAssets(List<HippoAsset> assets, String elementName, boolean wrap, String dateFormat, Locale locale) throws SAXException {
        if (wrap) {
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.ASSETS.getName(), "hct:" + Constants.Element.ASSETS.getName(), Constants.EMPTY_ATTRS);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, locale);
        for (HippoAsset asset : assets) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", asset.getName());
            if (asset.getParentBean().getBean("hippo:translation") != null) {
                attrs.addAttribute("", Constants.Attribute.LOC_NAME.getName(), Constants.Attribute.LOC_NAME.getName(), "xsd:string", ((String)((HippoItem)asset.getParentBean().getBean("hippo:translation")).getProperty("hippo:message", (Object)asset.getName())).toString());
            }
            attrs.addAttribute("", Constants.Attribute.PATH.getName(), Constants.Attribute.PATH.getName(), "xsd:string", asset.getPath());
            attrs.addAttribute("", Constants.Attribute.MIMETYPE.getName(), Constants.Attribute.MIMETYPE.getName(), "xsd:string", asset.getAsset().getMimeType());
            attrs.addAttribute("", Constants.Attribute.SIZE_KB.getName(), Constants.Attribute.SIZE_KB.getName(), "xsd:integer", String.valueOf(asset.getAsset().getLengthKB()));
            attrs.addAttribute("", Constants.Attribute.LAST_MOD.getName(), Constants.Attribute.LAST_MOD.getName(), "xsd:dateTime", sdf.format(asset.getAsset().getLastModified().getTime()));
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", elementName, "hct:" + elementName, (Attributes)attrs);
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", elementName, "hct:" + elementName);
        }
        if (wrap) {
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.ASSETS.getName(), "hct:" + Constants.Element.ASSETS.getName());
        }
    }

    public void dumpImages(List<HippoGalleryImageSet> images, String elementName, boolean wrap) throws SAXException, ObjectBeanManagerException {
        if (wrap) {
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.IMAGES.getName(), "hct:" + Constants.Element.IMAGES.getName(), Constants.EMPTY_ATTRS);
        }
        for (HippoGalleryImageSet img : images) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", Constants.Attribute.PATH.getName(), Constants.Attribute.PATH.getName(), "xsd:string", img.getPath());
            attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", img.getName());
            if (StringUtils.isNotBlank((CharSequence)img.getDescription())) {
                attrs.addAttribute("", Constants.Attribute.DESC.getName(), Constants.Attribute.DESC.getName(), "xsd:string", img.getDescription());
            }
            attrs.addAttribute("", Constants.Attribute.HEIGHT.getName(), Constants.Attribute.HEIGHT.getName(), "xsd:integer", String.valueOf(img.getOriginal().getHeight()));
            attrs.addAttribute("", Constants.Attribute.WIDTH.getName(), Constants.Attribute.WIDTH.getName(), "xsd:integer", String.valueOf(img.getOriginal().getWidth()));
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", elementName, "hct:" + elementName, (Attributes)attrs);
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", elementName, "hct:" + elementName);
        }
        if (wrap) {
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.IMAGES.getName(), "hct:" + Constants.Element.IMAGES.getName());
        }
    }

    public void dumpRelatedDocs(List<HippoDocument> relDocs, String elementName, boolean wrap) throws SAXException, ObjectBeanManagerException {
        if (wrap) {
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.RELATED_DOCS.getName(), "hct:" + Constants.Element.RELATED_DOCS.getName(), Constants.EMPTY_ATTRS);
        }
        for (HippoDocument relDoc : relDocs) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", relDoc.getName());
            attrs.addAttribute("", Constants.Attribute.PATH.getName(), Constants.Attribute.PATH.getName(), "xsd:string", relDoc.getPath());
            attrs.addAttribute("", Constants.Attribute.LOC_NAME.getName(), Constants.Attribute.LOC_NAME.getName(), "xsd:string", relDoc.getLocalizedName());
            attrs.addAttribute("", Constants.Attribute.LOCALE.getName(), Constants.Attribute.LOCALE.getName(), "xsd:string", relDoc.getLocalizedName());
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", elementName, "hct:" + elementName, (Attributes)attrs);
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", elementName, "hct:" + elementName);
        }
        if (wrap) {
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.RELATED_DOCS.getName(), "hct:" + Constants.Element.RELATED_DOCS.getName());
        }
    }

    public void dumpTags(String[] tags) throws SAXException {
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.TAGS.getName(), "hct:" + Constants.Element.TAGS.getName(), Constants.EMPTY_ATTRS);
        for (int i = 0; tags != null && i < tags.length; ++i) {
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.TAG.getName(), "hct:" + Constants.Element.TAG.getName(), Constants.EMPTY_ATTRS);
            this.saxConsumer.characters(tags[i].toCharArray(), 0, tags[i].length());
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.TAG.getName(), "hct:" + Constants.Element.TAG.getName());
        }
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.TAGS.getName(), "hct:" + Constants.Element.TAGS.getName());
    }

    public void startTaxonomy(HCTTaxonomyCategoryBean taxonomy, Locale locale) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", taxonomy.getKey());
        attrs.addAttribute("", Constants.Attribute.LOC_NAME.getName(), Constants.Attribute.LOC_NAME.getName(), "xsd:string", taxonomy.getLocalizedName(locale.getLanguage()));
        attrs.addAttribute("", Constants.Attribute.ORDER.getName(), Constants.Attribute.ORDER.getName(), "xsd:string", taxonomy.getOrder(locale.getLanguage()));
        attrs.addAttribute("", Constants.Attribute.PATH.getName(), Constants.Attribute.PATH.getName(), "xsd:string", taxonomy.getPath());
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.TAXONOMY.getName(), "hct:" + Constants.Element.TAXONOMY.getName(), (Attributes)attrs);
    }

    public void endTaxonomy() throws SAXException {
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.TAXONOMY.getName(), "hct:" + Constants.Element.TAXONOMY.getName());
    }

    public void dumpTaxonomies(List<HCTTaxonomyCategoryBean> taxonomies, Locale locale) throws SAXException {
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.TAXONOMIES.getName(), "hct:" + Constants.Element.TAXONOMIES.getName(), Constants.EMPTY_ATTRS);
        for (HCTTaxonomyCategoryBean taxonomy : taxonomies) {
            this.startTaxonomy(taxonomy, locale);
            this.endTaxonomy();
        }
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.TAXONOMIES.getName(), "hct:" + Constants.Element.TAXONOMIES.getName());
    }

    public void dumpField(Map.Entry<String, Object> entry, String dateFormat, Locale locale) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", entry.getKey());
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.FIELD.getName(), "hct:" + Constants.Element.FIELD.getName(), (Attributes)attrs);
        if (entry.getValue() instanceof String) {
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName(), Constants.EMPTY_ATTRS);
            this.saxConsumer.characters(((String)entry.getValue()).toCharArray(), 0, ((String)entry.getValue()).length());
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName());
        } else if (entry.getValue() instanceof Boolean) {
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName(), Constants.EMPTY_ATTRS);
            this.saxConsumer.characters(((Boolean)entry.getValue()).toString().toCharArray(), 0, ((Boolean)entry.getValue()).toString().length());
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName());
        } else if (entry.getValue() instanceof GregorianCalendar) {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, locale);
            String date = sdf.format(((GregorianCalendar)entry.getValue()).getTime());
            this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName(), Constants.EMPTY_ATTRS);
            this.saxConsumer.characters(date.toCharArray(), 0, date.length());
            this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName());
        } else if (entry.getValue() instanceof String[]) {
            for (int i = 0; i < ((String[])entry.getValue()).length; ++i) {
                this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName(), Constants.EMPTY_ATTRS);
                this.saxConsumer.characters(((String[])entry.getValue())[i].toCharArray(), 0, ((String[])entry.getValue())[i].length());
                this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.VALUE.getName(), "hct:" + Constants.Element.VALUE.getName());
            }
        }
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.FIELD.getName(), "hct:" + Constants.Element.FIELD.getName());
    }

    public void dumpDate(String name, Calendar calendar, String dateFormat, Locale locale) throws SAXException {
        this.dumpField((Map.Entry<String, Object>)new DefaultMapEntry((Object)name, (Object)calendar), dateFormat, locale);
    }

    public void dumpHtml(HCTConnManager connManager, HippoHtml rtf, XMLReader xmlReader, String dateFormat, Locale locale) throws SAXException, IOException, ObjectBeanManagerException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", Constants.Attribute.NAME.getName(), Constants.Attribute.NAME.getName(), "xsd:string", rtf.getName());
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.FIELD.getName(), "hct:" + Constants.Element.FIELD.getName(), (Attributes)attrs);
        xmlReader.parse(new InputSource(new StringReader(rtf.getContent())));
        ArrayList<HippoGalleryImageSet> images = new ArrayList<HippoGalleryImageSet>();
        ArrayList<HippoAsset> assets = new ArrayList<HippoAsset>();
        ArrayList<HippoDocument> docs = new ArrayList<HippoDocument>();
        for (HippoFacetSelect facetSelect : rtf.getChildBeans(HippoFacetSelect.class)) {
            HippoItem subElement = ObjectUtils.getHippoItemByUuid(connManager, (String)facetSelect.getProperty("hippo:docbase"));
            if (subElement instanceof HippoGalleryImageSet) {
                images.add((HippoGalleryImageSet)subElement);
            }
            if (subElement instanceof HippoAsset) {
                assets.add((HippoAsset)subElement);
                continue;
            }
            if (!(subElement instanceof HippoDocument)) continue;
            docs.add((HippoDocument)subElement);
        }
        this.saxConsumer.startElement("http://www.tirasa.net/hct/1.0", Constants.Element.LINKS.getName(), "hct:" + Constants.Element.LINKS.getName(), Constants.EMPTY_ATTRS);
        this.dumpImages(images, Constants.Element.LINK.getName(), false);
        this.dumpAssets(assets, Constants.Element.LINK.getName(), false, dateFormat, locale);
        this.dumpRelatedDocs(docs, Constants.Element.LINK.getName(), false);
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.LINKS.getName(), "hct:" + Constants.Element.LINKS.getName());
        this.saxConsumer.endElement("http://www.tirasa.net/hct/1.0", Constants.Element.FIELD.getName(), "hct:" + Constants.Element.FIELD.getName());
    }

    public void dumpHippoItem(HCTConnManager connManager, HippoItem item, String itemPath, HCTQuery hctQuery, Locale locale) throws SAXException, RepositoryException, IOException, ObjectBeanManagerException {
        Constants.StartEndDocumentFilter xmlReader = new Constants.StartEndDocumentFilter(XMLUtils.createXMLReader((ContentHandler)this.saxConsumer));
        xmlReader.setContentHandler((ContentHandler)this.saxConsumer);
        this.startHippoItem(item, itemPath);
        for (String fieldName : hctQuery.getReturnFields()) {
            Object fieldValue = null;
            if (fieldName.contains("/")) {
                String[] splitted = fieldName.split("/");
                List compounds = item.getChildBeansByName(splitted[0], HippoCompoundDocument.class);
                if (!compounds.isEmpty()) {
                    fieldValue = ((HippoCompoundDocument)((Object)compounds.iterator().next())).getProperty(splitted[1]);
                }
            } else {
                fieldValue = item.getProperty(fieldName);
            }
            if (fieldValue == null) {
                List rtfs = item.getChildBeansByName(fieldName, HippoHtml.class);
                List dates = item.getChildBeansByName(fieldName, HippoDate.class);
                if (rtfs != null && !rtfs.isEmpty()) {
                    for (HippoHtml rtf : rtfs) {
                        this.dumpHtml(connManager, rtf, xmlReader, hctQuery.getDateFormat(), locale);
                    }
                }
                if (dates == null || dates.isEmpty()) continue;
                for (HippoDate date : dates) {
                    this.dumpDate(fieldName, date.getCalendar(), hctQuery.getDateFormat(), locale);
                }
                continue;
            }
            this.dumpField((Map.Entry<String, Object>)new DefaultMapEntry((Object)fieldName, fieldValue), hctQuery.getDateFormat(), locale);
        }
        if (hctQuery.isReturnTags()) {
            this.dumpTags((String[])item.getProperty("hippostd:tags"));
        }
        if (hctQuery.isReturnTaxonomies()) {
            this.dumpTaxonomies(TaxonomyUtils.getTaxonomies(connManager, (String[])item.getProperty("hippotaxonomy:keys")), locale);
        }
        if (hctQuery.isReturnImages()) {
            ArrayList<HippoGalleryImageSet> images = new ArrayList<HippoGalleryImageSet>();
            for (ImageLinkBean imgLink : item.getChildBeans(ImageLinkBean.class)) {
                HippoItem imgLinkItem;
                Node imgLinkNode = null;
                try {
                    imgLinkNode = connManager.getSession().getNodeByIdentifier(imgLink.getImageSetUuid());
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                if (imgLinkNode == null || !((imgLinkItem = ObjectUtils.getHippoItem(connManager, imgLinkNode)) instanceof HippoGalleryImageSet)) continue;
                images.add((HippoGalleryImageSet)imgLinkItem);
            }
            this.dumpImages(images, Constants.Element.IMAGE.getName(), true);
        }
        if (hctQuery.isReturnRelatedDocs()) {
            ArrayList<HippoDocument> relDocs = new ArrayList<HippoDocument>();
            for (RelatedDocs docs : item.getChildBeans(RelatedDocs.class)) {
                for (String relDocUuid : docs.getRelatedDocsUuids()) {
                    relDocs.add(ObjectUtils.getHippoItemByUuid(connManager, relDocUuid, HippoDocument.class));
                }
            }
            this.dumpRelatedDocs(relDocs, Constants.Element.DOCUMENT.getName(), true);
        }
        this.endHippoItem(item);
    }
}

