/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.hct.cocoon.cache;

import java.util.HashSet;
import java.util.Map;
import net.tirasa.hct.cocoon.cache.AvailabilityLocaleCacheKey;
import net.tirasa.hct.cocoon.sax.Constants;
import net.tirasa.hct.util.ApplicationContextProvider;
import org.apache.cocoon.pipeline.caching.Cache;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.CompoundCacheKey;
import org.apache.cocoon.pipeline.caching.ParameterCacheKey;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.hippoecm.hst.content.beans.ObjectBeanManagerException;
import org.hippoecm.hst.content.beans.standard.HippoDocument;
import org.onehippo.forge.repositoryeventlistener.hst.events.BaseHippoEventSubscriber;
import org.onehippo.forge.repositoryeventlistener.hst.hippo.HippoEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheExpirerRepositoryEventSubscriber
extends BaseHippoEventSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(CacheExpirerRepositoryEventSubscriber.class);

    public String getName() {
        return CacheExpirerRepositoryEventSubscriber.class.getName();
    }

    private boolean findExpiredCacheKeys(CacheKey cacheKey, Constants.Availability availability, String locale) {
        if (cacheKey instanceof AvailabilityLocaleCacheKey) {
            AvailabilityLocaleCacheKey alck = (AvailabilityLocaleCacheKey)cacheKey;
            return alck.getAvailability().equals((Object)availability) && alck.getLocale().equals(LocaleUtils.toLocale((String)locale));
        }
        if (cacheKey instanceof CompoundCacheKey) {
            CompoundCacheKey compound = (CompoundCacheKey)cacheKey;
            boolean found = false;
            for (CacheKey inner : compound.getCacheKeys()) {
                found |= this.findExpiredCacheKeys(inner, availability, locale);
            }
            return found;
        }
        if (cacheKey instanceof ParameterCacheKey) {
            ParameterCacheKey pck = (ParameterCacheKey)cacheKey;
            Map parameters = pck.getParameters();
            return parameters.containsKey("availability") && ((String)parameters.get("availability")).equals(availability.name()) && parameters.containsKey("locale") && ((String)parameters.get("locale")).equals(locale);
        }
        return false;
    }

    public void onEvent(HippoEvent event) {
        Constants.Availability availability;
        LOG.debug("Event '{}' received about {}", (Object)event.getType(), (Object)event.getPath());
        String locale = null;
        try {
            HippoDocument doc = (HippoDocument)this.getObjectBeanManager().getObject(event.getPath());
            locale = doc.getLocaleString();
        }
        catch (ObjectBeanManagerException e) {
            LOG.error("Could not get HippoDocument for {}", (Object)event.getPath(), (Object)e);
        }
        if (StringUtils.isBlank((CharSequence)locale)) {
            return;
        }
        switch (event.getType()) {
            case PUBLISHED: 
            case UNPUBLISHED: {
                availability = Constants.Availability.live;
                break;
            }
            default: {
                availability = Constants.Availability.preview;
            }
        }
        LOG.debug("Expiring {} {}", (Object)locale, (Object)availability);
        Cache cache = (Cache)ApplicationContextProvider.getApplicationContext().getBean(Cache.class);
        LOG.debug("Cocoon cache obtained: {}", (Object)cache);
        HashSet<CacheKey> expired = new HashSet<CacheKey>();
        for (CacheKey key : cache.keySet()) {
            if (!this.findExpiredCacheKeys(key, availability, locale)) continue;
            expired.add(key);
        }
        LOG.debug("Cache keys to remove #{} {}", (Object)expired.size(), expired);
        LOG.debug("# of cache keys before removal: {}", (Object)cache.keySet().size());
        for (CacheKey key : expired) {
            cache.remove(key);
        }
        LOG.debug("# of cache keys after removal: {}", (Object)cache.keySet().size());
    }
}

