/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.test.common;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.test.common.PropertyBag;
import org.identityconnectors.test.common.ToListResultsHandler;
import org.identityconnectors.test.common.spi.TestHelpersSpi;

public final class TestHelpers {
    private static final Object LOCK = new Object();
    private static final String IMPL_NAME = "org.identityconnectors.framework.impl.test.TestHelpersImpl";
    private static TestHelpersSpi instance;
    private static final Map<String, PropertyBag> BAGS;

    private TestHelpers() {
    }

    public static APIConfiguration createTestConfiguration(Class<? extends Connector> clazz, Configuration config) {
        return TestHelpers.getSpi().createTestConfiguration(clazz, config);
    }

    public static APIConfiguration createTestConfiguration(Class<? extends Connector> clazz, PropertyBag configData, String prefix) {
        URL url = clazz.getClassLoader().getResource("");
        HashSet<String> bundleContents = new HashSet<String>();
        try {
            URI relative = url.toURI();
            for (File file : new File(url.toURI()).listFiles()) {
                bundleContents.add(relative.relativize(file.toURI()).getPath());
            }
            return TestHelpers.getSpi().createTestConfiguration(clazz, bundleContents, configData, prefix);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static void fillConfiguration(Configuration config, Map<String, ? extends Object> configData) {
        TestHelpers.getSpi().fillConfiguration(config, configData);
    }

    public static ConnectorMessages createDummyMessages() {
        return TestHelpers.getSpi().createDummyMessages();
    }

    public static List<ConnectorObject> searchToList(SearchApiOp search, ObjectClass objectClass, Filter filter) {
        return TestHelpers.searchToList(search, objectClass, filter, null);
    }

    public static List<ConnectorObject> searchToList(SearchApiOp search, ObjectClass objectClass, Filter filter, OperationOptions options) {
        ToListResultsHandler handler = new ToListResultsHandler();
        search.search(objectClass, filter, (ResultsHandler)handler, options);
        return handler.getObjects();
    }

    public static List<ConnectorObject> searchToList(SearchOp<?> search, ObjectClass objectClass, Filter filter) {
        return TestHelpers.searchToList(search, objectClass, filter, null);
    }

    public static List<ConnectorObject> searchToList(SearchOp<?> search, ObjectClass objectClass, Filter filter, OperationOptions options) {
        ToListResultsHandler handler = new ToListResultsHandler();
        TestHelpers.search(search, objectClass, filter, handler, options);
        return handler.getObjects();
    }

    public static void search(SearchOp<?> search, ObjectClass objectClass, Filter filter, ResultsHandler handler, OperationOptions options) {
        TestHelpers.getSpi().search(search, objectClass, filter, handler, options);
    }

    private static synchronized TestHelpersSpi getSpi() {
        if (instance == null) {
            try {
                Class<?> clazz = Class.forName(IMPL_NAME);
                Object object = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                instance = (TestHelpersSpi)TestHelpersSpi.class.cast(object);
            }
            catch (Exception e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }
        return instance;
    }

    public static PropertyBag getProperties(Class<?> clazz) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            throw new IllegalStateException("Thread.currentThread().getContextClassLoader() is null, please set context ClassLoader");
        }
        return TestHelpers.getProperties(clazz, null, loader);
    }

    public static PropertyBag getProperties(Class<?> clazz, String environment) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            throw new IllegalStateException("Thread.currentThread().getContextClassLoader() is null, please set context ClassLoader");
        }
        return TestHelpers.getProperties(clazz, environment, loader);
    }

    static Map<?, ?> loadGroovyConfigFile(URL url, String environment) {
        try {
            Class<?> slurper = Class.forName("groovy.util.ConfigSlurper");
            Class<?> configObject = Class.forName("groovy.util.ConfigObject");
            Object slurpInstance = StringUtil.isBlank((String)environment) ? slurper.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : slurper.getConstructor(String.class).newInstance(environment);
            Method parse = slurper.getMethod("parse", URL.class);
            Object config = parse.invoke(slurpInstance, url);
            Method toProps = configObject.getMethod("flatten", new Class[0]);
            Object result = toProps.invoke(config, new Object[0]);
            return (Map)result;
        }
        catch (Exception e) {
            throw new ConnectorException(MessageFormat.format("Could not load Groovy config file ''{0}''", url), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PropertyBag getProperties(Class<?> clazz, String environment, ClassLoader loader) {
        Object object = LOCK;
        synchronized (object) {
            String key = StringUtil.isBlank((String)environment) ? clazz.getName() : clazz.getName() + "/" + environment;
            PropertyBag bag = BAGS.get(key);
            if (bag == null) {
                bag = TestHelpers.loadConnectorConfigurationAsResource(clazz.getName(), environment, loader);
                BAGS.put(key, bag);
            }
            return bag;
        }
    }

    static PropertyBag loadConnectorConfigurationAsResource(String prefix, String environment, ClassLoader loader) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String cfg = System.getProperty("testConfig", null);
        URL url = loader.getResource(prefix + "/config/config.groovy");
        if (url != null) {
            TestHelpers.appendProperties(ret, TestHelpers.loadGroovyConfigFile(url, environment));
        }
        if (StringUtil.isNotBlank((String)cfg) && !"default".equals(cfg) && (url = loader.getResource(prefix + "/config/" + cfg + "/config.groovy")) != null) {
            TestHelpers.appendProperties(ret, TestHelpers.loadGroovyConfigFile(url, environment));
        }
        if ((url = loader.getResource(prefix + "/config-private/config.groovy")) != null) {
            TestHelpers.appendProperties(ret, TestHelpers.loadGroovyConfigFile(url, environment));
        }
        if (StringUtil.isNotBlank((String)cfg) && !"default".equals(cfg) && (url = loader.getResource(prefix + "/config-private/" + cfg + "/config.groovy")) != null) {
            TestHelpers.appendProperties(ret, TestHelpers.loadGroovyConfigFile(url, environment));
        }
        return new PropertyBag(ret);
    }

    static void appendProperties(Map<String, Object> ret, Map<?, ?> props) {
        if (props != null) {
            props.forEach((key, value) -> {
                if (!(key instanceof String)) {
                    throw new IllegalStateException("Entry in read properties has not string key : " + key + "," + value);
                }
                ret.put((String)key, value);
            });
        }
    }

    static {
        BAGS = new HashMap<String, PropertyBag>();
    }
}

