/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects.filter;

import java.util.List;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.ContainsAllValuesFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilterTranslatorTests {
    @Test
    public void testBasics() {
        Attribute attribute = AttributeBuilder.build((String)"att-name", (Object[])new Object[]{"att-value"});
        Attribute attribute2 = AttributeBuilder.build((String)"att-name2", (Object[])new Object[]{"att-value2"});
        AllFiltersTranslator translator = new AllFiltersTranslator();
        Filter filter = FilterBuilder.contains((Attribute)attribute);
        Object expected = "( CONTAINS att-name att-value )";
        String actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.endsWith((Attribute)attribute);
        expected = "( ENDS-WITH att-name att-value )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.equalTo((Attribute)attribute);
        expected = "( = att-name [att-value] )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.equalsIgnoreCase((Attribute)attribute);
        expected = "( EQUALSIGNORECASE att-name att-value )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.greaterThan((Attribute)attribute);
        expected = "( > att-name att-value )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.greaterThanOrEqualTo((Attribute)attribute);
        expected = "( >= att-name att-value )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.lessThan((Attribute)attribute);
        expected = "( < att-name att-value )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.lessThanOrEqualTo((Attribute)attribute);
        expected = "( <= att-name att-value )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.startsWith((Attribute)attribute);
        expected = "( STARTS-WITH att-name att-value )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.containsAllValues((Attribute)attribute);
        expected = "( CONTAINS-ALL-VALUES " + attribute + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( ! " + (String)expected + " )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        Filter left = FilterBuilder.contains((Attribute)attribute);
        Filter right = FilterBuilder.contains((Attribute)attribute2);
        Object expectedLeft = "( CONTAINS att-name att-value )";
        Object expectedRight = "( CONTAINS att-name2 att-value2 )";
        Filter filter2 = FilterBuilder.and((Filter)left, (Filter)right);
        String expected2 = "( & " + (String)expectedLeft + " " + (String)expectedRight + " )";
        String actual2 = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter2);
        Assertions.assertEquals((Object)actual2, (Object)expected2);
        filter2 = FilterBuilder.not((Filter)filter2);
        expectedLeft = "( ! " + (String)expectedLeft + " )";
        expectedRight = "( ! " + (String)expectedRight + " )";
        expected2 = "( | " + (String)expectedLeft + " " + (String)expectedRight + " )";
        actual2 = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter2);
        Assertions.assertEquals((Object)actual2, (Object)expected2);
        left = FilterBuilder.contains((Attribute)attribute);
        right = FilterBuilder.contains((Attribute)attribute2);
        expectedLeft = "( CONTAINS att-name att-value )";
        expectedRight = "( CONTAINS att-name2 att-value2 )";
        filter2 = FilterBuilder.or((Filter)left, (Filter)right);
        expected2 = "( | " + (String)expectedLeft + " " + (String)expectedRight + " )";
        actual2 = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter2);
        Assertions.assertEquals((Object)actual2, (Object)expected2);
        filter2 = FilterBuilder.not((Filter)filter2);
        expectedLeft = "( ! " + (String)expectedLeft + " )";
        expectedRight = "( ! " + (String)expectedRight + " )";
        expected2 = "( & " + (String)expectedLeft + " " + (String)expectedRight + " )";
        actual2 = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter2);
        Assertions.assertEquals((Object)actual2, (Object)expected2);
        filter = FilterBuilder.contains((Attribute)attribute);
        filter = FilterBuilder.not((Filter)filter);
        filter = FilterBuilder.not((Filter)filter);
        expected = "( CONTAINS att-name att-value )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)translator, filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testDistribution() {
        Filter a = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        Filter b = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"b"}));
        Filter c = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"c", (Object[])new Object[]{"c"}));
        Filter d = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"d", (Object[])new Object[]{"d"}));
        Filter filter = FilterBuilder.and((Filter)FilterBuilder.or((Filter)a, (Filter)b), (Filter)FilterBuilder.or((Filter)c, (Filter)d));
        String expected = "( & ( | ( CONTAINS a a ) ( CONTAINS b b ) ) ( | ( CONTAINS c c ) ( CONTAINS d d ) ) )";
        String actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)new AllFiltersTranslator(), filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        List results = new NoOrTranslator().translate(filter);
        Assertions.assertEquals((int)4, (int)results.size());
        Assertions.assertEquals((Object)"( & ( CONTAINS a a ) ( CONTAINS c c ) )", results.get(0));
        Assertions.assertEquals((Object)"( & ( CONTAINS a a ) ( CONTAINS d d ) )", results.get(1));
        Assertions.assertEquals((Object)"( & ( CONTAINS b b ) ( CONTAINS c c ) )", results.get(2));
        Assertions.assertEquals((Object)"( & ( CONTAINS b b ) ( CONTAINS d d ) )", results.get(3));
    }

    @Test
    public void testSimplifyNoLeaf() {
        Filter a = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        Filter b = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"b"}));
        Filter c = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)"c", (Object[])new Object[]{"c"}));
        Filter d = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"d", (Object[])new Object[]{"d"}));
        Filter filter = FilterBuilder.and((Filter)FilterBuilder.or((Filter)a, (Filter)b), (Filter)FilterBuilder.or((Filter)c, (Filter)d));
        String expected = "( | ( CONTAINS a a ) ( CONTAINS b b ) )";
        String actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)new NoEndsWithTranslator(), filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testSimplifyNoLeafNoOr() {
        Filter a = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        Filter b = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"b"}));
        Filter c = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)"c", (Object[])new Object[]{"c"}));
        Filter d = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"d", (Object[])new Object[]{"d"}));
        Filter filter = FilterBuilder.and((Filter)FilterBuilder.or((Filter)a, (Filter)b), (Filter)FilterBuilder.or((Filter)c, (Filter)d));
        List results = new NoEndsWithNoOrTranslator().translate(filter);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals((Object)"( CONTAINS a a )", results.get(0));
        Assertions.assertEquals((Object)"( CONTAINS b b )", results.get(1));
    }

    @Test
    public void testSimplifyNoAnd() {
        Filter a = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        Filter b = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"b"}));
        Filter c = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)"c", (Object[])new Object[]{"c"}));
        Filter d = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"d", (Object[])new Object[]{"d"}));
        Filter filter = FilterBuilder.and((Filter)FilterBuilder.or((Filter)a, (Filter)b), (Filter)FilterBuilder.or((Filter)c, (Filter)d));
        String expected = "( | ( CONTAINS a a ) ( CONTAINS b b ) )";
        String actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)new NoAndTranslator(), filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testSimplifyNoAndNoLeaf() {
        Filter a = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        Filter b = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"b"}));
        Filter c = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)"c", (Object[])new Object[]{"c"}));
        Filter d = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"d", (Object[])new Object[]{"d"}));
        Filter filter = FilterBuilder.and((Filter)FilterBuilder.or((Filter)a, (Filter)b), (Filter)FilterBuilder.or((Filter)c, (Filter)d));
        String expected = "( | ( CONTAINS a a ) ( CONTAINS b b ) )";
        String actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)new NoAndNoEndsWithTranslator(), filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        a = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        b = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"b"}));
        c = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"c", (Object[])new Object[]{"c"}));
        d = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"d", (Object[])new Object[]{"d"}));
        filter = FilterBuilder.and((Filter)FilterBuilder.or((Filter)a, (Filter)b), (Filter)FilterBuilder.or((Filter)c, (Filter)d));
        expected = "( | ( CONTAINS c c ) ( CONTAINS d d ) )";
        actual = FilterTranslatorTests.translateSingle((FilterTranslator<String>)new NoAndNoEndsWithTranslator(), filter);
        Assertions.assertEquals((Object)actual, (Object)expected);
        a = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        b = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"b"}));
        c = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"c", (Object[])new Object[]{"c"}));
        d = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)"d", (Object[])new Object[]{"d"}));
        filter = FilterBuilder.and((Filter)FilterBuilder.or((Filter)a, (Filter)b), (Filter)FilterBuilder.or((Filter)c, (Filter)d));
        List results = new NoAndNoEndsWithTranslator().translate(filter);
        Assertions.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void testSimplifyNoAndNoOrNoLeaf() {
        Filter a = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        Filter b = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"b"}));
        Filter c = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)"c", (Object[])new Object[]{"c"}));
        Filter d = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"d", (Object[])new Object[]{"d"}));
        Filter filter = FilterBuilder.and((Filter)FilterBuilder.or((Filter)a, (Filter)b), (Filter)FilterBuilder.or((Filter)c, (Filter)d));
        List results = new NoAndNoOrNoEndsWithTranslator().translate(filter);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals((Object)"( CONTAINS a a )", results.get(0));
        Assertions.assertEquals((Object)"( CONTAINS b b )", results.get(1));
        a = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"a", (Object[])new Object[]{"a"}));
        b = FilterBuilder.endsWith((Attribute)AttributeBuilder.build((String)"b", (Object[])new Object[]{"b"}));
        c = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"c", (Object[])new Object[]{"c"}));
        d = FilterBuilder.contains((Attribute)AttributeBuilder.build((String)"d", (Object[])new Object[]{"d"}));
        filter = FilterBuilder.and((Filter)FilterBuilder.or((Filter)a, (Filter)b), (Filter)FilterBuilder.or((Filter)c, (Filter)d));
        results = new NoAndNoOrNoEndsWithTranslator().translate(filter);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals((Object)"( CONTAINS c c )", results.get(0));
        Assertions.assertEquals((Object)"( CONTAINS d d )", results.get(1));
    }

    private static String translateSingle(FilterTranslator<String> translator, Filter filter) {
        List translated = translator.translate(filter);
        Assertions.assertEquals((int)1, (int)translated.size());
        return (String)translated.get(0);
    }

    private static class NoAndNoOrNoEndsWithTranslator
    extends AllFiltersTranslator {
        private NoAndNoOrNoEndsWithTranslator() {
        }

        @Override
        protected String createAndExpression(String leftExpression, String rightExpression) {
            return null;
        }

        @Override
        protected String createEndsWithExpression(EndsWithFilter filter, boolean not) {
            return null;
        }

        @Override
        protected String createOrExpression(String leftExpression, String rightExpression) {
            return null;
        }
    }

    private static class NoAndNoEndsWithTranslator
    extends AllFiltersTranslator {
        private NoAndNoEndsWithTranslator() {
        }

        @Override
        protected String createAndExpression(String leftExpression, String rightExpression) {
            return null;
        }

        @Override
        protected String createEndsWithExpression(EndsWithFilter filter, boolean not) {
            return null;
        }
    }

    private static class NoAndTranslator
    extends AllFiltersTranslator {
        private NoAndTranslator() {
        }

        @Override
        protected String createAndExpression(String leftExpression, String rightExpression) {
            return null;
        }
    }

    private static class NoEndsWithNoOrTranslator
    extends AllFiltersTranslator {
        private NoEndsWithNoOrTranslator() {
        }

        @Override
        protected String createOrExpression(String leftExpression, String rightExpression) {
            return null;
        }

        @Override
        protected String createEndsWithExpression(EndsWithFilter filter, boolean not) {
            return null;
        }
    }

    private static class NoEndsWithTranslator
    extends AllFiltersTranslator {
        private NoEndsWithTranslator() {
        }

        @Override
        protected String createEndsWithExpression(EndsWithFilter filter, boolean not) {
            return null;
        }
    }

    private static class NoOrTranslator
    extends AllFiltersTranslator {
        private NoOrTranslator() {
        }

        @Override
        protected String createOrExpression(String leftExpression, String rightExpression) {
            return null;
        }
    }

    private static class AllFiltersTranslator
    extends AbstractFilterTranslator<String> {
        private AllFiltersTranslator() {
        }

        protected String createAndExpression(String leftExpression, String rightExpression) {
            return "( & " + leftExpression + " " + rightExpression + " )";
        }

        protected String createOrExpression(String leftExpression, String rightExpression) {
            return "( | " + leftExpression + " " + rightExpression + " )";
        }

        protected String createContainsExpression(ContainsFilter filter, boolean not) {
            String rv = "( CONTAINS " + filter.getName() + " " + filter.getValue() + " )";
            return this.not(rv, not);
        }

        protected String createEndsWithExpression(EndsWithFilter filter, boolean not) {
            String rv = "( ENDS-WITH " + filter.getName() + " " + filter.getValue() + " )";
            return this.not(rv, not);
        }

        protected String createEqualsExpression(EqualsFilter filter, boolean not) {
            String rv = "( = " + filter.getAttribute().getName() + " " + filter.getAttribute().getValue() + " )";
            return this.not(rv, not);
        }

        protected String createEqualsIgnoreCaseExpression(EqualsIgnoreCaseFilter filter, boolean not) {
            String rv = "( EQUALSIGNORECASE " + filter.getName() + " " + filter.getValue() + " )";
            return this.not(rv, not);
        }

        protected String createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
            String rv = "( > " + filter.getName() + " " + filter.getValue() + " )";
            return this.not(rv, not);
        }

        protected String createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
            String rv = "( >= " + filter.getName() + " " + filter.getValue() + " )";
            return this.not(rv, not);
        }

        protected String createLessThanExpression(LessThanFilter filter, boolean not) {
            String rv = "( < " + filter.getName() + " " + filter.getValue() + " )";
            return this.not(rv, not);
        }

        protected String createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
            String rv = "( <= " + filter.getName() + " " + filter.getValue() + " )";
            return this.not(rv, not);
        }

        protected String createStartsWithExpression(StartsWithFilter filter, boolean not) {
            String rv = "( STARTS-WITH " + filter.getName() + " " + filter.getValue() + " )";
            return this.not(rv, not);
        }

        protected String createContainsAllValuesExpression(ContainsAllValuesFilter filter, boolean not) {
            String rv = "( CONTAINS-ALL-VALUES " + filter.getAttribute() + " )";
            return this.not(rv, not);
        }

        private String not(String orig, boolean not) {
            if (not) {
                return "( ! " + orig + " )";
            }
            return orig;
        }
    }
}

