/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Locale;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.LocaleTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AttributeInfoTests {
    @BeforeEach
    public void before() {
        LocaleTestUtil.resetLocaleCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEqualsObservesLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr"));
            AttributeInfo attribute1 = AttributeInfoBuilder.build((String)"i");
            AttributeInfo attribute2 = AttributeInfoBuilder.build((String)"I");
            Assertions.assertFalse((boolean)attribute1.equals((Object)attribute2));
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHashCodeIndependentOnLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            AttributeInfo attribute = AttributeInfoBuilder.build((String)"i");
            int hash1 = attribute.hashCode();
            Locale.setDefault(new Locale("tr"));
            int hash2 = attribute.hashCode();
            Assertions.assertEquals((int)hash1, (int)hash2);
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }
}

