/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AttributeBuilderTests {
    @Test
    public void nullAttribute() {
        AttributeBuilder bld = new AttributeBuilder();
        bld.setName("adfaljk");
        Assertions.assertNull((Object)bld.build().getValue());
        Assertions.assertNull((Object)AttributeBuilder.build((String)"fadsfd").getValue());
    }

    @Test
    public void buildBoolean() {
        AttributeBuilder bld = new AttributeBuilder();
        bld.setName("somename");
        bld.addValue(new Object[]{true, false});
        Attribute attr1 = bld.build();
        Attribute attr2 = bld.build();
        bld.addValue(new Object[]{false});
        Attribute attr3 = bld.build();
        ArrayList<Boolean> expected = new ArrayList<Boolean>();
        expected.add(true);
        expected.add(false);
        Assertions.assertEquals((Object)attr1.getValue(), expected);
        this.testAttributes(attr1, attr2, attr3);
    }

    void testAttributes(Attribute attr1, Attribute attr2, Attribute attr3) {
        Assertions.assertEquals((Object)attr1, (Object)attr2);
        Assertions.assertEquals((Object)attr1, (Object)attr1);
        Assertions.assertFalse((attr1 == null ? 1 : 0) != 0);
        HashSet<Attribute> set = new HashSet<Attribute>();
        set.add(attr1);
        set.add(attr2);
        set.add(attr3);
        Assertions.assertTrue((set.size() == 2 ? 1 : 0) != 0);
    }

    public void uidFromBuilderInteger() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AttributeBuilder.build((String)Uid.NAME, (Object[])new Object[]{1}));
    }

    public void uidFromBuilderLong() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AttributeBuilder.build((String)Uid.NAME, (Object[])new Object[]{1L}));
    }

    public void uidFromBuilderDouble() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AttributeBuilder.build((String)Uid.NAME, (Object[])new Object[]{1.0}));
    }

    public void nameFromBuilder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Name actual = (Name)AttributeBuilder.build((String)Name.NAME, (Object[])new Object[]{"daf"});
            Assertions.assertEquals((Object)actual, (Object)new Name("daf"));
            AttributeBuilder bld = new AttributeBuilder();
            bld.setName(Name.NAME);
            bld.addValue(new Object[]{"stuff"});
            actual = (Name)bld.build();
            Assertions.assertEquals((Object)actual, (Object)new Name("stuff"));
            AttributeBuilder.build((String)Name.NAME);
        });
    }

    public void mapNullAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HashMap<Object, String> map = new HashMap<Object, String>();
            map.put(null, "NOK");
            AttributeBuilder.build((String)"map", (Object[])new Object[]{map});
        });
    }

    public void mapIntegerAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            map.put(1, "NOK");
            AttributeBuilder bld = new AttributeBuilder();
            bld.addValue(new Object[]{map});
        });
    }

    public void mapShortAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("string", "NOK");
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("map1", map1);
            map2.put("list", Arrays.asList(1, 2, 3, Short.valueOf("5")));
            HashMap<String, HashMap<String, Object>> map3 = new HashMap<String, HashMap<String, Object>>();
            map3.put("map2", map2);
            HashMap<String, HashMap<String, HashMap<String, Object>>> map4 = new HashMap<String, HashMap<String, HashMap<String, Object>>>();
            map4.put("map3", map3);
            AttributeBuilder.build((String)"map", (Object[])new Object[]{map4});
        });
    }

    @Test
    public void mapAttribute() {
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("string", "OK");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("map1", map1);
        map2.put("list", Arrays.asList(1, 2, 3));
        HashMap<String, HashMap<String, Object>> map3 = new HashMap<String, HashMap<String, Object>>();
        map3.put("map2", map2);
        HashMap<String, HashMap<String, HashMap<String, Object>>> map4 = new HashMap<String, HashMap<String, HashMap<String, Object>>>();
        map4.put("map3", map3);
        AttributeBuilder.build((String)"map", (Object[])new Object[]{map4});
    }

    @Test
    public void nullPasswordAttribute() {
        AttributeBuilder bld = new AttributeBuilder();
        bld.setName(OperationalAttributes.PASSWORD_NAME);
        Attribute attr = bld.build();
        Assertions.assertEquals((Object)OperationalAttributes.PASSWORD_NAME, (Object)attr.getName());
        Assertions.assertNull((Object)attr.getValue());
        Assertions.assertNull((Object)AttributeBuilder.build((String)OperationalAttributes.PASSWORD_NAME).getValue());
    }
}

