/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import org.identityconnectors.common.Version;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VersionTests {
    @Test
    public void testParse() {
        Assertions.assertEquals((Object)new Version(new Integer[]{1}), (Object)Version.parse((String)"1"));
        Assertions.assertEquals((Object)new Version(new Integer[]{1}), (Object)Version.parse((String)"1-alpha"));
        Assertions.assertEquals((Object)new Version(new Integer[]{1, 2}), (Object)Version.parse((String)"1.2"));
        Assertions.assertEquals((Object)new Version(new Integer[]{1, 2}), (Object)Version.parse((String)"1.2-alpha"));
        Assertions.assertEquals((Object)new Version(new Integer[]{1, 2, 3}), (Object)Version.parse((String)"1.2.3"));
        Assertions.assertEquals((Object)new Version(new Integer[]{1, 2, 3}), (Object)Version.parse((String)"1.2.3-alpha"));
        Assertions.assertEquals((Object)new Version(new Integer[]{1, 2, 3, 4}), (Object)Version.parse((String)"1.2.3.4"));
        Assertions.assertEquals((Object)new Version(new Integer[]{1, 2, 3, 4}), (Object)Version.parse((String)"1.2.3.4-alpha"));
    }

    @Test
    public void testCompare() {
        this.assertCompEq(new Version(new Integer[]{1}), Version.parse((String)"1"));
        this.assertCompEq(new Version(new Integer[]{1, 2}), Version.parse((String)"1.2"));
        this.assertCompEq(new Version(new Integer[]{1, 2, 3}), Version.parse((String)"1.2.3"));
        this.assertCompEq(new Version(new Integer[]{1, 2, 3, 4}), Version.parse((String)"1.2.3.4"));
        this.assertCompEq(new Version(new Integer[]{1}), Version.parse((String)"1.0"));
        this.assertCompEq(new Version(new Integer[]{1}), Version.parse((String)"1.0.0"));
        this.assertCompEq(new Version(new Integer[]{1}), Version.parse((String)"1.0.0.0"));
        this.assertCompEq(new Version(new Integer[]{1, 2}), Version.parse((String)"1.2.0"));
        this.assertCompEq(new Version(new Integer[]{1, 2}), Version.parse((String)"1.2.0.0"));
        this.assertCompEq(new Version(new Integer[]{1, 2, 3}), Version.parse((String)"1.2.3.0"));
        this.assertCompLt(new Version(new Integer[]{1, 2}), Version.parse((String)"1.3"));
        this.assertCompLt(new Version(new Integer[]{1, 2, 3}), Version.parse((String)"1.2.4"));
        this.assertCompLt(new Version(new Integer[]{1, 2, 3, 4}), Version.parse((String)"1.2.3.5"));
        this.assertCompLt(new Version(new Integer[]{2}), Version.parse((String)"3"));
        this.assertCompLt(new Version(new Integer[]{2}), Version.parse((String)"2.1"));
        this.assertCompLt(new Version(new Integer[]{2, 3}), Version.parse((String)"2.3.4"));
        this.assertCompLt(new Version(new Integer[]{2, 3, 4}), Version.parse((String)"2.3.4.5"));
        this.assertCompGt(new Version(new Integer[]{1, 2}), Version.parse((String)"1.1"));
        this.assertCompGt(new Version(new Integer[]{1, 2, 3}), Version.parse((String)"1.2.2"));
        this.assertCompGt(new Version(new Integer[]{1, 2, 3, 4}), Version.parse((String)"1.2.3.3"));
        this.assertCompGt(new Version(new Integer[]{2}), Version.parse((String)"1"));
        this.assertCompGt(new Version(new Integer[]{2}), Version.parse((String)"1.0"));
        this.assertCompGt(new Version(new Integer[]{2, 3}), Version.parse((String)"2.2.0"));
        this.assertCompGt(new Version(new Integer[]{2, 3, 4}), Version.parse((String)"2.3.3.0"));
    }

    @Test
    public void testQualifiedIgnored() {
        Assertions.assertEquals((Object)Version.parse((String)"1.2.3"), (Object)Version.parse((String)"1.2.3-alpha"));
    }

    @Test
    public void testComponents() {
        Version v = Version.parse((String)"1.2.3.4");
        Assertions.assertEquals((Integer)v.getMajor(), (Integer)1);
        Assertions.assertEquals((Integer)v.getMinor(), (Integer)2);
        Assertions.assertEquals((Integer)v.getMicro(), (Integer)3);
        Assertions.assertEquals((Integer)v.getRevision(), (Integer)4);
    }

    @Test
    public void testCornerCases() {
        Version v = Version.parse((String)"1.0");
        Assertions.assertEquals((Integer)v.getMajor(), (Integer)1);
        Assertions.assertEquals((Integer)v.getMinor(), (Integer)0);
        Assertions.assertNull((Object)v.getMicro());
        Assertions.assertNull((Object)v.getRevision());
        try {
            new Version(new Integer[0]);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Version.parse((String)" ");
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Version.parse((String)"foo");
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEqualsHashCode() {
        Version v1 = Version.parse((String)"1.0");
        Version v2 = Version.parse((String)"1.0.0.0");
        Assertions.assertEquals((Object)v1, (Object)v2);
        Assertions.assertEquals((int)v1.hashCode(), (int)v2.hashCode());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)Version.parse((String)"1.2.3").toString(), (Object)"Version[1.2.3]");
    }

    private void assertCompEq(Version v1, Version v2) {
        Assertions.assertTrue((v1.compareTo(v2) == 0 ? 1 : 0) != 0);
    }

    private void assertCompLt(Version v1, Version v2) {
        Assertions.assertTrue((v1.compareTo(v2) < 0 ? 1 : 0) != 0);
    }

    private void assertCompGt(Version v1, Version v2) {
        Assertions.assertTrue((v1.compareTo(v2) > 0 ? 1 : 0) != 0);
    }
}

