/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.StringPrintWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringPrintWriterTests {
    String[] DATA = new String[]{"Some random text to use!", "Some more text to use wee!", "Even more text to use woo hoo!"};

    @Test
    public void getString() {
        StringBuilder bld = new StringBuilder();
        StringPrintWriter wrt = new StringPrintWriter();
        for (String data : this.DATA) {
            bld.append(data);
            wrt.print(data);
        }
        Assertions.assertEquals((Object)bld.toString(), (Object)wrt.getString());
        wrt.clear();
        Assertions.assertEquals((Object)wrt.getString(), (Object)"");
    }

    @Test
    public void getReader() {
        StringWriter wrt = new StringWriter();
        StringPrintWriter pwrt = new StringPrintWriter();
        for (String data : this.DATA) {
            wrt.append(data);
            pwrt.append((CharSequence)data);
        }
        String actual = IOUtil.readerToString((Reader)pwrt.getReader());
        Assertions.assertEquals((Object)actual, (Object)wrt.toString());
    }

    @Test
    public void println() {
        StringWriter swrt = new StringWriter();
        PrintWriter wrt = new PrintWriter(swrt);
        StringPrintWriter pwrt = new StringPrintWriter();
        for (String data : this.DATA) {
            wrt.println(data);
            pwrt.println(data);
        }
        Assertions.assertEquals((Object)swrt.toString(), (Object)pwrt.getString());
    }

    public void printlnArray() {
        StringWriter swrt = new StringWriter();
        PrintWriter wrt = new PrintWriter(swrt);
        StringPrintWriter pwrt = new StringPrintWriter();
        for (String data : this.DATA) {
            wrt.println(data);
        }
        pwrt.println(this.DATA);
        Assertions.assertEquals((Object)swrt.toString(), (Object)pwrt.getString());
    }

    @Test
    public void printArray() {
        StringWriter swrt = new StringWriter();
        PrintWriter wrt = new PrintWriter(swrt);
        StringPrintWriter pwrt = new StringPrintWriter();
        for (String data : this.DATA) {
            wrt.print(data);
        }
        pwrt.print(this.DATA);
        Assertions.assertEquals((Object)swrt.toString(), (Object)pwrt.getString());
    }
}

