/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoUtil;
import org.identityconnectors.framework.common.objects.LocaleTestUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ObjectClassInfoTests {
    @BeforeEach
    public void before() {
        LocaleTestUtil.resetLocaleCache();
    }

    public void testNoName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ObjectClassInfo(ObjectClass.ACCOUNT_NAME, new HashSet(), false, false, false));
    }

    @Test
    public void testBuilderAddsName() {
        ObjectClassInfo o = new ObjectClassInfoBuilder().build();
        Map map = AttributeInfoUtil.toMap((Collection)o.getAttributeInfo());
        Assertions.assertTrue((boolean)map.containsKey(Name.NAME));
    }

    public void testDuplicate() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ObjectClassInfoBuilder bld = new ObjectClassInfoBuilder();
            bld.addAttributeInfo(AttributeInfoBuilder.build((String)"bob"));
            bld.addAttributeInfo(AttributeInfoBuilder.build((String)"bob"));
        });
    }

    public void testAllDuplicate() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ObjectClassInfoBuilder bld = new ObjectClassInfoBuilder();
            HashSet<AttributeInfo> set = new HashSet<AttributeInfo>();
            set.add(AttributeInfoBuilder.build((String)"bob"));
            set.add(AttributeInfoBuilder.build((String)"bob", Integer.TYPE));
            bld.addAllAttributeInfo(set);
        });
    }

    @Test
    public void testIs() {
        ObjectClassInfoBuilder bld = new ObjectClassInfoBuilder();
        bld.addAttributeInfo(AttributeInfoBuilder.build((String)"bob"));
        bld.setType("group");
        ObjectClassInfo oci = bld.build();
        Assertions.assertTrue((boolean)oci.is("group"));
        Assertions.assertTrue((boolean)oci.is("Group"));
        Assertions.assertFalse((boolean)oci.is("admin"));
    }

    @Test
    public void testEquals() {
        ObjectClassInfo oci_lower = ObjectClassInfoTests.build("group");
        ObjectClassInfo oci_upper = ObjectClassInfoTests.build("Group");
        Assertions.assertEquals((Object)oci_lower, (Object)oci_upper);
    }

    @Test
    public void testHashCode() {
        ObjectClassInfo oci_lower = ObjectClassInfoTests.build("group");
        ObjectClassInfo oci_upper = ObjectClassInfoTests.build("Group");
        Assertions.assertEquals((int)oci_lower.hashCode(), (int)oci_upper.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEqualsObservesLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr"));
            ObjectClassInfo oci1 = ObjectClassInfoTests.build("i");
            ObjectClassInfo oci2 = ObjectClassInfoTests.build("I");
            Assertions.assertFalse((boolean)oci1.equals((Object)oci2));
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHashCodeIndependentOnLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            ObjectClassInfo attribute = ObjectClassInfoTests.build("i");
            int hash1 = attribute.hashCode();
            Locale.setDefault(new Locale("tr"));
            int hash2 = attribute.hashCode();
            Assertions.assertEquals((int)hash1, (int)hash2);
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }

    private static ObjectClassInfo build(String name) {
        ObjectClassInfoBuilder bld = new ObjectClassInfoBuilder();
        bld.addAttributeInfo(AttributeInfoBuilder.build((String)"bob"));
        bld.setType(name);
        return bld.build();
    }
}

