/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Properties;
import org.identityconnectors.common.Version;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FrameworkUtilTests {
    @Test
    public void testFrameworkVersion() throws Exception {
        VersionClassLoader loader = new VersionClassLoader(this.getClass().getClassLoader(), "1.2.3-alpha");
        Assertions.assertEquals((Object)FrameworkUtil.getFrameworkVersion((ClassLoader)loader), (Object)Version.parse((String)"1.2.3"));
    }

    @Test
    public void testFrameworkVersionCannotBeBlank() throws Exception {
        try {
            FrameworkUtil.getFrameworkVersion((ClassLoader)new VersionClassLoader(this.getClass().getClassLoader(), " "));
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static final class VersionClassLoader
    extends ClassLoader {
        private final String version;

        public VersionClassLoader(ClassLoader parent, String version) {
            super(parent);
            this.version = version;
        }

        @Override
        public URL getResource(String name) {
            if (!"connectors-framework.properties".equals(name)) {
                return this.getParent().getResource(name);
            }
            Properties props = new Properties();
            props.put("framework.version", this.version);
            final ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                props.store(output, null);
                return new URL("fakejar", null, 0, "connectors-framework.properties", new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return new ByteArrayInputStream(output.toByteArray());
                            }
                        };
                    }
                });
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

