/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import org.identityconnectors.common.Version;
import org.identityconnectors.common.VersionRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VersionRangeTest {
    @Test
    public void testIsInRange() throws Exception {
        Version reference0 = new Version(new Integer[]{1, 1, 0, 0});
        Version reference1 = new Version(new Integer[]{1, 1, 0, 1});
        Version reference2 = new Version(new Integer[]{1, 1, 0, 2});
        Version reference3 = new Version(new Integer[]{1, 1, 0, 3});
        Version reference4 = new Version(new Integer[]{1, 1, 0, 4});
        VersionRange range = VersionRange.parse((String)"[1.1.0.1,1.1.0.3)");
        Assertions.assertFalse((boolean)range.isInRange(reference0));
        Assertions.assertTrue((boolean)range.isInRange(reference1));
        Assertions.assertTrue((boolean)range.isInRange(reference2));
        Assertions.assertFalse((boolean)range.isInRange(reference3));
        Assertions.assertFalse((boolean)range.isInRange(reference4));
    }

    @Test
    public void testIsExact() throws Exception {
        Assertions.assertTrue((boolean)VersionRange.parse((String)"1.1.0.0").isExact());
        Assertions.assertTrue((boolean)VersionRange.parse((String)"  [  1 , 1 ]  ").isExact());
        Assertions.assertTrue((boolean)VersionRange.parse((String)"[  1.1 , 1.1 ]").isExact());
        Assertions.assertTrue((boolean)VersionRange.parse((String)"  [1.1.1 , 1.1.1]  ").isExact());
        Assertions.assertTrue((boolean)VersionRange.parse((String)"[1.1.0.0,1.1.0.0]").isExact());
        Assertions.assertTrue((boolean)VersionRange.parse((String)"(1.1.0.0,1.1.0.2)").isExact());
    }

    @Test
    public void testIsEmpty() throws Exception {
        Assertions.assertTrue((boolean)VersionRange.parse((String)"(1.1.0.0,1.1.0.0)").isEmpty());
        Assertions.assertTrue((boolean)VersionRange.parse((String)"(1.2.0.0,1.1.0.0]").isEmpty());
    }

    @Test
    public void testValidSyntax() throws Exception {
        try {
            VersionRange.parse((String)"(1.1.0.0)");
            Assertions.fail((String)"Invalid syntax not failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            VersionRange.parse((String)"1.1.0.0,1.1)]");
            Assertions.fail((String)"Invalid syntax not failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            VersionRange.parse((String)"(1.1.0.0-1.1)");
            Assertions.fail((String)"Invalid syntax not failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            VersionRange.parse((String)"1.1.0.0,1.1");
            Assertions.fail((String)"Invalid syntax not failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            VersionRange.parse((String)"( , 1.1)");
            Assertions.fail((String)"Invalid syntax not failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIsEqual() throws Exception {
        VersionRange range1 = VersionRange.parse((String)"[1.1.0.1,1.1.0.3)");
        VersionRange range2 = VersionRange.parse((String)range1.toString());
        Assertions.assertTrue((boolean)range1.equals((Object)range2));
    }
}

