/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Collectors;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.StringPrintWriter;
import org.identityconnectors.common.StringUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilTests {
    private static final String TEMPLATE = "StringUtilTests_template.js";
    private static final String PAUSE_TEXT = "pause.text";
    private static final String RESUME_TEXT = "resume.text";
    private static final String REFRESH_TIME = "refresh.time";
    private static final String GRAPH_IDS = "graphs";
    final char TEXTQ = (char)34;
    final char FEILDD = (char)44;
    private static final String[] PROP_TEST = new String[]{"# Some comment", "prop1=SomeProp", "prop2=OtherProp"};

    @Test
    public void testIndexOfDigit() {
        int test = 0;
        String TEST0 = null;
        String TEST1 = "fsadlkjffj";
        String TEST2 = "abac2dafj";
        String TEST3 = "fa323jf4af";
        test = StringUtil.indexOfDigit(TEST0);
        Assertions.assertEquals((int)test, (int)-1);
        test = StringUtil.indexOfDigit((String)"fsadlkjffj");
        Assertions.assertEquals((int)test, (int)-1);
        test = StringUtil.indexOfDigit((String)"abac2dafj");
        Assertions.assertEquals((int)test, (int)4);
        test = StringUtil.indexOfDigit((String)"fa323jf4af");
        Assertions.assertEquals((int)test, (int)2);
    }

    @Test
    public void testIndexOfNonDigit() {
        int test = 0;
        String TEST0 = null;
        String TEST1 = "2131398750976";
        String TEST2 = "21312a9320484";
        String TEST3 = "32323aa323435";
        test = StringUtil.indexOfNonDigit(TEST0);
        Assertions.assertEquals((int)test, (int)-1);
        test = StringUtil.indexOfNonDigit((String)"2131398750976");
        Assertions.assertEquals((int)test, (int)-1);
        test = StringUtil.indexOfNonDigit((String)"21312a9320484");
        Assertions.assertEquals((int)test, (int)5);
        test = StringUtil.indexOfNonDigit((String)"32323aa323435");
        Assertions.assertEquals((int)test, (int)5);
    }

    @Test
    public void testSubDigitString() {
    }

    @Test
    public void testStripXmlAttribute() {
        String[][] DATA = new String[][]{{null, null, null}, {"attr='fads'", "attr", ""}, {"at1='fasd' at1=''", "at1", ""}};
        for (int i = 0; i < DATA.length; ++i) {
            String tst = StringUtil.stripXmlAttribute((String)DATA[i][0], (String)DATA[i][1]);
            Assertions.assertEquals((Object)tst, (Object)DATA[i][2]);
        }
    }

    @Test
    public void testStripNewlines() {
        String[][] TESTS;
        for (String[] data : TESTS = new String[][]{{null, null}, {"afdslf\n", "afdslf"}, {"afds\nfadkfj", "afdsfadkfj"}, {"afds \nfadkfj", "afds fadkfj"}, {"afds\n fadkfj", "afds fadkfj"}}) {
            String tmp = StringUtil.stripNewlines((String)data[0]);
            Assertions.assertEquals((Object)tmp, (Object)data[1]);
        }
    }

    @Test
    public void testStripXmlComments() {
        String[][] DATA = new String[][]{{null, null}, {"<!--test1-->", ""}, {"test data", "test data"}, {"<!--test data", "<!--test data"}, {"test data-->", "test data-->"}, {"test data <!-- fasdkfj -->", "test data "}, {"<!-- fasdkfj --> test data", " test data"}, {"<!-- fasdkfj --> test data<!-- fadsom-->", " test data"}};
        for (int i = 0; i < DATA.length; ++i) {
            String tst = StringUtil.stripXmlComments((String)DATA[i][0]);
            Assertions.assertEquals((Object)tst, (Object)DATA[i][1]);
        }
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)StringUtil.isEmpty(null));
        Assertions.assertTrue((boolean)StringUtil.isEmpty((String)""));
        Assertions.assertFalse((boolean)StringUtil.isEmpty((String)" "));
        Assertions.assertFalse((boolean)StringUtil.isEmpty((String)"bob"));
        Assertions.assertFalse((boolean)StringUtil.isEmpty((String)"  bob  "));
    }

    @Test
    public void testIsBlank() {
        Assertions.assertTrue((boolean)StringUtil.isBlank(null));
        Assertions.assertTrue((boolean)StringUtil.isBlank((String)""));
        Assertions.assertTrue((boolean)StringUtil.isBlank((String)" "));
        Assertions.assertFalse((boolean)StringUtil.isBlank((String)"bob"));
        Assertions.assertFalse((boolean)StringUtil.isBlank((String)"  bob  "));
    }

    @Test
    public void testIsNotEmpty() {
        Assertions.assertFalse((boolean)StringUtil.isNotEmpty(null));
        Assertions.assertFalse((boolean)StringUtil.isNotEmpty((String)""));
        Assertions.assertTrue((boolean)StringUtil.isNotEmpty((String)" "));
        Assertions.assertTrue((boolean)StringUtil.isNotEmpty((String)"bob"));
        Assertions.assertTrue((boolean)StringUtil.isNotEmpty((String)"  bob  "));
    }

    @Test
    public void testIsNotBlank() {
        Assertions.assertFalse((boolean)StringUtil.isNotBlank(null));
        Assertions.assertFalse((boolean)StringUtil.isNotBlank((String)""));
        Assertions.assertFalse((boolean)StringUtil.isNotBlank((String)" "));
        Assertions.assertTrue((boolean)StringUtil.isNotBlank((String)"bob"));
        Assertions.assertTrue((boolean)StringUtil.isNotBlank((String)"  bob  "));
    }

    @Test
    public void testReplaceVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(PAUSE_TEXT, "PAUSE");
        vars.put(REFRESH_TIME, "5");
        vars.put(RESUME_TEXT, "RESUME");
        vars.put(GRAPH_IDS, "1,2,4345");
        String tmpl = IOUtil.getResourceAsString(this.getClass(), (String)TEMPLATE);
        for (Map.Entry entry : vars.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            tmpl = StringUtil.replaceVariable((String)tmpl, (String)key, (String)value);
            Assertions.assertTrue((boolean)tmpl.contains(value));
        }
    }

    @Test
    public void testWhtiespace() {
        Assertions.assertTrue((boolean)StringUtil.isWhitespace((char)' '));
        Assertions.assertTrue((boolean)StringUtil.isWhitespace((char)'\t'));
        Assertions.assertFalse((boolean)StringUtil.isWhitespace((char)'\n'));
        Assertions.assertFalse((boolean)StringUtil.isWhitespace((char)'\r'));
        for (char i = 'a'; i < 'Z'; i = (char)(i + '\u0001')) {
            Assertions.assertFalse((boolean)StringUtil.isWhitespace((char)i));
        }
    }

    @Test
    public void testParseLine() {
        List values = CollectionUtil.newReadOnlyList((Object[])new Object[]{"bob", "george", 4, 23, 230948});
        StringUtilTests.parseLineTest('\"', ',', values);
    }

    @Test
    public void testRandomParseLine() {
        Random r = new Random(17L);
        char[] replace = new char[]{'\"', ','};
        for (int i = 0; i < 100; ++i) {
            List<Object> values = StringUtilTests.randomList(r, 10, replace, 'a');
            StringUtilTests.parseLineTest('\"', ',', values);
        }
    }

    static void parseLineTest(char textQ, char fieldD, List<Object> values) {
        String csv = StringUtilTests.createCSVLine(textQ, fieldD, values);
        List parsedValues = StringUtil.parseLine((String)csv, (char)fieldD, (char)textQ);
        Assertions.assertEquals((Object)parsedValues, StringUtilTests.toStringList(values));
    }

    static String createCSVLine(char textQ, char fieldD, List<Object> values) {
        StringBuilder bld = new StringBuilder();
        boolean first = true;
        for (Object o : values) {
            if (first) {
                first = false;
            } else {
                bld.append(fieldD);
            }
            if (o instanceof String) {
                bld.append(textQ);
            }
            bld.append(o);
            if (!(o instanceof String)) continue;
            bld.append(textQ);
        }
        return bld.toString();
    }

    static List<String> toStringList(List<Object> list) {
        return list.stream().map(Object::toString).collect(Collectors.toList());
    }

    static List<Object> randomList(Random r, int size, char[] invalid, char valid) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            Object add;
            if (r.nextBoolean()) {
                add = r.nextInt();
            } else if (r.nextBoolean()) {
                add = r.nextDouble();
            } else {
                String str = StringUtil.randomString((Random)r, (int)r.nextInt(30));
                for (char c : invalid) {
                    str = str.replace(c, valid);
                }
                add = str;
            }
            ret.add(add);
        }
        return ret;
    }

    @Test
    public void testRandomString() {
        String s = StringUtil.randomString();
        Assertions.assertTrue((s.length() < 257 ? 1 : 0) != 0);
    }

    @Test
    public void testEndsWith() {
        Assertions.assertTrue((boolean)StringUtil.endsWith((String)"afdsf", (char)'f'));
        Assertions.assertFalse((boolean)StringUtil.endsWith(null, (char)'f'));
        Assertions.assertFalse((boolean)StringUtil.endsWith((String)"fadsfkj", (char)'f'));
    }

    @Test
    public void testToProperties() {
        StringPrintWriter wrt = new StringPrintWriter();
        wrt.println(PROP_TEST);
        wrt.flush();
        String inp = wrt.getString();
        Properties prop = StringUtil.toProperties((String)inp);
        Assertions.assertEquals((Object)prop.get("prop1"), (Object)"SomeProp");
        Assertions.assertEquals((Object)prop.get("prop2"), (Object)"OtherProp");
    }
}

