/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CollectionUtilTests {
    @Test
    public void testNullAsEmptyList() {
        List l = CollectionUtil.nullAsEmpty((List)null);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((int)l.size(), (int)0);
        l.add(" adf");
        List t = CollectionUtil.nullAsEmpty((List)l);
        Assertions.assertEquals((Object)l, (Object)t);
    }

    @Test
    public void testNullAsEmptyMap() {
        Map m = CollectionUtil.nullAsEmpty((Map)null);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((int)m.size(), (int)0);
        m.put(" adf", "fdf");
        Map t = CollectionUtil.nullAsEmpty((Map)m);
        Assertions.assertEquals((Object)m, (Object)t);
    }

    @Test
    public void testNullAsEmptySet() {
        Set l = CollectionUtil.nullAsEmpty((Set)null);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((int)l.size(), (int)0);
        l.add(" adf");
        Set t = CollectionUtil.nullAsEmpty((Set)l);
        Assertions.assertEquals((Object)l, (Object)t);
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)CollectionUtil.isEmpty((Collection)null));
        ArrayList<String> c = new ArrayList<String>();
        Assertions.assertTrue((boolean)CollectionUtil.isEmpty(c));
        c.add("dfa");
        Assertions.assertFalse((boolean)CollectionUtil.isEmpty(c));
    }

    @Test
    public void testUnique() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("test");
        list.add("test");
        Collection u = CollectionUtil.unique(list);
        Assertions.assertEquals((int)u.size(), (int)1);
    }

    @Test
    public void testAsList() {
        HashSet<Integer> c = new HashSet<Integer>();
        c.add(1);
        c.add(2);
        List list = CollectionUtil.newList(c);
        Assertions.assertTrue((boolean)list.remove((Object)1));
        Assertions.assertTrue((boolean)list.remove((Object)2));
        list.add(2);
        c = null;
        CollectionUtil.newList(c);
        list = CollectionUtil.newList((Object[])new Integer[]{1, 2});
        Assertions.assertTrue((boolean)list.remove((Object)1));
        Assertions.assertTrue((boolean)list.remove((Object)2));
    }

    @Test
    public void testAsSet() {
        ArrayList<Integer> c = new ArrayList<Integer>();
        c.add(1);
        c.add(2);
        Set set = CollectionUtil.newSet(c);
        Assertions.assertTrue((boolean)set.contains(1));
        Assertions.assertTrue((boolean)set.contains(2));
        set.add(2);
        c = null;
        CollectionUtil.newSet(c);
        set = CollectionUtil.newSet((Object[])new Integer[]{1, 2});
        Assertions.assertTrue((boolean)set.contains(1));
        Assertions.assertTrue((boolean)set.contains(2));
    }

    public void testList() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            HashSet<Integer> c = new HashSet<Integer>();
            c.add(1);
            c.add(2);
            List list = CollectionUtil.newReadOnlyList(c);
            Assertions.assertTrue((boolean)list.remove((Object)1));
            Assertions.assertTrue((boolean)list.remove((Object)2));
            c = null;
            CollectionUtil.newReadOnlyList(c);
            list = CollectionUtil.newReadOnlyList((Object[])new Integer[]{1, 2});
            Assertions.assertTrue((boolean)list.contains(1));
            Assertions.assertTrue((boolean)list.contains(2));
            list.add(2);
        });
    }

    public void testSet() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            ArrayList<Integer> c = new ArrayList<Integer>();
            c.add(1);
            c.add(2);
            Set set = CollectionUtil.newReadOnlySet(c);
            Assertions.assertTrue((boolean)set.contains(1));
            Assertions.assertTrue((boolean)set.contains(2));
            c = null;
            CollectionUtil.newReadOnlySet(c);
            set = CollectionUtil.newReadOnlySet((Object[])new Integer[]{1, 2});
            Assertions.assertTrue((boolean)set.contains(1));
            Assertions.assertTrue((boolean)set.contains(2));
            set.add(2);
        });
    }

    @Test
    public void testReadonlyList() {
        Object[] data = new String[]{"a", "b", "c"};
        List expected = CollectionUtil.newReadOnlyList((Object[])new String[]{"a", "b", "c"});
        List actual = CollectionUtil.newReadOnlyList((Object[])data);
        Assertions.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testReadonlySet() {
        Object[] data = new String[]{"a", "b", "c"};
        Set expected = CollectionUtil.newReadOnlySet((Object[])new String[]{"a", "b", "c"});
        Set actual = CollectionUtil.newReadOnlySet((Object[])data);
        Assertions.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testEquals() {
        Assertions.assertTrue((boolean)CollectionUtil.equals(null, null));
        Assertions.assertFalse((boolean)CollectionUtil.equals(null, (Object)"str"));
        Assertions.assertTrue((boolean)CollectionUtil.equals((Object)"str", (Object)"str"));
        byte[] arr1 = new byte[]{1, 2, 3};
        byte[] arr2 = new byte[]{1, 2, 3};
        byte[] arr3 = new byte[]{1, 2, 4};
        byte[] arr4 = new byte[]{1, 2};
        int[] arr5 = new int[]{1, 2, 3};
        Assertions.assertTrue((boolean)CollectionUtil.equals((Object)arr1, (Object)arr2));
        Assertions.assertFalse((boolean)CollectionUtil.equals((Object)arr2, (Object)arr3));
        Assertions.assertFalse((boolean)CollectionUtil.equals((Object)arr2, (Object)arr4));
        Assertions.assertFalse((boolean)CollectionUtil.equals((Object)arr2, (Object)arr5));
        ArrayList<byte[]> list1 = new ArrayList<byte[]>();
        ArrayList<byte[]> list2 = new ArrayList<byte[]>();
        list1.add(arr1);
        list2.add(arr2);
        Assertions.assertTrue((boolean)CollectionUtil.equals(list1, list2));
        list2.add(arr2);
        Assertions.assertFalse((boolean)CollectionUtil.equals(list1, list2));
        list1.add(arr1);
        Assertions.assertTrue((boolean)CollectionUtil.equals(list1, list2));
        list1.add(arr1);
        list2.add(arr3);
        Assertions.assertFalse((boolean)CollectionUtil.equals(list1, list2));
        HashMap<String, byte[]> map1 = new HashMap<String, byte[]>();
        HashMap<String, byte[]> map2 = new HashMap<String, byte[]>();
        map1.put("key1", arr1);
        map2.put("key1", arr2);
        Assertions.assertTrue((boolean)CollectionUtil.equals(map1, map2));
        map2.put("key2", arr2);
        Assertions.assertFalse((boolean)CollectionUtil.equals(map1, map2));
        map1.put("key2", arr1);
        Assertions.assertTrue((boolean)CollectionUtil.equals(map1, map2));
        map1.put("key2", arr3);
        Assertions.assertFalse((boolean)CollectionUtil.equals(map1, map2));
        HashSet<String> set1 = new HashSet<String>();
        HashSet<String> set2 = new HashSet<String>();
        set1.add("val");
        set2.add("val");
        Assertions.assertTrue((boolean)CollectionUtil.equals(set1, set2));
        set2.add("val2");
        Assertions.assertFalse((boolean)CollectionUtil.equals(set1, set2));
        set1.add("val2");
        Assertions.assertTrue((boolean)CollectionUtil.equals(set1, set2));
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)CollectionUtil.hashCode(null), (int)0);
        Assertions.assertEquals((int)CollectionUtil.hashCode((Object)"str"), (int)"str".hashCode());
        byte[] arr1 = new byte[]{1, 2, 3};
        byte[] arr2 = new byte[]{1, 2, 3};
        byte[] arr3 = new byte[]{1, 2, 4};
        byte[] arr4 = new byte[]{1, 2};
        int[] arr5 = new int[]{1, 2, 3};
        Assertions.assertEquals((int)CollectionUtil.hashCode((Object)arr1), (int)CollectionUtil.hashCode((Object)arr2));
        Assertions.assertFalse((CollectionUtil.hashCode((Object)arr2) == CollectionUtil.hashCode((Object)arr3) ? 1 : 0) != 0);
        Assertions.assertFalse((CollectionUtil.hashCode((Object)arr2) == CollectionUtil.hashCode((Object)arr4) ? 1 : 0) != 0);
        Assertions.assertTrue((CollectionUtil.hashCode((Object)arr2) == CollectionUtil.hashCode((Object)arr5) ? 1 : 0) != 0);
        ArrayList<byte[]> list1 = new ArrayList<byte[]>();
        ArrayList<byte[]> list2 = new ArrayList<byte[]>();
        list1.add(arr1);
        list2.add(arr2);
        Assertions.assertTrue((CollectionUtil.hashCode(list1) == CollectionUtil.hashCode(list2) ? 1 : 0) != 0);
        list2.add(arr2);
        Assertions.assertFalse((CollectionUtil.hashCode(list1) == CollectionUtil.hashCode(list2) ? 1 : 0) != 0);
        list1.add(arr1);
        Assertions.assertTrue((CollectionUtil.hashCode(list1) == CollectionUtil.hashCode(list2) ? 1 : 0) != 0);
        list1.add(arr1);
        list2.add(arr3);
        Assertions.assertFalse((CollectionUtil.hashCode(list1) == CollectionUtil.hashCode(list2) ? 1 : 0) != 0);
        HashMap<String, byte[]> map1 = new HashMap<String, byte[]>();
        HashMap<String, byte[]> map2 = new HashMap<String, byte[]>();
        map1.put("key1", arr1);
        map2.put("key1", arr2);
        Assertions.assertTrue((CollectionUtil.hashCode(map1) == CollectionUtil.hashCode(map2) ? 1 : 0) != 0);
        map2.put("key2", arr2);
        Assertions.assertFalse((CollectionUtil.hashCode(map1) == CollectionUtil.hashCode(map2) ? 1 : 0) != 0);
        map1.put("key2", arr1);
        Assertions.assertTrue((CollectionUtil.hashCode(map1) == CollectionUtil.hashCode(map2) ? 1 : 0) != 0);
        map1.put("key2", arr3);
        Assertions.assertFalse((CollectionUtil.hashCode(map1) == CollectionUtil.hashCode(map2) ? 1 : 0) != 0);
        HashSet<String> set1 = new HashSet<String>();
        HashSet<String> set2 = new HashSet<String>();
        set1.add("val");
        set2.add("val");
        Assertions.assertTrue((CollectionUtil.hashCode(set1) == CollectionUtil.hashCode(set2) ? 1 : 0) != 0);
        set2.add("val2");
        Assertions.assertFalse((CollectionUtil.hashCode(set1) == CollectionUtil.hashCode(set2) ? 1 : 0) != 0);
        set1.add("val2");
        Assertions.assertTrue((CollectionUtil.hashCode(set1) == CollectionUtil.hashCode(set2) ? 1 : 0) != 0);
    }
}

