/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.ArrayList;
import java.util.Locale;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaBuilder;
import org.identityconnectors.framework.common.objects.LocaleTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AttributeDeltaTests {
    @BeforeEach
    public void before() {
        LocaleTestUtil.resetLocaleCache();
    }

    @Test
    public void testName() {
        AttributeDelta actual = AttributeDeltaBuilder.build((String)"Jack");
        Assertions.assertEquals((Object)actual, (Object)AttributeDeltaBuilder.build((String)"jacK"));
        Assertions.assertTrue((boolean)actual.is("JacK"));
    }

    @Test
    public void testArrays() {
        ArrayList<byte[]> values1 = new ArrayList<byte[]>();
        values1.add(new byte[]{0, 1});
        ArrayList<byte[]> values2 = new ArrayList<byte[]>();
        values2.add(new byte[]{0, 1});
        AttributeDelta attribute1 = AttributeDeltaBuilder.build((String)"test", values1);
        AttributeDelta attribute2 = AttributeDeltaBuilder.build((String)"test", values2);
        Assertions.assertEquals((Object)attribute1, (Object)attribute2, (String)"test failed with valuesToReplace");
        attribute1 = AttributeDeltaBuilder.build((String)"test", values1, null);
        attribute2 = AttributeDeltaBuilder.build((String)"test", values2, null);
        Assertions.assertEquals((Object)attribute1, (Object)attribute2, (String)"test failed with valuesToAdd");
        attribute1 = AttributeDeltaBuilder.build((String)"test", null, values1);
        attribute2 = AttributeDeltaBuilder.build((String)"test", null, values2);
        Assertions.assertEquals((Object)attribute1, (Object)attribute2, (String)"test failed with valueToRemove");
        attribute1 = AttributeDeltaBuilder.build((String)"test", values1, values1);
        attribute2 = AttributeDeltaBuilder.build((String)"test", values2, values2);
        Assertions.assertEquals((Object)attribute1, (Object)attribute2, (String)"test failed with valueToAdd and valueToRemove");
    }

    @Test
    public void testNormal() {
        Assertions.assertEquals((Object)AttributeDeltaBuilder.build((String)"test", (Object[])new Object[]{1, 2, 4}), (Object)AttributeDeltaBuilder.build((String)"test", (Object[])new Object[]{1, 2, 4}));
        Assertions.assertFalse((boolean)AttributeDeltaBuilder.build((String)"test", (Object[])new Object[]{1, 2, 4}).equals((Object)AttributeDeltaBuilder.build((String)"test", (Object[])new Object[]{2, 4})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEqualsObservesLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr"));
            AttributeDelta attribute1 = AttributeDeltaBuilder.build((String)"i");
            AttributeDelta attribute2 = AttributeDeltaBuilder.build((String)"I");
            Assertions.assertFalse((boolean)attribute1.equals((Object)attribute2));
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHashCodeIndependentOnLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            AttributeDelta attribute = AttributeDeltaBuilder.build((String)"i");
            int hash1 = attribute.hashCode();
            Locale.setDefault(new Locale("tr"));
            int hash2 = attribute.hashCode();
            Assertions.assertEquals((int)hash1, (int)hash2);
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }
}

