/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security;

import org.identityconnectors.common.security.Encryptor;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.common.security.SimpleEncryptor;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GuardedStringTests {
    @BeforeEach
    public void setUp() {
        GuardedString.setEncryptor((Encryptor)new SimpleEncryptor());
    }

    @AfterEach
    public void tearDown() {
        GuardedString.setEncryptor(null);
    }

    @Test
    public void testBasics() {
        GuardedString str = new GuardedString("foo".toCharArray());
        Assertions.assertEquals((Object)this.decryptToString(str), (Object)"foo");
        str.appendChar('2');
        Assertions.assertEquals((Object)this.decryptToString(str), (Object)"foo2");
        Assertions.assertFalse((boolean)str.verifyBase64SHA1Hash(SecurityUtil.computeBase64SHA1Hash((char[])"foo".toCharArray())));
        Assertions.assertTrue((boolean)str.verifyBase64SHA1Hash(SecurityUtil.computeBase64SHA1Hash((char[])"foo2".toCharArray())));
    }

    @Test
    public void testEquals() {
        GuardedString str1 = new GuardedString();
        GuardedString str2 = new GuardedString();
        Assertions.assertEquals((Object)str1, (Object)str2);
        str2.appendChar('2');
        Assertions.assertFalse((boolean)str1.equals((Object)str2));
        str1.appendChar('2');
        Assertions.assertEquals((Object)str1, (Object)str2);
    }

    @Test
    public void testReadOnly() {
        GuardedString str = new GuardedString("foo".toCharArray());
        Assertions.assertFalse((boolean)str.isReadOnly());
        str.makeReadOnly();
        Assertions.assertTrue((boolean)str.isReadOnly());
        Assertions.assertEquals((Object)this.decryptToString(str), (Object)"foo");
        try {
            str.appendChar('2');
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        str = str.copy();
        Assertions.assertEquals((Object)this.decryptToString(str), (Object)"foo");
        str.appendChar('2');
        Assertions.assertEquals((Object)this.decryptToString(str), (Object)"foo2");
    }

    @Test
    public void testDispose() {
        GuardedString str = new GuardedString("foo".toCharArray());
        str.dispose();
        try {
            this.decryptToString(str);
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.isReadOnly();
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.appendChar('c');
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.copy();
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.verifyBase64SHA1Hash("foo");
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testUnicode() {
        for (int i = 0; i < 65535; ++i) {
            int expected = i;
            char c = (char)i;
            GuardedString gs = new GuardedString(new char[]{c});
            gs.access(clearChars -> {
                char v = clearChars[0];
                Assertions.assertEquals((int)v, (int)expected);
            });
        }
    }

    private String decryptToString(GuardedString string) {
        StringBuilder buf = new StringBuilder();
        string.access(chars -> buf.append(chars));
        return buf.toString();
    }

    @Test
    public void passwordAttribute() {
        AttributeBuilder bld = new AttributeBuilder();
        bld.setName(OperationalAttributes.PASSWORD_NAME);
        bld.addValue(new Object[]{new GuardedString("foobar".toCharArray())});
        Attribute attr = bld.build();
        Assertions.assertEquals((Object)OperationalAttributes.PASSWORD_NAME, (Object)attr.getName());
        Assertions.assertEquals((int)1, (int)attr.getValue().size());
        Assertions.assertTrue((boolean)(attr.getValue().get(0) instanceof GuardedString));
        Assertions.assertEquals((Object)"foobar", (Object)this.decryptToString((GuardedString)attr.getValue().get(0)));
    }
}

