/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.script;

import org.identityconnectors.common.script.Script;
import org.identityconnectors.common.script.ScriptBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ScriptTests {
    @Test
    public void testBasic() {
        Script s1 = new Script("Groovy", "print 'foo'");
        Assertions.assertEquals((Object)s1.getScriptLanguage(), (Object)"Groovy");
        Assertions.assertEquals((Object)s1.getScriptText(), (Object)"print 'foo'");
        Script s2 = new ScriptBuilder().setScriptLanguage("Groovy").setScriptText("print 'foo'").build();
        Assertions.assertEquals((Object)s1, (Object)s2);
        Assertions.assertEquals((int)s1.hashCode(), (int)s2.hashCode());
    }

    @Test
    public void testLanguageNotBlank() {
        try {
            new ScriptBuilder().setScriptText("print 'foo'").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ScriptBuilder().setScriptText("print 'foo'").setScriptLanguage("").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ScriptBuilder().setScriptText("print 'foo'").setScriptLanguage(" ").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTextNotNull() {
        try {
            new ScriptBuilder().setScriptLanguage("Groovy").build();
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        new ScriptBuilder().setScriptLanguage("Groovy").setScriptText("").build();
    }
}

