/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.identityconnectors.common.StringPrintWriter;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.logging.StdOutLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StdOutLoggerTests {
    @Test
    public void checkIsLogger() {
        StdOutLogger logSpi = new StdOutLogger();
        for (Log.Level level : Log.Level.values()) {
            Assertions.assertTrue((boolean)logSpi.isLoggable(String.class, level));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkLogFormat() throws Exception {
        String MSG_EXP = "Expected message from logger attempt";
        PrintStream tmp = System.out;
        Exception EXCEPTION_EXP = new Exception();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pstrm = new PrintStream((OutputStream)bout, true, "UTF-8");
        try {
            System.setOut(pstrm);
            StdOutLogger logSpi = new StdOutLogger();
            logSpi.log(String.class, "checkLogFormtat", Log.Level.OK, MSG_EXP, (Throwable)EXCEPTION_EXP);
            pstrm.flush();
        }
        finally {
            System.setOut(tmp);
        }
        String logRecord = new String(bout.toByteArray(), StandardCharsets.UTF_8);
        BufferedReader rdr = new BufferedReader(new StringReader(logRecord));
        String[] records = rdr.readLine().split("\t");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String record : records) {
            String[] frag = record.split(":");
            map.put(frag[0].trim(), frag[1].trim());
        }
        Assertions.assertEquals(map.get("Message"), (Object)MSG_EXP);
        Assertions.assertEquals(map.get("Class"), (Object)String.class.getName());
        Assertions.assertEquals(map.get("Level"), (Object)Log.Level.OK.toString());
        Assertions.assertEquals(map.get("Thread Id"), (Object)Long.toString(Thread.currentThread().getId()));
        StringPrintWriter actual = new StringPrintWriter();
        String line = rdr.readLine();
        while (line != null) {
            actual.println(line);
            line = rdr.readLine();
        }
        StringPrintWriter expected = new StringPrintWriter();
        EXCEPTION_EXP.printStackTrace((PrintWriter)expected);
        Assertions.assertEquals((Object)actual.getString(), (Object)expected.getString());
    }
}

