/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashSet;
import java.util.Locale;
import org.identityconnectors.framework.common.objects.LocaleTestUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ObjectClassTests {
    @BeforeEach
    public void before() {
        LocaleTestUtil.resetLocaleCache();
    }

    @Test
    public void testIs() {
        ObjectClass actual = new ObjectClass("group");
        Assertions.assertTrue((boolean)actual.is("group"));
        Assertions.assertTrue((boolean)actual.is("Group"));
        Assertions.assertFalse((boolean)actual.is("admin"));
    }

    @Test
    public void testEquals() {
        ObjectClass actual = new ObjectClass(ObjectClass.ACCOUNT_NAME);
        Assertions.assertEquals((Object)actual, (Object)ObjectClass.ACCOUNT);
        actual = new ObjectClass("babbo");
        Assertions.assertFalse((boolean)actual.equals(ObjectClass.ACCOUNT));
        ObjectClass expected = new ObjectClass("babbo");
        Assertions.assertEquals((Object)actual, (Object)expected);
        ObjectClass lower = new ObjectClass("group");
        ObjectClass mixed = new ObjectClass("Group");
        Assertions.assertEquals((Object)lower, (Object)mixed);
    }

    @Test
    public void testHashCode() {
        HashSet<ObjectClass> set = new HashSet<ObjectClass>();
        set.add(ObjectClass.ACCOUNT);
        set.add(ObjectClass.GROUP);
        set.add(ObjectClass.ACCOUNT);
        Assertions.assertEquals((int)2, (int)set.size());
        Assertions.assertTrue((boolean)set.contains(ObjectClass.ACCOUNT));
        Assertions.assertTrue((boolean)set.contains(ObjectClass.GROUP));
        set = new HashSet();
        set.add(new ObjectClass("group"));
        set.add(new ObjectClass("Group"));
        Assertions.assertEquals((int)1, (int)set.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEqualsObservesLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr"));
            ObjectClass oc1 = new ObjectClass("i");
            ObjectClass oc2 = new ObjectClass("I");
            Assertions.assertFalse((boolean)oc1.equals((Object)oc2));
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHashCodeIndependentOnLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            ObjectClass attribute = new ObjectClass("i");
            int hash1 = attribute.hashCode();
            Locale.setDefault(new Locale("tr"));
            int hash2 = attribute.hashCode();
            Assertions.assertEquals((int)hash1, (int)hash2);
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }
}

