/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Uid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AttributeUtilTests {
    public void testGetStringValue() {
        Assertions.assertThrows(ClassCastException.class, () -> {
            String TEST_VALUE = "test value";
            Attribute attr = AttributeBuilder.build((String)"string", (Object[])new Object[]{"test value"});
            String value = AttributeUtil.getStringValue((Attribute)attr);
            Assertions.assertEquals((Object)value, (Object)"test value");
            attr = AttributeBuilder.build((String)"stirng");
            value = AttributeUtil.getStringValue((Attribute)attr);
            Assertions.assertNull((Object)value);
            attr = AttributeBuilder.build((String)"string", (Object[])new Object[]{1});
            AttributeUtil.getStringValue((Attribute)attr);
        });
    }

    @Test
    public void testGetAsStringValue() {
        String TEST_VALUE = "test value";
        Attribute attr = AttributeBuilder.build((String)"string", (Object[])new Object[]{"test value"});
        String value = AttributeUtil.getAsStringValue((Attribute)attr);
        Assertions.assertEquals((Object)value, (Object)"test value");
        attr = AttributeBuilder.build((String)"stirng");
        value = AttributeUtil.getStringValue((Attribute)attr);
        Assertions.assertNull((Object)value);
        attr = AttributeBuilder.build((String)"string", (Object[])new Object[]{1});
        value = AttributeUtil.getAsStringValue((Attribute)attr);
        Assertions.assertEquals((Object)value, (Object)"1");
    }

    public void testGetIntegerValue() {
        Assertions.assertThrows(ClassCastException.class, () -> {
            Integer TEST_VALUE = 1;
            Attribute attr = AttributeBuilder.build((String)"int", (Object[])new Object[]{TEST_VALUE});
            Integer value = AttributeUtil.getIntegerValue((Attribute)attr);
            Assertions.assertEquals((Object)value, (Object)TEST_VALUE);
            attr = AttributeBuilder.build((String)"int");
            value = AttributeUtil.getIntegerValue((Attribute)attr);
            Assertions.assertNull((Object)value);
            attr = AttributeBuilder.build((String)"int", (Object[])new Object[]{"1"});
            value = AttributeUtil.getIntegerValue((Attribute)attr);
        });
    }

    public void testGetLongValue() {
        Assertions.assertThrows(ClassCastException.class, () -> {
            Long TEST_VALUE = 1L;
            Attribute attr = AttributeBuilder.build((String)"long", (Object[])new Object[]{TEST_VALUE});
            Long value = AttributeUtil.getLongValue((Attribute)attr);
            Assertions.assertEquals((Object)value, (Object)TEST_VALUE);
            attr = AttributeBuilder.build((String)"long");
            value = AttributeUtil.getLongValue((Attribute)attr);
            Assertions.assertNull((Object)value);
            attr = AttributeBuilder.build((String)"long", (Object[])new Object[]{"1"});
            value = AttributeUtil.getLongValue((Attribute)attr);
        });
    }

    public void testBigDecimalValue() {
        Assertions.assertThrows(ClassCastException.class, () -> {
            BigDecimal TEST_VALUE = BigDecimal.ONE;
            Attribute attr = AttributeBuilder.build((String)"big", (Object[])new Object[]{TEST_VALUE});
            BigDecimal value = AttributeUtil.getBigDecimalValue((Attribute)attr);
            Assertions.assertEquals((Object)value, (Object)TEST_VALUE);
            attr = AttributeBuilder.build((String)"big");
            value = AttributeUtil.getBigDecimalValue((Attribute)attr);
            Assertions.assertNull((Object)value);
            attr = AttributeBuilder.build((String)"big", (Object[])new Object[]{"1"});
            value = AttributeUtil.getBigDecimalValue((Attribute)attr);
        });
    }

    public void testGetSingleValue() {
        Assertions.assertThrows(ClassCastException.class, () -> {
            Long TEST_VALUE = 1L;
            Attribute attr = AttributeBuilder.build((String)"long", (Object[])new Object[]{TEST_VALUE});
            Object value = AttributeUtil.getSingleValue((Attribute)attr);
            Assertions.assertEquals((Object)value, (Object)TEST_VALUE);
            attr = AttributeBuilder.build((String)"long");
            value = AttributeUtil.getSingleValue((Attribute)attr);
            Assertions.assertNull((Object)value);
            attr = AttributeBuilder.build((String)"long", Collections.emptyList());
            value = AttributeUtil.getSingleValue((Attribute)attr);
            Assertions.assertNull((Object)value);
            AttributeUtil.getSingleValue((Attribute)AttributeBuilder.build((String)"bob", (Object[])new Object[]{1, 2, 3}));
        });
    }

    @Test
    public void testToMap() {
        HashMap<String, Attribute> expected = new HashMap<String, Attribute>();
        Attribute attr = AttributeBuilder.build((String)"daf", (Object[])new Object[]{"daf"});
        expected.put(attr.getName(), attr);
        attr = AttributeBuilder.build((String)"fasdf", (Object[])new Object[]{"fadsf3"});
        expected.put(attr.getName(), attr);
        Map actual = AttributeUtil.toMap(expected.values());
        Assertions.assertEquals((Object)actual, expected);
    }

    @Test
    public void testGetUidAttribute() {
        HashSet<Object> attrs = new HashSet<Object>();
        Uid expected = new Uid("1");
        attrs.add(expected);
        Attribute attr = AttributeBuilder.build((String)"bob");
        attrs.add(attr);
        Uid actual = AttributeUtil.getUidAttribute(attrs);
        Assertions.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testGetBasicAttributes() {
        HashSet<Object> set = new HashSet<Object>();
        set.add(new Uid("1"));
        Attribute attr = AttributeBuilder.build((String)"bob");
        set.add(attr);
        Set actual = AttributeUtil.getBasicAttributes(set);
        HashSet<Attribute> expected = new HashSet<Attribute>();
        expected.add(attr);
        Assertions.assertEquals((Object)actual, expected);
    }

    @Test
    public void testIsSpecial() {
        Assertions.assertTrue((boolean)AttributeUtil.isSpecial((Attribute)new Uid("1")));
        Assertions.assertFalse((boolean)AttributeUtil.isSpecial((Attribute)AttributeBuilder.build((String)"b")));
    }

    @Test
    public void testNamesEqual() {
        Assertions.assertTrue((boolean)AttributeUtil.namesEqual((String)"givenName", (String)"givenname"));
    }

    @Test
    public void testIsMethod() {
        Assertions.assertTrue((boolean)AttributeBuilder.build((String)"fad").is("Fad"));
        Assertions.assertFalse((boolean)AttributeBuilder.build((String)"fadsf").is("f"));
    }

    @Test
    public void testFindMethod() {
        Attribute expected = AttributeBuilder.build((String)"FIND_ME");
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        attrs.add(AttributeBuilder.build((String)"fadsf"));
        attrs.add(AttributeBuilder.build((String)"fadsfadsf"));
        attrs.add(expected);
        Assertions.assertEquals((Object)AttributeUtil.find((String)"FIND_ME", attrs), (Object)expected);
        Assertions.assertTrue((AttributeUtil.find((String)"Daffff", attrs) == null ? 1 : 0) != 0);
    }

    @Test
    public void testEnableDate() {
        Date expected = new Date();
        HashSet<Attribute> set = new HashSet<Attribute>();
        set.add(AttributeBuilder.buildEnableDate((Date)expected));
        Date actual = AttributeUtil.getEnableDate(set);
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)actual, (Object)expected);
    }
}

