/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashSet;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AttributeInfoUtilTests {
    @Test
    public void testIsMethod() {
        Assertions.assertTrue((boolean)AttributeInfoBuilder.build((String)"fad").is("Fad"));
        Assertions.assertFalse((boolean)AttributeInfoBuilder.build((String)"fadsf").is("f"));
    }

    @Test
    public void testFindMethod() {
        AttributeInfo expected = AttributeInfoBuilder.build((String)"FIND_ME");
        HashSet<AttributeInfo> attrs = new HashSet<AttributeInfo>();
        attrs.add(AttributeInfoBuilder.build((String)"fadsf"));
        attrs.add(AttributeInfoBuilder.build((String)"fadsfadsf"));
        attrs.add(expected);
        Assertions.assertEquals((Object)AttributeInfoUtil.find((String)"FIND_ME", attrs), (Object)expected);
        Assertions.assertTrue((AttributeInfoUtil.find((String)"Daffff", attrs) == null ? 1 : 0) != 0);
    }

    public void testPasswordBuild() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AttributeInfoBuilder.build((String)OperationalAttributes.PASSWORD_NAME));
    }

    public void testCurrentPasswordBuild() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> AttributeInfoBuilder.build((String)OperationalAttributes.CURRENT_PASSWORD_NAME));
    }

    @Test
    public void testRegularPassword() {
        AttributeInfoBuilder.build((String)OperationalAttributes.PASSWORD_NAME, GuardedString.class);
    }
}

