/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.identityconnectors.common.security.Encryptor;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.common.security.SimpleEncryptor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GuardedByteArrayTests {
    @BeforeEach
    public void setUp() {
        GuardedByteArray.setEncryptor((Encryptor)new SimpleEncryptor());
    }

    @AfterEach
    public void tearDown() {
        GuardedByteArray.setEncryptor(null);
    }

    @Test
    public void testBasics() {
        GuardedByteArray bytes = new GuardedByteArray(new byte[]{0, 1, 2});
        Assertions.assertTrue((boolean)Arrays.equals(this.decryptToBytes(bytes), new byte[]{0, 1, 2}));
        Assertions.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2}, this.decryptToBytes(bytes)));
        bytes.appendByte((byte)3);
        Assertions.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2, 3}, this.decryptToBytes(bytes)));
        Assertions.assertFalse((boolean)bytes.verifyBase64SHA1Hash(SecurityUtil.computeBase64SHA1Hash((byte[])new byte[]{0, 1, 2})));
        Assertions.assertTrue((boolean)bytes.verifyBase64SHA1Hash(SecurityUtil.computeBase64SHA1Hash((byte[])new byte[]{0, 1, 2, 3})));
    }

    @Test
    public void testEquals() {
        GuardedByteArray bytes1 = new GuardedByteArray();
        GuardedByteArray bytes2 = new GuardedByteArray();
        Assertions.assertEquals((Object)bytes1, (Object)bytes2);
        bytes2.appendByte((byte)3);
        Assertions.assertFalse((boolean)bytes1.equals((Object)bytes2));
        bytes1.appendByte((byte)3);
        Assertions.assertEquals((Object)bytes1, (Object)bytes2);
    }

    @Test
    public void testReadOnly() {
        GuardedByteArray bytes = new GuardedByteArray(new byte[]{0, 1, 2});
        Assertions.assertFalse((boolean)bytes.isReadOnly());
        bytes.makeReadOnly();
        Assertions.assertTrue((boolean)bytes.isReadOnly());
        Assertions.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2}, this.decryptToBytes(bytes)));
        try {
            bytes.appendByte((byte)3);
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        bytes = bytes.copy();
        Assertions.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2}, this.decryptToBytes(bytes)));
        bytes.appendByte((byte)3);
        Assertions.assertTrue((boolean)Arrays.equals(new byte[]{0, 1, 2, 3}, this.decryptToBytes(bytes)));
    }

    @Test
    public void testDispose() {
        GuardedByteArray str = new GuardedByteArray(new byte[]{0, 1, 2});
        str.dispose();
        try {
            this.decryptToBytes(str);
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.isReadOnly();
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.appendByte((byte)3);
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.copy();
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str.verifyBase64SHA1Hash("foo");
            Assertions.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRange() {
        for (int i = -128; i < 128; ++i) {
            byte expected = (byte)i;
            GuardedByteArray bytes = new GuardedByteArray(new byte[]{(byte)i});
            bytes.access(clearBytes -> {
                byte v = clearBytes[0];
                Assertions.assertEquals((byte)v, (byte)expected);
            });
        }
    }

    private byte[] decryptToBytes(GuardedByteArray bytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bytes.access(bytes1 -> out.write(bytes1, 0, bytes1.length));
        return out.toByteArray();
    }
}

