/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.logging.LogSpi;
import org.identityconnectors.common.logging.StdOutLogger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogTests {
    @Test
    public void checkIsLoggableMethods() {
        MockLogSpi spi = new MockLogSpi();
        Log log = Log.getLog(String.class, (LogSpi)spi);
        spi._isloggable = false;
        Assertions.assertFalse((boolean)log.isError());
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        spi._isloggable = true;
        Assertions.assertTrue((boolean)log.isError());
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        Assertions.assertNull((Object)spi._methodName);
        spi._isloggable = false;
        Assertions.assertFalse((boolean)log.isInfo());
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.INFO);
        spi._isloggable = true;
        Assertions.assertTrue((boolean)log.isInfo());
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.INFO);
        Assertions.assertNull((Object)spi._methodName);
        spi._isloggable = false;
        Assertions.assertFalse((boolean)log.isOk());
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.OK);
        spi._isloggable = true;
        Assertions.assertTrue((boolean)log.isOk());
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.OK);
        Assertions.assertNull((Object)spi._methodName);
        spi._isloggable = false;
        Assertions.assertFalse((boolean)log.isWarning());
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.WARN);
        spi._isloggable = true;
        Assertions.assertTrue((boolean)log.isWarning());
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.WARN);
        for (Log.Level level : Log.Level.values()) {
            spi._isloggable = false;
            Assertions.assertFalse((boolean)log.isLoggable(level));
            Assertions.assertEquals((Object)spi._level, (Object)level);
            spi._isloggable = true;
            Assertions.assertTrue((boolean)log.isLoggable(level));
            Assertions.assertEquals((Object)spi._level, (Object)level);
            Assertions.assertEquals(spi._class, String.class);
            Assertions.assertNull((Object)spi._methodName);
        }
    }

    @Test
    public void checkMessageLog() {
        String METHOD = "checkMessageLog";
        String EXPECTED_MSG = "any old message will do";
        MockLogSpi spi = new MockLogSpi();
        Log log = Log.getLog(String.class, (LogSpi)spi);
        spi._message = null;
        spi._isloggable = false;
        log.error("any old message will do", new Object[0]);
        Assertions.assertNull((Object)spi._message);
        Assertions.assertEquals(spi._class, String.class);
        spi._isloggable = true;
        log.error("any old message will do", new Object[0]);
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        Assertions.assertEquals((Object)spi._message, (Object)"any old message will do");
        Assertions.assertEquals(spi._class, String.class);
        Assertions.assertEquals((Object)spi._methodName, (Object)"checkMessageLog");
    }

    @Test
    public void checkFullLogMessage() {
        String EXPECTED = "some message: {0}";
        MockLogSpi spi = new MockLogSpi();
        Log log = Log.getLog(String.class, (LogSpi)spi);
        spi._isloggable = false;
        log.log(Log.Level.INFO, (Throwable)new Exception(), "some message: {0}", new Object[]{1});
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.INFO);
        Assertions.assertEquals(spi._class, String.class);
        Assertions.assertNull((Object)spi._message);
        Assertions.assertNull((Object)spi._exception);
        Assertions.assertFalse((boolean)spi._isloggable);
        spi = new MockLogSpi();
        log = Log.getLog(String.class, (LogSpi)spi);
        spi._isloggable = true;
        Exception EX = new Exception();
        log.log(Log.Level.ERROR, (Throwable)EX, "some message: {0}", new Object[]{1});
        Assertions.assertEquals((Object)spi._message, (Object)"some message: 1");
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        Assertions.assertEquals(spi._class, String.class);
        Assertions.assertEquals((Object)spi._exception, (Object)EX);
        Assertions.assertTrue((boolean)spi._isloggable);
        spi = new MockLogSpi();
        log = Log.getLog(String.class, (LogSpi)spi);
        spi._isloggable = true;
        String EX_MSG = "dafdslfkj";
        log.log(Log.Level.ERROR, (Throwable)new Exception("dafdslfkj"), null, new Object[0]);
        Assertions.assertEquals((Object)spi._level, (Object)Log.Level.ERROR);
        Assertions.assertEquals(spi._class, String.class);
        Assertions.assertEquals((Object)spi._message, (Object)"dafdslfkj");
    }

    @Test
    public void checkBasicLogging() {
        for (Log.Level level : Log.Level.values()) {
            String EXPECTED_MSG = "Message: " + level;
            MockLogSpi spi = new MockLogSpi();
            spi._isloggable = true;
            Log log = Log.getLog(String.class, (LogSpi)spi);
            if (Log.Level.ERROR.equals((Object)level)) {
                log.error(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.INFO.equals((Object)level)) {
                log.info(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.OK.equals((Object)level)) {
                log.ok(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.WARN.equals((Object)level)) {
                log.warn(EXPECTED_MSG, new Object[0]);
            }
            Assertions.assertNull((Object)spi._exception);
            Assertions.assertTrue((boolean)spi._isloggable);
            Assertions.assertEquals((Object)spi._level, (Object)level);
            Assertions.assertEquals(spi._class, String.class);
            Assertions.assertEquals((Object)spi._message, (Object)EXPECTED_MSG);
        }
    }

    @Test
    public void checkBasicLoggingOff() {
        for (Log.Level level : Log.Level.values()) {
            String EXPECTED_MSG = "Message: " + level;
            MockLogSpi spi = new MockLogSpi();
            spi._isloggable = false;
            Log log = Log.getLog(String.class, (LogSpi)spi);
            if (Log.Level.ERROR.equals((Object)level)) {
                log.error(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.INFO.equals((Object)level)) {
                log.info(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.OK.equals((Object)level)) {
                log.ok(EXPECTED_MSG, new Object[0]);
            } else if (Log.Level.WARN.equals((Object)level)) {
                log.warn(EXPECTED_MSG, new Object[0]);
            }
            Assertions.assertNull((Object)spi._message);
            Assertions.assertNull((Object)spi._exception);
            Assertions.assertFalse((boolean)spi._isloggable);
            Assertions.assertEquals((Object)spi._level, (Object)level);
            Assertions.assertEquals(spi._class, String.class);
        }
    }

    @Test
    public void checkBasicLoggingWithFormating() {
        for (Log.Level level : Log.Level.values()) {
            String FORMAT = "Message: {0}";
            String EXPECTED_MSG = "Message: " + level;
            MockLogSpi spi = new MockLogSpi();
            spi._isloggable = true;
            Log log = Log.getLog(String.class, (LogSpi)spi);
            if (Log.Level.ERROR.equals((Object)level)) {
                log.error("Message: {0}", new Object[]{level});
            } else if (Log.Level.INFO.equals((Object)level)) {
                log.info("Message: {0}", new Object[]{level});
            } else if (Log.Level.OK.equals((Object)level)) {
                log.ok("Message: {0}", new Object[]{level});
            } else if (Log.Level.WARN.equals((Object)level)) {
                log.warn("Message: {0}", new Object[]{level});
            }
            Assertions.assertEquals((Object)spi._message, (Object)EXPECTED_MSG);
            Assertions.assertNull((Object)spi._exception);
            Assertions.assertTrue((boolean)spi._isloggable);
            Assertions.assertEquals((Object)level, (Object)spi._level);
            Assertions.assertEquals(spi._class, String.class);
        }
    }

    @Test
    public void checkBasicLoggingWithExceptionAndFormating() {
        for (Log.Level level : Log.Level.values()) {
            String FORMAT = "Message: {0}";
            String EXPECTED_MSG = "Message: " + level;
            Exception EXPECTED_EX = new Exception(level.toString());
            MockLogSpi spi = new MockLogSpi();
            spi._isloggable = true;
            Log log = Log.getLog(String.class, (LogSpi)spi);
            if (Log.Level.ERROR.equals((Object)level)) {
                log.error((Throwable)EXPECTED_EX, "Message: {0}", new Object[]{level});
            } else if (Log.Level.INFO.equals((Object)level)) {
                log.info((Throwable)EXPECTED_EX, "Message: {0}", new Object[]{level});
            } else if (Log.Level.OK.equals((Object)level)) {
                log.ok((Throwable)EXPECTED_EX, "Message: {0}", new Object[]{level});
            } else if (Log.Level.WARN.equals((Object)level)) {
                log.warn((Throwable)EXPECTED_EX, "Message: {0}", new Object[]{level});
            }
            Assertions.assertEquals((Object)spi._message, (Object)EXPECTED_MSG);
            Assertions.assertTrue((boolean)spi._isloggable);
            Assertions.assertEquals((Object)level, (Object)spi._level);
            Assertions.assertEquals(spi._class, String.class);
            Assertions.assertEquals((Object)spi._exception, (Object)EXPECTED_EX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkSystemProperty() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            Class orig = Log.getSpiClass();
            try {
                Log.getLog(String.class);
                Assertions.assertEquals((Object)Log.getSpiClass(), StdOutLogger.class);
                Log.setSpiClass(null);
                System.setProperty(Log.LOGSPI_PROP, MockLogSpi.class.getName());
                Log.getLog(String.class);
                Assertions.assertEquals((Object)Log.getSpiClass(), MockLogSpi.class);
                System.setProperty(Log.LOGSPI_PROP, StdOutLogger.class.getName());
                Assertions.assertEquals((Object)Log.getSpiClass(), MockLogSpi.class);
            }
            finally {
                Log.setSpiClass((Class)orig);
                System.clearProperty(Log.LOGSPI_PROP);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void checkGetLog() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Log.getLog(MockLogSpi.class));
    }

    public static class MockLogSpi
    implements LogSpi {
        public Log.Level _level = null;
        public Class<?> _class = null;
        public String _message = null;
        public String _methodName = null;
        public Throwable _exception = null;
        public boolean _isloggable = false;

        public boolean isLoggable(Class<?> clazz, Log.Level level) {
            this._class = clazz;
            this._level = level;
            return this._isloggable;
        }

        public boolean needToInferCaller(Class<?> clazz, Log.Level level) {
            return true;
        }

        public void log(Class<?> clazz, String methodName, Log.Level level, String message, Throwable ex) {
            this._class = clazz;
            this._level = level;
            this._exception = ex;
            this._message = message;
            this._methodName = methodName;
        }

        public void log(Class<?> clazz, StackTraceElement caller, Log.Level level, String message, Throwable ex) {
            this._class = clazz;
            this._level = level;
            this._exception = ex;
            this._message = message;
            this._methodName = null != caller ? caller.getMethodName() : "unknown";
        }
    }
}

