/*
 * ====================
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2008-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License("CDDL") (the "License").  You may not use this file
 * except in compliance with the License.
 *
 * You can obtain a copy of the License at
 * http://opensource.org/licenses/cddl1.php
 * See the License for the specific language governing permissions and limitations
 * under the License.
 *
 * When distributing the Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://opensource.org/licenses/cddl1.php.
 * If applicable, add the following below this CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * ====================
 */
package org.identityconnectors.framework.spi.operations;

import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.Connector;

/**
 * Operation interface to delete objects from the target resource. The
 * {@link Uid} must be provided.
 *
 * @author Will Droste
 * @since 1.0
 */
public interface DeleteOp extends SPIOperation {

    /**
     * The {@link Connector} developer is responsible for calling the native
     * delete methods to remove the object specified by its unique id.
     *
     * @param objectClass
     *            type of object to delete.
     * @param uid
     *            The unique id that specifies the object to delete.
     * @param options
     *            additional options that impact the way this operation is run.
     *            If the caller passes null, the framework will convert this
     *            into an empty set of options, so SPI need not worry about this
     *            ever being null.
     * @throws org.identityconnectors.framework.common.exceptions.UnknownUidException
     *             if the {@link Uid} does not exist on the resource.
     */
    void delete(final ObjectClass objectClass, final Uid uid, final OperationOptions options);
}
