/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashSet;
import java.util.Locale;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IterableAssert;
import org.identityconnectors.framework.common.objects.LocaleTestUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ObjectClassTests {
    @BeforeMethod
    public void before() {
        LocaleTestUtil.resetLocaleCache();
    }

    @Test
    public void testIs() {
        ObjectClass actual = new ObjectClass("group");
        Assert.assertTrue((boolean)actual.is("group"));
        Assert.assertTrue((boolean)actual.is("Group"));
        Assert.assertFalse((boolean)actual.is("admin"));
    }

    @Test
    public void testEquals() {
        ObjectClass actual = new ObjectClass(ObjectClass.ACCOUNT_NAME);
        Assert.assertEquals((Object)actual, (Object)ObjectClass.ACCOUNT);
        actual = new ObjectClass("babbo");
        Assert.assertFalse((boolean)actual.equals(ObjectClass.ACCOUNT));
        ObjectClass expected = new ObjectClass("babbo");
        Assert.assertEquals((Object)actual, (Object)expected);
        ObjectClass lower = new ObjectClass("group");
        ObjectClass mixed = new ObjectClass("Group");
        Assert.assertEquals((Object)lower, (Object)mixed);
    }

    @Test
    public void testHashCode() {
        HashSet<ObjectClass> set = new HashSet<ObjectClass>();
        set.add(ObjectClass.ACCOUNT);
        set.add(ObjectClass.GROUP);
        set.add(ObjectClass.ACCOUNT);
        ((IterableAssert)Assertions.assertThat(set).hasSize(2)).contains((Object[])new ObjectClass[]{ObjectClass.ACCOUNT, ObjectClass.GROUP});
        set = new HashSet();
        set.add(new ObjectClass("group"));
        set.add(new ObjectClass("Group"));
        Assertions.assertThat(set).hasSize(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEqualsObservesLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr"));
            ObjectClass oc1 = new ObjectClass("i");
            ObjectClass oc2 = new ObjectClass("I");
            Assert.assertFalse((boolean)oc1.equals((Object)oc2));
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHashCodeIndependentOnLocale() {
        Locale defLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.US);
            ObjectClass attribute = new ObjectClass("i");
            int hash1 = attribute.hashCode();
            Locale.setDefault(new Locale("tr"));
            int hash2 = attribute.hashCode();
            Assert.assertEquals((int)hash1, (int)hash2);
        }
        finally {
            Locale.setDefault(defLocale);
        }
    }
}

